/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.ProxyDeltaProvider;
import com.tssap.selena.internal.model.providers.proxy.ProxyModelRegistry;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;

public final class ProxyPlugin
extends Plugin {
    public static final String ID = "com.tssap.selena.model.providers.proxy";
    public static final String TRACE_DEBUG_OPTION = "/debug/trace";
    public static final String DELTA_DEBUG_OPTION = "/debug/delta";
    public static final String MDNK_CHANGED_IMAGE = "proxy.mdnk.changed";
    public static final String MDNK_DELETED_IMAGE = "proxy.mdnk.deleted";
    public static final String MDNK_NEW_IMAGE = "proxy.mdnk.new";
    public static final String MDNK_TCHANGED_IMAGE = "proxy.mdnk.tchanged";
    public static final String PROXY_IMAGE = "proxy.proxy";
    public static final String PROXY_MODEL_IMAGE = "proxy.proxy.model";
    public static final String PROXY_OBJECT_IMAGE = "proxy.proxy.object";
    public static final String PROXY_PARAMETER_IMAGE = "proxy.proxy.parameter";
    public static final String SNAPSHOT_IMAGE = "proxy.snapshot";
    public static final String SOURCE_MODEL_IMAGE = "proxy.source.model";
    public static final String SOURCE_OBJECT_IMAGE = "proxy.source.object";
    public static final String UIN_IMAGE = "proxy.uin";
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static ProxyPlugin ourInstance;
    private static Map ourDeltaProviders;
    private static Collection ourRules;

    public ProxyPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = ProxyPlugin.getTraceDebugOption(descriptor);
        this.myDebuggingDelta = ProxyPlugin.getDeltaDebugOption(descriptor);
        ProxyPlugin.logInfo("init [" + (Object)((Object)ourInstance) + "]");
    }

    static ProxyPlugin getDefault() {
        return ourInstance;
    }

    public static Image getImage(String id) {
        return ChromePlugin.getInstance().getImageBundle().getImage(id);
    }

    public static boolean getDebugOption(IPluginDescriptor descriptor, String name) {
        String key = descriptor.getUniqueIdentifier() + name;
        String value = Platform.getDebugOption((String)key);
        return Boolean.valueOf(value);
    }

    public static boolean getTraceDebugOption(IPluginDescriptor descriptor) {
        return ProxyPlugin.getDebugOption(descriptor, TRACE_DEBUG_OPTION);
    }

    public static boolean getDeltaDebugOption(IPluginDescriptor descriptor) {
        return ProxyPlugin.getDebugOption(descriptor, DELTA_DEBUG_OPTION);
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        ProxyPlugin instance = ProxyPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        ProxyPlugin.log(1, text);
    }

    public static void logError(String text) {
        ProxyPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        ProxyPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        ProxyPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        ProxyPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        ProxyPlugin instance = ProxyPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            ProxyPlugin.log(type, text, new Throwable());
        } else {
            ProxyPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        ProxyPlugin instance = ProxyPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }

    static void registerDeltaProvider(UniqueName model, ProxyDeltaProvider deltaProvider) {
        ourDeltaProviders.put(model, deltaProvider);
    }

    static void unregisterDeltaProvider(UniqueName model) {
        ourDeltaProviders.remove(model);
    }

    public static ProxyDeltaProvider[] getDeltaProviders() {
        return ourDeltaProviders.values().toArray(new ProxyDeltaProvider[ourDeltaProviders.values().size()]);
    }

    public static ProxyDeltaProvider getDeltaProvider(UniqueName model) {
        return (ProxyDeltaProvider)ourDeltaProviders.get(model);
    }

    public static ProxyModelRegistry getModelRegistry(UniqueName proxyModel, Model sourceModel) {
        ProxyDeltaProvider provider = ProxyPlugin.getDeltaProvider(proxyModel);
        if (provider == null) {
            return null;
        }
        return provider.getModelRegistry(sourceModel);
    }

    public static void bind(UniqueName proxy, UniqueName proxyModel) {
        ProxyPlugin.getModelRegistry(proxyModel, ProxyMetaInfo.getSourceModel(proxy)).bind(proxy);
    }

    static void reloadRules() {
        ProxyPlugin plugin = ProxyPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        if (ourRules == null) {
            ourRules = new ArrayList();
        } else {
            ourRules.clear();
        }
        IExtensionPoint rulesPoint = plugin.getDescriptor().getExtensionPoint("rule");
        if (rulesPoint == null) {
            return;
        }
        IConfigurationElement[] rules = rulesPoint.getConfigurationElements();
        int i = 0;
        while (i < rules.length) {
            IConfigurationElement rule = rules[i];
            String className = rule.getAttribute("class");
            try {
                ProxyRule pr = (ProxyRule)rule.createExecutableExtension("class");
                ourRules.add(pr);
                ProxyPlugin.logInfo("proxy rule loaded : " + pr);
            }
            catch (Exception e) {
                ProxyPlugin.logError("unable to load proxy rule " + className, e);
            }
            ++i;
        }
    }

    static ProxyRule[] getRules() {
        if (ourRules == null) {
            ProxyPlugin.reloadRules();
        }
        if (ourRules == null) {
            return null;
        }
        return ourRules.toArray(new ProxyRule[ourRules.size()]);
    }

    static {
        ourDeltaProviders = new HashMap();
    }
}

