/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.CleanProxyModelDeltaNode;
import com.tssap.selena.internal.model.providers.proxy.ProxyDeltaProvider;
import com.tssap.selena.internal.model.providers.proxy.ProxyModelDeltaNode;
import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.internal.model.providers.proxy.UniqueNameHashMap;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import com.tssap.selena.model.util.various.DeltaDumper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProxyModelRegistry
implements ModelChangeListener {
    private UniqueNameHashMap myProxies = new UniqueNameHashMap();
    private Model mySourceModel;
    private DeltaSource myDeltaSource;
    private ProxyRule[] myRules;

    ProxyModelRegistry(Model sourceModel, DeltaSource deltaSource) {
        this.mySourceModel = sourceModel;
        this.myDeltaSource = deltaSource;
        sourceModel.addModelDeltaListener((ModelChangeListener)this);
    }

    void destroy() {
        this.getSourceModel().removeModelDeltaListener((ModelChangeListener)this);
    }

    public String toString() {
        return "registry p [" + this.myDeltaSource.getModel() + "] -> s [" + this.mySourceModel + "]";
    }

    public Model getSourceModel() {
        return this.mySourceModel;
    }

    public Map getBindingsCopy() {
        return new HashMap(this.myProxies);
    }

    public boolean isEmpty() {
        return this.myProxies.isEmpty();
    }

    public boolean bind(UniqueName proxy) {
        UniqueName source = ProxyMetaInfo.getSourceUniqueName(proxy);
        return this.bind(source, proxy);
    }

    private boolean bind(UniqueName source, UniqueName proxy) {
        ProxyDeltaProvider provider;
        if (!ProxyMetaInfo.isAutoProxyUniqueName(proxy) && (provider = this.getSourceProvider()) != null) {
            provider.cacheParents(source, null);
        }
        return this.myProxies.bind(source, proxy);
    }

    public void unbind(UniqueName proxy) {
        UniqueName source = ProxyMetaInfo.getSourceUniqueName(proxy);
        this.unbind(source, proxy);
    }

    private void unbind(UniqueName source, UniqueName proxy) {
        ProxyDeltaProvider provider;
        this.unbindHelper(source, proxy);
        if (!ProxyMetaInfo.isAutoProxyUniqueName(proxy) && (provider = this.getSourceProvider()) != null) {
            provider.dropParents(source);
        }
    }

    private void unbindHelper(UniqueName source, UniqueName proxy) {
        if (source == null) {
            source = ProxyMetaInfo.getSourceUniqueName(proxy);
        }
        this.myProxies.unbind(source, proxy);
        List children = this.getChildProxies(proxy);
        int i = children.size() - 1;
        while (i >= 0) {
            this.unbindHelper(null, (UniqueName)children.get(i));
            --i;
        }
    }

    boolean hasRootProxies(UniqueName source) {
        List proxies = this.myProxies.getAsList(source, false);
        int i = proxies.size() - 1;
        while (i >= 0) {
            if (!ProxyMetaInfo.isAutoProxyUniqueName((UniqueName)proxies.get(i))) {
                return true;
            }
            --i;
        }
        return false;
    }

    public List getChildProxies(UniqueName proxy) {
        ArrayList children = new ArrayList();
        Iterator bindings = this.myProxies.values().iterator();
        while (bindings.hasNext()) {
            Object bound = bindings.next();
            if (bound instanceof UniqueName) {
                this.visitBoundProxy(children, proxy, (UniqueName)bound);
                continue;
            }
            if (!(bound instanceof List)) continue;
            List proxies = (List)bound;
            int i = proxies.size() - 1;
            while (i >= 0) {
                this.visitBoundProxy(children, proxy, (UniqueName)proxies.get(i));
                --i;
            }
        }
        return children;
    }

    private void visitBoundProxy(List children, UniqueName proxy, UniqueName bound) {
        UniqueName parent = ProxyMetaInfo.getParentUniqueName(bound);
        if (parent.equals(proxy)) {
            children.add(bound);
        }
    }

    public void kill() {
        boolean updateRequired = false;
        Iterator proxies = this.myProxies.values().iterator();
        while (proxies.hasNext()) {
            Object proxyObj = proxies.next();
            if (proxyObj instanceof UniqueName) {
                updateRequired |= this.kill((UniqueName)proxyObj);
                continue;
            }
            if (!(proxyObj instanceof List)) continue;
            List proxyList = (List)proxyObj;
            int i = 0;
            while (i < proxyList.size()) {
                updateRequired |= this.kill((UniqueName)proxyList.get(i));
                ++i;
            }
        }
        if (updateRequired) {
            this.myDeltaSource.getModel().getExtensionManager().modelContentsChanged();
        }
    }

    private boolean kill(UniqueName uin) {
        if (ProxyMetaInfo.isAutoProxyUniqueName(uin)) {
            return false;
        }
        this.myDeltaSource.getDelta().addDeltaNode((TreeModelDeltaNode)new CleanProxyModelDeltaNode(this.myDeltaSource.getModel(), uin, ModelDeltaNodeKind.TOTALLY_CHANGED));
        return true;
    }

    public void modelChanged(final ModelChangeEvent changeEvent) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                Model sourceModel = changeEvent.getModel();
                if (ProxyPlugin.getDefault().isDebuggingDelta()) {
                    String msg = "source delta in source model";
                    if (changeEvent.getRootDelta().isEmpty()) {
                        msg = msg + " (empty)";
                    }
                    msg = msg + " in " + changeEvent.getModel();
                    ProxyPlugin.logInfo(msg);
                    System.err.println("\n\\/ s \\/ s \\/ s \\/ s \\/ s \\/ s \\/ s \\/ source delta \\/ s \\/ s \\/ s \\/ s \\/ s \\/ s \\/ s \\/");
                    DeltaDumper.dumpDelta((ModelDeltaNode)changeEvent.getRootDelta());
                    System.err.println("/\\ s /\\ s /\\ s /\\ s /\\ s /\\ s /\\ s /\\ source delta /\\ s /\\ s /\\ s /\\ s /\\ s /\\ s /\\ s /\\\n");
                }
                if (!sourceModel.equals(ProxyModelRegistry.this.getSourceModel())) {
                    ProxyPlugin.logError("proxy model registry for the [" + ProxyModelRegistry.this.getSourceModel() + "] received delta in the [" + sourceModel + "]");
                    return;
                }
                if (ProxyModelRegistry.this.visit(changeEvent.getRootDelta())) {
                    ProxyPlugin.logInfo("proxy model is changed");
                    ProxyModelRegistry.this.myDeltaSource.getModel().getExtensionManager().modelContentsChanged();
                }
            }
        }, (String)"proxy delta handler in source model");
    }

    private boolean visit(ModelDeltaNode sourceNode) {
        if (sourceNode.isTotallyChanged()) {
            return this.visitStructurallyChangedSource(sourceNode.getElementUniqueName(), sourceNode.getOriginalElementUniqueName());
        }
        if (sourceNode.isNew()) {
            return this.visitNewSourceNode(sourceNode) | this.visitRules(sourceNode);
        }
        if (sourceNode.isDeleted()) {
            return this.visitStructurallyChangedSource(sourceNode.getElementUniqueName(), sourceNode.getOriginalElementUniqueName());
        }
        boolean updateRequired = false;
        if (sourceNode.isChanged()) {
            updateRequired |= this.visitChangedSourceNode(sourceNode);
        }
        Enumeration children = sourceNode.changedChildren();
        while (children.hasMoreElements()) {
            Object child = children.nextElement();
            if (child instanceof ModelDeltaNode) {
                updateRequired |= this.visit((ModelDeltaNode)child);
                continue;
            }
            ProxyPlugin.logWarning("invalid delta node child : " + child);
        }
        return updateRequired;
    }

    private boolean visitStructurallyChangedSource(UniqueName source, UniqueName originalSource) {
        boolean updateRequired = this.visitStructurallyChangedProxies(this.myProxies.getAsList(source, false), originalSource);
        ProxyDeltaProvider provider = this.getSourceProvider();
        if (provider != null) {
            List children = provider.getParents().getAsList(source, false);
            int i = children.size() - 1;
            while (i >= 0) {
                updateRequired |= this.visitStructurallyChangedSource((UniqueName)children.get(i), null);
                --i;
            }
        }
        return updateRequired;
    }

    private boolean visitStructurallyChangedProxies(List proxies, UniqueName originalSource) {
        int i = proxies.size() - 1;
        while (i >= 0) {
            UniqueName proxy = (UniqueName)proxies.get(i);
            this.unbind(proxy);
            CleanProxyModelDeltaNode pmdn = new CleanProxyModelDeltaNode(this.myDeltaSource.getModel(), proxy, originalSource, ModelDeltaNodeKind.DELETED);
            Element proxyElement = this.myDeltaSource.getModel().findElement(proxy);
            if (proxyElement != null && !proxyElement.isDeleted()) {
                pmdn.makeTotallyChanged();
                this.bind(proxy);
            }
            this.myDeltaSource.getDelta().addDeltaNode((TreeModelDeltaNode)pmdn);
            --i;
        }
        return !proxies.isEmpty();
    }

    private boolean visitNewSourceNode(ModelDeltaNode sourceNode) {
        Element source = this.getSourceModel().findElement(sourceNode.getElementUniqueName());
        if (source == null || source.isDeleted()) {
            ProxyPlugin.logWarning("new element not exists " + ProxyMetaInfo.toString(sourceNode.getElementUniqueName()));
            return false;
        }
        Entity sourceParent = source.getParent();
        if (sourceParent == null || sourceParent.isDeleted()) {
            ProxyPlugin.logWarning("parent of the new element not exists " + source.getUniqueName());
            return false;
        }
        boolean updateRequired = false;
        List parentProxies = this.myProxies.getAsList(sourceParent.getUniqueName(), false);
        int i = parentProxies.size() - 1;
        while (i >= 0) {
            UniqueName proxy = ProxyMetaInfo.getProxyUniqueName((UniqueName)parentProxies.get(i), this.getSourceModel().getUniqueName(), sourceNode.getElementUniqueName());
            this.bind(sourceNode.getElementUniqueName(), proxy);
            this.myDeltaSource.getDelta().addDeltaNode((TreeModelDeltaNode)new ProxyModelDeltaNode(this.myDeltaSource.getModel(), proxy, sourceNode));
            updateRequired = true;
            --i;
        }
        return updateRequired;
    }

    private boolean visitRules(ModelDeltaNode sourceNode) {
        boolean updateRequired = false;
        if (this.myRules == null) {
            this.myRules = ProxyPlugin.getRules();
            if (this.myRules == null) {
                return false;
            }
        }
        List bound = null;
        int i = 0;
        while (i < this.myRules.length) {
            ProxyRule rule = this.myRules[i];
            try {
                UniqueNameEnumeration proxies = rule.getProxies(this.myDeltaSource.getModel(), this.mySourceModel, sourceNode.getElementUniqueName());
                if (proxies != null && proxies.hasMoreElements()) {
                    if (bound == null) {
                        bound = this.myProxies.getAsList(sourceNode.getElementUniqueName(), false);
                    }
                    while (proxies.hasMoreElements()) {
                        UniqueName proxy = proxies.next();
                        if (bound.contains(proxy)) {
                            ProxyModelDeltaNode pmdn = new ProxyModelDeltaNode(this.myDeltaSource.getModel(), proxy, sourceNode);
                            pmdn.makeTotallyChanged();
                            this.myDeltaSource.getDelta().addDeltaNode((TreeModelDeltaNode)pmdn);
                            continue;
                        }
                        this.bind(sourceNode.getElementUniqueName(), proxy);
                        this.myDeltaSource.getDelta().addDeltaNode((TreeModelDeltaNode)new ProxyModelDeltaNode(this.myDeltaSource.getModel(), proxy, sourceNode));
                        updateRequired = true;
                    }
                }
            }
            catch (Throwable t) {
                ProxyPlugin.logError("exception in proxy rule " + rule, t);
            }
            ++i;
        }
        return updateRequired;
    }

    private boolean visitChangedSourceNode(ModelDeltaNode sourceNode) {
        boolean updateRequired = false;
        List bound = this.myProxies.getAsList(sourceNode.getElementUniqueName(), false);
        int i = bound.size() - 1;
        while (i >= 0) {
            UniqueName proxy = (UniqueName)bound.get(i);
            this.myDeltaSource.getDelta().addDeltaNode((TreeModelDeltaNode)new ProxyModelDeltaNode(this.myDeltaSource.getModel(), proxy, sourceNode));
            updateRequired = true;
            --i;
        }
        return updateRequired;
    }

    private ProxyDeltaProvider getSourceProvider() {
        ProxyDeltaProvider provider = ProxyPlugin.getDeltaProvider(this.getSourceModel().getUniqueName());
        if (provider == null) {
            ProxyPlugin.logWarning("proxy delta provider is not registered in " + this.getSourceModel());
        }
        return provider;
    }

    static interface DeltaSource {
        public RootModelDeltaNode getDelta();

        public Model getModel();
    }
}

