/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;

public class ProxyModelDeltaNode
extends DefaultModelDeltaNode {
    private ModelDeltaNode mySourceDeltaNode;
    private boolean myTotallyChanged;

    public ProxyModelDeltaNode(Model proxyModel, UniqueName proxyUniqueName, ModelDeltaNode sourceNode) {
        super(proxyModel, proxyUniqueName, ModelDeltaNodeKind.UNKNOWN);
        this.mySourceDeltaNode = sourceNode;
    }

    public UniqueName getOriginalElementUniqueName() {
        UniqueName original = this.mySourceDeltaNode.getOriginalElementUniqueName();
        if (original == null) {
            return null;
        }
        UniqueName proxy = this.getElementUniqueName();
        UniqueName source = ProxyMetaInfo.getSourceUniqueName(proxy);
        if (source.equals(original)) {
            return proxy;
        }
        UniqueName parent = ProxyMetaInfo.getParentUniqueName(proxy);
        UniqueName sourceModel = ProxyMetaInfo.getSourceModelUniqueName(proxy);
        String[] parameters = ProxyMetaInfo.getParameters(proxy);
        return ProxyMetaInfo.getProxyUniqueName(parent, sourceModel, original, parameters);
    }

    public UniqueName getParentUniqueName() {
        UniqueName proxy = this.getElementUniqueName();
        UniqueName parent = ProxyMetaInfo.getParentUniqueName(proxy);
        return parent;
    }

    public boolean isNew() {
        if (this.myTotallyChanged) {
            super.isNew();
        }
        return this.mySourceDeltaNode.isNew();
    }

    public boolean isChanged() {
        if (this.myTotallyChanged) {
            super.isChanged();
        }
        return this.mySourceDeltaNode.isChanged();
    }

    public boolean isDeleted() {
        if (this.myTotallyChanged) {
            super.isDeleted();
        }
        return this.mySourceDeltaNode.isDeleted();
    }

    public boolean isTotallyChanged() {
        if (this.myTotallyChanged) {
            super.isTotallyChanged();
        }
        return this.mySourceDeltaNode.isTotallyChanged();
    }

    public void makeTotallyChanged() {
        this.myTotallyChanged = true;
        super.makeTotallyChanged();
    }

    public boolean isEmpty() {
        return this.mySourceDeltaNode.isEmpty();
    }
}

