/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.AbstractProxyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ProxyLinkProvider
extends AbstractProxyProvider
implements LinkProvider {
    public boolean isLinkProviderApplicable(Entity link) {
        UniqueName uniqueName = link.getUniqueName();
        if (!this.isUniqueNameAcceptable(uniqueName)) {
            return false;
        }
        return ProxyMetaInfo.getSourceEntity(uniqueName) != null;
    }

    public StringEnumeration participantRoles(Entity link) {
        return ProxyMetaInfo.getSourceEntity(link.getUniqueName()).participantRoles();
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        return EmptyEnumeration.getUniqueNameEnumeration();
    }

    private Map getProxyPath(UniqueName proxy) {
        HashMap<UniqueName, UniqueName> path = new HashMap<UniqueName, UniqueName>();
        while (ProxyMetaInfo.isProxyUniqueName(proxy)) {
            path.put(ProxyMetaInfo.getSourceUniqueName(proxy), proxy);
            proxy = ProxyMetaInfo.getParentUniqueName(proxy);
        }
        return path;
    }

    private UniqueName getParticipantProxy(Map linkPath, Element sourceParticipant) {
        ArrayList<UniqueName> participantPath = new ArrayList<UniqueName>();
        UniqueName source = sourceParticipant.getUniqueName();
        while (!linkPath.containsKey(source)) {
            if (ModelUinSupport.isModelUin((UniqueName)source)) {
                return null;
            }
            participantPath.add(source);
            sourceParticipant = sourceParticipant.getParent();
            source = sourceParticipant.getUniqueName();
        }
        UniqueName proxy = (UniqueName)linkPath.get(source);
        UniqueName sourceModel = sourceParticipant.getModel().getUniqueName();
        int i = participantPath.size() - 1;
        while (i >= 0) {
            UniqueName sourceChild = (UniqueName)participantPath.get(i);
            proxy = ProxyMetaInfo.getProxyUniqueName(proxy, sourceModel, sourceChild);
            --i;
        }
        return proxy;
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        return false;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
    }
}

