/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.AbstractProxyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;

public final class ProxyExistenceProvider
extends AbstractProxyProvider
implements EntityExistenceProvider {
    private boolean proxyExists(UniqueName proxy) {
        Element parent = this.getParentElement(proxy);
        if (parent == null || parent.isDeleted()) {
            return false;
        }
        Model model = ProxyMetaInfo.getSourceModel(proxy);
        if (model == null || model.isDeleted()) {
            return false;
        }
        Element source = ProxyMetaInfo.getSourceElement(proxy);
        return source != null && !source.isDeleted();
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (!this.isUniqueNameAcceptable(element.getUniqueName())) {
            return false;
        }
        return this.isAutomaticallyProvided(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return !this.proxyExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uniqueName) {
        if (!this.isUniqueNameAcceptable(uniqueName)) {
            return false;
        }
        if (!this.isAutomaticallyProvided(uniqueName)) {
            return false;
        }
        return this.proxyExists(uniqueName);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!this.isUniqueNameAcceptable(parent.getUniqueName())) {
            return false;
        }
        Entity source = ProxyMetaInfo.getSourceEntity(parent.getUniqueName());
        if (source == null || source.isDeleted()) {
            return false;
        }
        return source.canCreateChildEntity(shapeType, template);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Entity source = ProxyMetaInfo.getSourceEntity(parent.getUniqueName());
        Entity sourceChild = source.createChildEntity(shapeType, template);
        if (sourceChild == null) {
            return null;
        }
        return ProxyMetaInfo.getProxyUniqueName(parent.getUniqueName(), source.getModel().getUniqueName(), sourceChild.getUniqueName());
    }

    public boolean canDelete(Element element) {
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        return source != null && source.canDelete();
    }

    public void delete(Element element) {
        ProxyMetaInfo.getSourceElement(element.getUniqueName()).delete();
    }
}

