/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.AbstractProxyProvider;
import com.tssap.selena.internal.model.providers.proxy.CleanProxyModelDeltaNode;
import com.tssap.selena.internal.model.providers.proxy.ProxyModelRegistry;
import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.internal.model.providers.proxy.UniqueNameHashMap;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import com.tssap.selena.model.util.various.DeltaDumper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProxyDeltaProvider
extends AbstractProxyProvider
implements DeltaTreeProvider,
ModelAccessListener,
ModelChangeListener,
ProxyModelRegistry.DeltaSource {
    private RootModelDeltaNode myDelta;
    private Map myModelRegistries;
    private List myOwnModelRegistries;
    private UniqueNameHashMap myParents = new UniqueNameHashMap();
    private ProxyRule[] myRules;

    public RootModelDeltaNode getDelta() {
        return this.myDelta;
    }

    public ModelDeltaNode getModelChanges() {
        RootModelDeltaNode delta = this.myDelta;
        if (ProxyPlugin.getDefault().isDebuggingDelta()) {
            String msg = "proxy delta in proxy model";
            if (delta.isEmpty()) {
                msg = msg + " (empty)";
            }
            msg = msg + " in " + this.getModel();
            ProxyPlugin.logInfo(msg);
            System.err.println("\n\\/ x \\/ x \\/ x \\/ x \\/ x \\/ x \\/ x \\/ proxy delta \\/ x \\/ x \\/ x \\/ x \\/ x \\/ x \\/ x \\/");
            DeltaDumper.dumpDelta((ModelDeltaNode)delta);
            System.err.println("/\\ x /\\ x /\\ x /\\ x /\\ x /\\ x /\\ x /\\ proxy delta /\\ x /\\ x /\\ x /\\ x /\\ x /\\ x /\\ x /\\\n");
        }
        this.resetDelta();
        return delta;
    }

    private void resetDelta() {
        Model model = this.getModel();
        if (model == null) {
            this.myDelta = null;
            return;
        }
        this.myDelta = new RootModelDeltaNode(model);
    }

    public void registered(Model model) {
        ProxyPlugin.logInfo("registered in [" + model + "]");
        super.registered(model);
        this.resetDelta();
        ModelAccess.addModelAccessListener((ModelAccessListener)this);
        ProxyPlugin.registerDeltaProvider(model.getUniqueName(), this);
        model.addModelDeltaListener((ModelChangeListener)this);
    }

    public void unregistered(Model model) {
        ProxyModelRegistry registry;
        if (this.myOwnModelRegistries != null) {
            int i = this.myOwnModelRegistries.size() - 1;
            while (i >= 0) {
                registry = (ProxyModelRegistry)this.myOwnModelRegistries.get(i);
                registry.kill();
                --i;
            }
        }
        if (this.myModelRegistries != null) {
            Iterator regs = this.myModelRegistries.values().iterator();
            while (regs.hasNext()) {
                registry = (ProxyModelRegistry)regs.next();
                ProxyDeltaProvider sourceProvider = ProxyPlugin.getDeltaProvider(registry.getSourceModel().getUniqueName());
                if (sourceProvider != null) {
                    sourceProvider.unregisterOwnModelRegisrty(registry);
                }
                ProxyPlugin.logInfo("destroying " + registry);
                registry.destroy();
            }
        }
        this.myModelRegistries = null;
        model.removeModelDeltaListener((ModelChangeListener)this);
        ProxyPlugin.unregisterDeltaProvider(model.getUniqueName());
        ModelAccess.removeModelAccessListener((ModelAccessListener)this);
        super.unregistered(model);
        ProxyPlugin.logInfo("unregistered from [" + model + "]");
    }

    public void modelCreated(ModelAccessEvent event) {
    }

    public void modelRemoved(ModelAccessEvent event) {
        if (this.myModelRegistries == null) {
            return;
        }
        UniqueName sourceModel = event.getModel().getUniqueName();
        ProxyModelRegistry registry = (ProxyModelRegistry)this.myModelRegistries.remove(sourceModel);
        if (registry != null) {
            ProxyPlugin.logInfo("model [" + event.getModel() + "] removed; destroying " + registry);
            registry.destroy();
        }
    }

    public ProxyModelRegistry[] getModelRegistries() {
        if (this.myModelRegistries == null) {
            return null;
        }
        return this.myModelRegistries.values().toArray(new ProxyModelRegistry[this.myModelRegistries.values().size()]);
    }

    public ProxyModelRegistry getModelRegistry(Model sourceModel) {
        ProxyModelRegistry registry;
        if (this.myModelRegistries == null) {
            this.myModelRegistries = new HashMap();
        }
        if ((registry = (ProxyModelRegistry)this.myModelRegistries.get(sourceModel.getUniqueName())) == null) {
            registry = new ProxyModelRegistry(sourceModel, this);
            this.myModelRegistries.put(sourceModel.getUniqueName(), registry);
            ProxyDeltaProvider sourceProvider = ProxyPlugin.getDeltaProvider(sourceModel.getUniqueName());
            if (sourceProvider != null) {
                sourceProvider.registerOwnModelRegisrty(registry);
            }
            ProxyPlugin.logInfo(registry + " created");
        }
        return registry;
    }

    private boolean hasModelRegistry(Model sourceModel) {
        if (this.myModelRegistries == null) {
            return false;
        }
        return this.myModelRegistries.get(sourceModel.getUniqueName()) != null;
    }

    private void registerOwnModelRegisrty(ProxyModelRegistry registry) {
        if (this.myOwnModelRegistries == null) {
            this.myOwnModelRegistries = new ArrayList();
        }
        this.myOwnModelRegistries.add(registry);
    }

    private void unregisterOwnModelRegisrty(ProxyModelRegistry registry) {
        if (this.myOwnModelRegistries == null) {
            return;
        }
        this.myOwnModelRegistries.remove(registry);
    }

    ProxyModelRegistry[] getOwnModelRegistries() {
        if (this.myOwnModelRegistries == null || this.myOwnModelRegistries.isEmpty()) {
            return null;
        }
        return this.myOwnModelRegistries.toArray(new ProxyModelRegistry[this.myOwnModelRegistries.size()]);
    }

    boolean hasRootProxies(UniqueName source) {
        ProxyModelRegistry[] registries = this.getOwnModelRegistries();
        if (registries == null || registries.length == 0) {
            return false;
        }
        int i = 0;
        while (i < registries.length) {
            if (registries[i].hasRootProxies(source)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void modelChanged(final ModelChangeEvent changeEvent) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                if (ProxyDeltaProvider.this.getModel() == null) {
                    return;
                }
                if (ProxyPlugin.getDefault().isDebuggingDelta()) {
                    ModelDeltaNode delta = changeEvent.getRootDelta();
                    String msg = "source delta in proxy model";
                    if (delta.isEmpty()) {
                        msg = msg + " (empty)";
                    }
                    msg = msg + " in " + ProxyDeltaProvider.this.getModel();
                    ProxyPlugin.logInfo(msg);
                    System.err.println("\n\\/ h \\/ h \\/ h \\/ h \\/ h \\/ h \\/ h \\/ home delta \\/ h \\/ h \\/ h \\/ h \\/ h \\/ h \\/ h \\/");
                    DeltaDumper.dumpDelta((ModelDeltaNode)delta);
                    System.err.println("/\\ h /\\ h /\\ h /\\ h /\\ h /\\ h /\\ h /\\ home delta /\\ h /\\ h /\\ h /\\ h /\\ h /\\ h /\\ h /\\\n");
                }
                if (ProxyDeltaProvider.this.myRules == null) {
                    ProxyDeltaProvider.access$002(ProxyDeltaProvider.this, ProxyPlugin.getRules());
                }
                if (ProxyDeltaProvider.this.myRules != null) {
                    ProxyDeltaProvider.this.visitNew(changeEvent.getRootDelta());
                }
                if (ProxyDeltaProvider.this.myModelRegistries == null || ProxyDeltaProvider.this.myModelRegistries.isEmpty()) {
                    return;
                }
                Model model = changeEvent.getModel();
                if (!model.equals(ProxyDeltaProvider.this.getModel())) {
                    ProxyPlugin.logError("proxy delta provider for the [" + ProxyDeltaProvider.this.getModel() + "] received delta in the [" + model + "]");
                    return;
                }
                ProxyDeltaProvider.this.visit(changeEvent.getRootDelta());
            }
        }, (String)"proxy delta handler in proxy model");
    }

    private void visit(ModelDeltaNode mdn) {
        block6: {
            block5: {
                UniqueName sourceModelUin;
                ProxyModelRegistry pmr;
                if (!mdn.isDeleted() && !mdn.isTotallyChanged()) break block5;
                if (!ProxyMetaInfo.isProxyUniqueName(mdn.getElementUniqueName()) || (pmr = (ProxyModelRegistry)this.myModelRegistries.get(sourceModelUin = ProxyMetaInfo.getSourceModelUniqueName(mdn.getElementUniqueName()))) == null) break block6;
                pmr.unbind(mdn.getElementUniqueName());
                Element element = this.getModel().findElement(mdn.getElementUniqueName());
                if (element == null || element.isDeleted()) break block6;
                pmr.bind(mdn.getElementUniqueName());
                break block6;
            }
            if (mdn.isNew()) {
                UniqueName sourceModelUin;
                ProxyModelRegistry pmr;
                if (ProxyMetaInfo.isProxyUniqueName(mdn.getElementUniqueName()) && (pmr = (ProxyModelRegistry)this.myModelRegistries.get(sourceModelUin = ProxyMetaInfo.getSourceModelUniqueName(mdn.getElementUniqueName()))) != null) {
                    pmr.bind(mdn.getElementUniqueName());
                }
            } else {
                Enumeration children = mdn.changedChildren();
                while (children.hasMoreElements()) {
                    Object child = children.nextElement();
                    if (child instanceof ModelDeltaNode) {
                        this.visit((ModelDeltaNode)child);
                        continue;
                    }
                    ProxyPlugin.logWarning("invalid delta node child : " + child);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void visitNew(ModelDeltaNode mdn) {
        block12: {
            block10: {
                if (mdn.isTotallyChanged()) {
                    return;
                }
                if (mdn.isDeleted()) {
                    return;
                }
                if (!mdn.isNew()) break block10;
                deltaProviders = ProxyPlugin.getDeltaProviders();
                j = 0;
                while (j < deltaProviders.length) {
                    block11: {
                        proxyDeltaProvider = deltaProviders[j];
                        if (proxyDeltaProvider.hasModelRegistry(this.getModel())) break block11;
                        i = 0;
                        while (i < this.myRules.length) {
                            block9: {
                                rule = this.myRules[i];
                                try {
                                    proxies = rule.getProxies(proxyDeltaProvider.getModel(), this.getModel(), mdn.getElementUniqueName());
                                    if (proxies != null) ** GOTO lbl25
                                    break block9;
lbl-1000:
                                    // 1 sources

                                    {
                                        proxy = proxies.next();
                                        pmr = proxyDeltaProvider.getModelRegistry(this.getModel());
                                        pmr.bind(proxy);
                                        proxyDeltaProvider.getDelta().addDeltaNode((TreeModelDeltaNode)new CleanProxyModelDeltaNode(proxyDeltaProvider.getModel(), proxy, ModelDeltaNodeKind.NEW));
                                        proxyDeltaProvider.getModel().getExtensionManager().modelContentsChanged();
lbl25:
                                        // 2 sources

                                        ** while (proxies.hasMoreElements())
                                    }
lbl26:
                                    // 1 sources

                                }
                                catch (Throwable t) {
                                    ProxyPlugin.logError("exception in proxy rule " + rule, t);
                                }
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
                break block12;
            }
            children = mdn.changedChildren();
            while (children.hasMoreElements()) {
                child = children.nextElement();
                if (child instanceof ModelDeltaNode) {
                    this.visitNew((ModelDeltaNode)child);
                    continue;
                }
                ProxyPlugin.logWarning("invalid delta node child : " + child);
            }
        }
    }

    public Map getParentsCopy() {
        return new HashMap(this.getParents());
    }

    UniqueNameHashMap getParents() {
        return this.myParents;
    }

    void cacheParents(UniqueName source, Element sourceElement) {
        if (this.getModel().getUniqueName().equals(source)) {
            return;
        }
        if (sourceElement == null) {
            sourceElement = this.getModel().findElement(source);
        }
        if (sourceElement == null || sourceElement.isDeleted()) {
            ProxyPlugin.logWarning("element not exist " + source);
            return;
        }
        Entity parentElement = sourceElement.getParent();
        if (parentElement == null || parentElement.isDeleted()) {
            ProxyPlugin.logWarning("element parent is unknown " + source);
            return;
        }
        List children = this.getParents().getAsList(parentElement.getUniqueName(), false);
        if (children.contains(source)) {
            return;
        }
        this.getParents().bind(parentElement.getUniqueName(), source);
        this.cacheParents(parentElement.getUniqueName(), (Element)parentElement);
    }

    void dropParents(UniqueName source) {
        if (this.myParents.containsKey(source)) {
            return;
        }
        this.dropParentsHelper(source);
    }

    private void dropParentsHelper(UniqueName source) {
        if (this.getModel().getUniqueName().equals(source)) {
            return;
        }
        if (this.hasRootProxies(source)) {
            return;
        }
        Iterator parents = this.myParents.keySet().iterator();
        while (parents.hasNext()) {
            UniqueName parent = (UniqueName)parents.next();
            List children = this.myParents.getAsList(parent, false);
            if (!children.remove(source)) continue;
            if (!children.isEmpty()) break;
            this.myParents.remove(parent);
            this.dropParentsHelper(parent);
            break;
        }
    }

    static /* synthetic */ ProxyRule[] access$002(ProxyDeltaProvider x0, ProxyRule[] x1) {
        x0.myRules = x1;
        return x1;
    }
}

