/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.AbstractProxyProvider;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collection;

public final class ProxyChildrenProvider
extends AbstractProxyProvider
implements ChildrenProvider {
    public UniqueNameEnumeration children(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        Entity source = ProxyMetaInfo.getSourceEntity(uniqueName);
        Model sourceModel = source.getModel();
        EntityEnumeration sourceChildren = source.children();
        ArrayList<UniqueName> children = new ArrayList<UniqueName>();
        while (sourceChildren.hasMoreElements()) {
            Entity child = sourceChildren.next();
            UniqueName proxy = ProxyMetaInfo.getProxyUniqueName(uniqueName, sourceModel.getUniqueName(), child.getUniqueName());
            children.add(proxy);
        }
        ProxyMetaInfo.bind(ProxyChildrenProvider.enumerate(children), this.getModel().getUniqueName());
        return ProxyChildrenProvider.enumerate(children);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        if (!this.isUniqueNameAcceptable(uniqueName)) {
            return false;
        }
        return ProxyMetaInfo.getSourceEntity(uniqueName) != null;
    }

    private static UniqueNameEnumeration enumerate(Collection uniqueNames) {
        return EnumerationConverter.toUniqueNameEnumeration(uniqueNames.iterator());
    }
}

