/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;

abstract class AbstractProxyProvider
implements ModelAware {
    private Model myModel;

    AbstractProxyProvider() {
    }

    public void registered(Model model) {
        this.myModel = model;
    }

    public void unregistered(Model model) {
        this.myModel = null;
    }

    protected Element getParentElement(UniqueName proxy) {
        return this.findElement(ProxyMetaInfo.getParentUniqueName(proxy));
    }

    protected Element findElement(UniqueName un) {
        if (this.myModel == null) {
            return null;
        }
        return this.myModel.findElement(un);
    }

    protected boolean isUniqueNameAcceptable(UniqueName uniqueName) {
        return ProxyMetaInfo.isProxyUniqueName(uniqueName);
    }

    protected boolean isAutomaticallyProvided(UniqueName proxy) {
        UniqueName proxyParent = ProxyMetaInfo.getParentUniqueName(proxy);
        if (!ProxyMetaInfo.isProxyUniqueName(proxyParent)) {
            return false;
        }
        Entity sourceParent = ProxyMetaInfo.getSourceEntity(proxyParent);
        if (sourceParent == null || sourceParent.isDeleted()) {
            return false;
        }
        UniqueName source = ProxyMetaInfo.getSourceUniqueName(proxy);
        EntityEnumeration children = sourceParent.children();
        while (children.hasMoreElements()) {
            UniqueName child = children.next().getUniqueName();
            if (!child.equals(source)) continue;
            return true;
        }
        return false;
    }

    protected final void invalidProxyUniqueName(UniqueName un) {
        ProxyPlugin.logError("Invalid proxy unique name [" + un + "]");
    }

    public Model getModel() {
        return this.myModel;
    }
}

