/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmWizards;

import com.sap.netweaver.bc.km.plugin.eprf.general.kmWizards.IWizardAttributes;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.KMPlugin;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmWizards.IPDKCustomKMComponentWizard;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmWizards.PDKCustomKMComponentExtension;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmWizards.PDKCustomKMComponentExtensionPoint;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmWizards.PDKExtensionPointContentAndLabelProvider;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.api.IPropertySystem;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SAPKMWizardPage
extends WizardPage
implements IWizardAttributes {
    private static final String THIS_PROP_GROUP = "com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.wizards.kmWizards";
    private static final String SELECTED_WIZARD_PROP = "selectedCustomWizard";
    private AbstractProfiles profiles;
    private IProject lastSelectedProject;
    private PDKCustomKMComponentExtensionPoint pdkExtensionPoint = null;
    private StyledText text;
    private PDKCustomKMComponentExtension selectedPDKExtension;
    private HashMap extensionObjectToWizard = new HashMap();
    private Table table;
    private TableViewer tableViewer;
    private IStructuredSelection selection;
    private IProject selectedProject;

    public SAPKMWizardPage(String pageName) {
        super(pageName);
        this.setTitle("KM Component");
        this.setDescription("Create a KM Component");
    }

    public SAPKMWizardPage(String pageName, IStructuredSelection sel) {
        super(pageName);
        this.setTitle("KM Component");
        this.setDescription("Create a KM Component");
        this.selection = sel;
        if (this.selection.getFirstElement() != null && this.selection.getFirstElement() instanceof IProject) {
            this.selectedProject = (IProject)this.selection.getFirstElement();
        }
    }

    public boolean canFlipToNextPage() {
        return this.selectedPDKExtension != null;
    }

    public IProject getProject() {
        return this.selectedProject;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.table.setFocus();
            IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
            try {
                String wizardName = propSystem.loadProperty(THIS_PROP_GROUP, SELECTED_WIZARD_PROP, (Object)this.selectedProject);
                PDKCustomKMComponentExtension[] extensions = this.pdkExtensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    PDKCustomKMComponentExtension extension = extensions[i];
                    if (extension.getName().equals(wizardName)) {
                        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)extension));
                    }
                    ++i;
                }
                if (this.tableViewer.getSelection().isEmpty() && extensions.length > 0) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)extensions[0]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IWizardPage getNextPage() {
        if (this.selectedPDKExtension == null) {
            return null;
        }
        IPDKCustomKMComponentWizard pdkCustomComponentWizard = (IPDKCustomKMComponentWizard)this.extensionObjectToWizard.get(this.selectedPDKExtension);
        if (this.selectedProject != null && this.selectedProject != this.lastSelectedProject) {
            try {
                this.profiles = OpentoolsFactory.getEPInstance().getCurrentProfiles((Object)this.selectedProject);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occurred reading the profiles of project " + this.selectedProject.getName()));
                this.getContainer().getShell().close();
                return null;
            }
        }
        if (pdkCustomComponentWizard == null) {
            IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
            try {
                propSystem.saveProperty(THIS_PROP_GROUP, SELECTED_WIZARD_PROP, this.selectedPDKExtension.getName(), (Object)this.selectedProject);
            }
            catch (Exception e) {
                // empty catch block
            }
            String wizardsClassName = this.selectedPDKExtension.getClassName();
            ClassLoader wizardsClassLoader = this.selectedPDKExtension.getExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
            try {
                pdkCustomComponentWizard = (IPDKCustomKMComponentWizard)wizardsClassLoader.loadClass(wizardsClassName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)"Error on selected wizard", (String)("An error occurred during creation of the selected wizard.\nException(" + e.getClass().getName() + "): " + e.getMessage()));
                return null;
            }
            StructuredSelection projectSelection = this.selectedProject != null ? new StructuredSelection((Object)this.selectedProject) : new StructuredSelection(this.selection.getFirstElement());
            pdkCustomComponentWizard.setContainer(this.getContainer());
            pdkCustomComponentWizard.setProfiles(this.profiles);
            pdkCustomComponentWizard.init(KMPlugin.getDefault().getWorkbench(), (IStructuredSelection)projectSelection);
            pdkCustomComponentWizard.setCurrentProject(this.selectedProject);
            pdkCustomComponentWizard.addPages();
            this.extensionObjectToWizard.put(this.selectedPDKExtension, pdkCustomComponentWizard);
        }
        this.lastSelectedProject = this.selectedProject;
        return pdkCustomComponentWizard.getStartingPage();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, true));
        Composite tableComposite = new Composite(main, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        tableComposite.setLayout((Layout)new GridLayout());
        Composite descriptionComposite = new Composite(main, 0);
        descriptionComposite.setLayoutData((Object)new GridData(1808));
        descriptionComposite.setLayout((Layout)new GridLayout());
        Label tableLabel = new Label(tableComposite, 0);
        tableLabel.setText("Please select a template");
        IExtensionPoint extensionPoint = KMPlugin.getDefault().getDescriptor().getExtensionPoint("PDKCustomKMComponent");
        try {
            this.pdkExtensionPoint = new PDKCustomKMComponentExtensionPoint(extensionPoint);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)parent.getShell(), (String)"Error", (String)e.getMessage());
        }
        this.table = new Table(tableComposite, 2048);
        this.table.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(this.table);
        PDKExtensionPointContentAndLabelProvider provider = new PDKExtensionPointContentAndLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.tableViewer.setInput((Object)this.pdkExtensionPoint);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                SAPKMWizardPage.this.selectedPDKExtension = (PDKCustomKMComponentExtension)selectedObject;
                SAPKMWizardPage.this.text.setText(SAPKMWizardPage.this.selectedPDKExtension.getDescription());
                SAPKMWizardPage.super.getContainer().updateButtons();
            }
        });
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SAPKMWizardPage.super.getContainer().showPage(SAPKMWizardPage.this.getNextPage());
            }
        });
        Label descLabel = new Label(descriptionComposite, 0);
        descLabel.setText("Description:");
        this.text = new StyledText(descriptionComposite, 2048);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setEditable(false);
        this.text.setEnabled(false);
        this.text.setWordWrap(true);
        this.text.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
        this.text.setText("<b>No</b>thing selected yet.");
        this.setControl((Control)main);
    }
}

