/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.console;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.swt.graphics.Color;

public class ConsoleColorProvider
implements IConsoleColorProvider {
    private IProcess fProcess;
    private IConsole fConsole;

    public void connect(IProcess process, IConsole console) {
        this.fProcess = process;
        this.fConsole = console;
        this.fConsole.connect(this.fProcess.getStreamsProxy());
    }

    public void disconnect() {
        this.fConsole = null;
        this.fProcess = null;
    }

    public boolean isReadOnly() {
        return this.fProcess == null || this.fProcess.isTerminated();
    }

    public Color getColor(String streamIdentifer) {
        if (IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM.equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor("Console.stdOutColor");
        }
        if (IDebugUIConstants.ID_STANDARD_ERROR_STREAM.equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor("Console.stdErrColor");
        }
        if (IDebugUIConstants.ID_STANDARD_INPUT_STREAM.equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor("Console.stdInColor");
        }
        return null;
    }

    protected IProcess getProcess() {
        return this.fProcess;
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }
}

