/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.actions.LaunchAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public abstract class AbstractLaunchHistoryAction
implements IWorkbenchWindowPulldownDelegate2,
ILaunchHistoryChangedListener {
    private Menu fMenu;
    private IAction fAction;
    private String fLaunchGroupIdentifier;
    protected boolean fRecreateMenu = false;

    public AbstractLaunchHistoryAction(String launchGroupIdentifier) {
        this.fLaunchGroupIdentifier = launchGroupIdentifier;
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    private void initialize(IAction action) {
        this.getLaunchConfigurationManager().addLaunchHistoryListener(this);
        this.setAction(action);
        this.updateTooltip();
        action.setEnabled(this.existsConfigTypesForMode());
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updateTooltip() {
        ILaunchConfiguration lastLaunched = this.getLastLaunch();
        String tooltip = null;
        if (lastLaunched == null) {
            tooltip = this.getLaunchHistory().getLaunchGroup().getLabel();
            int index = tooltip.indexOf(38);
            if (index == 0) {
                tooltip = tooltip.substring(1);
            } else if (index > 0 && index < tooltip.length() - 1) {
                StringBuffer temp = new StringBuffer(tooltip.substring(0, index));
                temp.append(tooltip.substring(index + 1));
                tooltip = temp.toString();
            }
        } else {
            String mode = this.getMode();
            String launchName = lastLaunched.getName();
            tooltip = mode.equals("run") ? MessageFormat.format(ActionMessages.getString("AbstractLaunchHistoryAction.Run_{0}_1"), launchName) : MessageFormat.format(ActionMessages.getString("AbstractLaunchHistoryAction.Debug_{0}_2"), launchName);
        }
        this.getAction().setToolTipText(tooltip);
    }

    public void launchHistoryChanged() {
        this.fRecreateMenu = true;
        this.updateTooltip();
    }

    public void dispose() {
        this.setMenu(null);
        this.getLaunchConfigurationManager().removeLaunchHistoryListener(this);
    }

    protected ILaunchConfiguration getLastLaunch() {
        return this.getLaunchConfigurationManager().getLastLaunch(this.getLaunchGroupIdentifier());
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    private void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (AbstractLaunchHistoryAction.this.fRecreateMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    AbstractLaunchHistoryAction.this.fillMenu(m);
                    AbstractLaunchHistoryAction.this.fRecreateMenu = false;
                }
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    protected void fillMenu(Menu menu) {
        LaunchAction action;
        ILaunchConfiguration launch;
        ILaunchConfiguration[] historyList = this.getLaunchHistory().getHistory();
        ILaunchConfiguration[] favoriteList = this.getLaunchHistory().getFavorites();
        int accelerator = 1;
        int i = 0;
        while (i < favoriteList.length) {
            launch = favoriteList[i];
            action = new LaunchAction(launch, this.getMode());
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            ++i;
        }
        if (favoriteList.length > 0 && historyList.length > 0) {
            this.addSeparator(menu);
        }
        i = 0;
        while (i < historyList.length) {
            launch = historyList[i];
            action = new LaunchAction(launch, this.getMode());
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            ++i;
        }
    }

    protected void addSeparator(Menu menu) {
        new MenuItem(menu, 2);
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    protected LaunchHistory getLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory(this.getLaunchGroupIdentifier());
    }

    protected String getMode() {
        return this.getLaunchHistory().getLaunchGroup().getMode();
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    protected String getLaunchGroupIdentifier() {
        return this.fLaunchGroupIdentifier;
    }
}

