/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPropertiesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugUITools {
    static /* synthetic */ Class class$0;

    public static Image getImage(String key) {
        return DebugPluginImages.getImage(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return DebugPluginImages.getImageDescriptor(key);
    }

    public static ImageDescriptor getDefaultImageDescriptor(Object element) {
        String imageKey = DebugUITools.getDefaultImageKey(element);
        if (imageKey == null) {
            return null;
        }
        return DebugPluginImages.getImageDescriptor(imageKey);
    }

    private static String getDefaultImageKey(Object element) {
        return ((DefaultLabelProvider)DebugUIPlugin.getDefaultLabelProvider()).getImageKey(element);
    }

    public static IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public static IDebugModelPresentation newDebugModelPresentation() {
        return new DelegatingModelPresentation();
    }

    public static IDebugModelPresentation newDebugModelPresentation(String identifier) {
        IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint point = descriptor.getExtensionPoint("debugModelPresentations");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement elt = configElements[j];
                    String id = elt.getAttribute("id");
                    if (id != null && id.equals(identifier)) {
                        return new LazyModelPresentation(elt);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IAdaptable getDebugContext() {
        IViewPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.debug.ui.DebugView")) != null) {
            Object element;
            IStructuredSelection ss;
            ISelection s;
            Viewer viewer;
            IDebugView view;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((view = (IDebugView)part.getAdapter((Class)clazz)) != null && (viewer = view.getViewer()) != null && (s = viewer.getSelection()) != null && s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
                return (IAdaptable)element;
            }
        }
        return null;
    }

    public static IProcess getCurrentProcess() {
        ILaunch[] launches;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null && (launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()).length > 0) {
            context = launches[launches.length - 1];
        }
        if (context instanceof IDebugElement) {
            return ((IDebugElement)context).getDebugTarget().getProcess();
        }
        if (context instanceof IProcess) {
            return (IProcess)context;
        }
        if (context instanceof ILaunch) {
            IProcess process;
            ILaunch launch = (ILaunch)context;
            IDebugTarget target = launch.getDebugTarget();
            if (target != null && (process = target.getProcess()) != null) {
                return process;
            }
            IProcess[] ps = launch.getProcesses();
            if (ps.length > 0) {
                return ps[ps.length - 1];
            }
        }
        return null;
    }

    public static int openLaunchConfigurationDialog(Shell shell, IStructuredSelection selection, String mode) {
        String groupId = null;
        groupId = mode.equals("debug") ? IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP : IDebugUIConstants.ID_RUN_LAUNCH_GROUP;
        return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, groupId);
    }

    public static int openLaunchConfigurationDialogOnGroup(Shell shell, IStructuredSelection selection, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, groupIdentifier, null);
    }

    public static int openLaunchConfigurationDialogOnGroup(final Shell shell, final IStructuredSelection selection, final String groupIdentifier, final IStatus status) {
        final int[] result = new int[1];
        Runnable r = new Runnable(){

            public void run() {
                LaunchConfigurationsDialog dialog = (LaunchConfigurationsDialog)LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
                if (dialog != null) {
                    dialog.setInitialSelection(selection);
                    dialog.doInitialTreeSelection();
                    if (status != null) {
                        dialog.handleStatus(status);
                    }
                    result[0] = 0;
                } else {
                    dialog = new LaunchConfigurationsDialog(shell, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier));
                    dialog.setOpenMode(3);
                    dialog.setInitialSelection(selection);
                    dialog.setInitialStatus(status);
                    result[0] = dialog.open();
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return result[0];
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationPropertiesDialog dialog = new LaunchConfigurationPropertiesDialog(shell, configuration, group);
            return dialog.open();
        }
        return 1;
    }

    public static int openLaunchConfigurationDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationDialog dialog = new LaunchConfigurationDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static boolean saveAndBuildBeforeLaunch() {
        return DebugUIPlugin.saveAndBuild();
    }

    public static boolean saveBeforeLaunch() {
        return DebugUIPlugin.preLaunchSave();
    }

    public static void launch(final ILaunchConfiguration configuration, final String mode) {
        if (DebugUIPlugin.preLaunchSave()) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(DebugUIPlugin.getShell());
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DebugUITools.buildAndLaunch(configuration, mode, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                dialog.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                Throwable t = e;
                if (targetException instanceof CoreException) {
                    t = targetException;
                }
                if (t instanceof CoreException) {
                    LaunchGroupExtension group;
                    CoreException ce = (CoreException)t;
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(ce.getStatus());
                    if (handler != null && (group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configuration, mode)) != null) {
                        DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)configuration), group.getIdentifier(), ce.getStatus());
                        return;
                    }
                }
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.getString("DebugUITools.Error_1"), DebugUIMessages.getString("DebugUITools.Exception_occurred_during_launch_2"), t);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
    }
}

