/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class VariablesViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;

    public Object[] getChildren(Object parent) {
        Object[] children = null;
        try {
            if (parent instanceof IStackFrame) {
                children = ((IStackFrame)parent).getVariables();
            } else if (parent instanceof IVariable) {
                children = ((IVariable)parent).getValue().getVariables();
            }
            if (children != null) {
                this.cache(parent, children);
                return children;
            }
        }
        catch (DebugException e) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(e);
            }
            DebugUIPlugin.log(e);
        }
        return new Object[0];
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            this.fParentCache.put(children[i], parent);
            ++i;
        }
    }

    public Object getParent(Object item) {
        return this.fParentCache.get(item);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.fParentCache == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.fParentCache.remove(children[i]);
            ++i;
        }
    }

    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IVariable) {
                IValue v = ((IVariable)element).getValue();
                return v != null && v.hasVariables();
            }
            if (element instanceof IValue) {
                return ((IValue)element).hasVariables();
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).hasVariables();
            }
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    public List getCachedDecendants(Object parent) {
        Iterator children = this.fParentCache.keySet().iterator();
        ArrayList cachedChildren = new ArrayList(10);
        while (children.hasNext()) {
            Object child = children.next();
            if (!this.isCachedDecendant(child, parent)) continue;
            cachedChildren.add(child);
        }
        return cachedChildren;
    }

    protected boolean isCachedDecendant(Object child, Object parent) {
        Object p = this.getParent(child);
        while (p != null) {
            if (p.equals(parent)) {
                return true;
            }
            p = this.getParent(p);
        }
        return false;
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }
}

