/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class LaunchViewer
extends TreeViewer {
    public LaunchViewer(Composite parent) {
        super(new Tree(parent, 2));
        this.setUseHashlookup(true);
    }

    protected void updateStackFrameIcons(IThread parentThread) {
        Widget parentItem = this.findItem(parentThread);
        if (parentItem != null) {
            Item[] items = this.getItems((Item)parentItem);
            int i = 0;
            while (i < items.length) {
                TreeItem treeItem = (TreeItem)items[i];
                this.updateOneStackFrameIcon(treeItem, (IStackFrame)treeItem.getData());
                ++i;
            }
        }
    }

    protected void updateOneStackFrameIcon(TreeItem treeItem, IStackFrame stackFrame) {
        ILabelProvider provider = (ILabelProvider)this.getLabelProvider();
        Image image = provider.getImage((Object)stackFrame);
        if (image != null) {
            treeItem.setImage(image);
        }
    }

    public void refresh(Object element) {
        this.getControl().setRedraw(false);
        super.refresh(element);
        this.getControl().setRedraw(true);
    }
}

