/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewContentProvider;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewEventHandler;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LaunchView
extends AbstractDebugEventHandlerView
implements ISelectionChangedListener,
IPerspectiveListener,
IPageListener,
IPropertyChangeListener,
IResourceChangeListener,
IShowInTarget,
IShowInSource,
IShowInTargetList {
    private IMarker fInstructionPointer;
    private boolean fShowingEditor = false;
    private int fLastCharStart = -1;
    private int fLastCharEnd = -1;
    private int fLastLine = -1;
    private static final String[] fgStartEnd = new String[]{"charStart", "charEnd"};
    private static final String[] fgLineStartEnd = new String[]{"lineNumber", "charStart", "charEnd"};
    private IStackFrame fStackFrame = null;
    private IEditorInput fEditorInput = null;
    private String fEditorId = null;
    private boolean fIsActive = true;
    private IEditorPart fEditor = null;
    private Object fSourceElement = null;
    private int fEditorIndex = -1;
    private boolean fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_REUSE_EDITOR);
    private IResourceDeltaVisitor fVisitor = null;
    private EditLaunchConfigurationAction fEditConfigAction = null;
    static /* synthetic */ Class class$0;

    public LaunchView() {
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.DEBUG_VIEW;
    }

    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction(this.getSite().getWorkbenchWindow().getShell(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fEditConfigAction);
        Runnable r = new Runnable(){

            public void run() {
                LaunchView.this.initializeSelection();
            }
        };
        this.asyncExec(r);
    }

    protected Viewer createViewer(Composite parent) {
        LaunchViewer lv = new LaunchViewer(parent);
        lv.addSelectionChangedListener(this);
        lv.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LaunchView.this.handleDeleteKeyPressed();
                }
            }
        });
        lv.setContentProvider((IContentProvider)this.createContentProvider());
        lv.setLabelProvider((IBaseLabelProvider)new DelegatingModelPresentation());
        this.getSite().setSelectionProvider((ISelectionProvider)lv);
        lv.setInput(DebugPlugin.getDefault().getLaunchManager());
        this.setEventHandler(new LaunchViewEventHandler(this));
        this.setActive(this.getSite().getPage().findView(this.getSite().getId()) != null);
        return lv;
    }

    private void handleDeleteKeyPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Iterator iter = selection.iterator();
        boolean itemsToTerminate = false;
        while (iter.hasNext()) {
            ITerminate terminable;
            Object item = iter.next();
            if (!(item instanceof ITerminate) || !(terminable = (ITerminate)item).canTerminate() || terminable.isTerminated()) continue;
            itemsToTerminate = true;
            break;
        }
        if (itemsToTerminate && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)DebugUIViewsMessages.getString("LaunchView.Terminate_and_Remove_1"), (String)DebugUIViewsMessages.getString("LaunchView.Terminate_and_remove_selected__2"))) {
            return;
        }
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, DebugUIViewsMessages.getString("LaunchView.Exceptions_occurred_attempting_to_terminate_and_remove_3"), null);
        iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                LaunchView.terminateAndRemove(iter.next());
            }
            catch (DebugException exception) {
                status.merge(exception.getStatus());
            }
        }
        if (!status.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIViewsMessages.getString("LaunchView.Terminate_and_Remove_4"), DebugUIViewsMessages.getString("LaunchView.Terminate_and_remove_failed_5"), (IStatus)status);
            } else {
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    public static void terminateAndRemove(Object element) throws DebugException {
        if (!(element instanceof ITerminate)) {
            return;
        }
        ITerminate terminable = (ITerminate)element;
        if (!terminable.canTerminate() && !terminable.isTerminated()) {
            return;
        }
        try {
            if (!terminable.isTerminated()) {
                terminable.terminate();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            LaunchView.remove(element);
            throw throwable;
        }
        Object var2_4 = null;
        LaunchView.remove(element);
    }

    private static void remove(Object element) {
        ILaunch launch = null;
        if (element instanceof ILaunch) {
            launch = (ILaunch)element;
        } else if (element instanceof IDebugElement) {
            launch = ((IDebugElement)element).getLaunch();
        } else if (element instanceof IProcess) {
            launch = ((IProcess)element).getLaunch();
        } else {
            return;
        }
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        lManager.removeLaunch(launch);
    }

    protected void initializeSelection() {
        if (!this.isAvailable()) {
            return;
        }
        TreeViewer tv = (TreeViewer)this.getViewer();
        tv.expandToLevel(2);
        Object[] elements = tv.getExpandedElements();
        int i = 0;
        while (i < elements.length) {
            IStackFrame frame;
            if (elements[i] instanceof ILaunch && (frame = this.findFrame((ILaunch)elements[i])) != null) {
                this.autoExpand(frame, false, true);
            }
            ++i;
        }
    }

    protected IStackFrame findFrame(ILaunch launch) {
        IDebugTarget target = launch.getDebugTarget();
        if (target != null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].isSuspended()) {
                        return threads[i].getTopStackFrame();
                    }
                    ++i;
                }
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addPartListener((IPartListener)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String index;
        super.init(site, memento);
        site.getPage().addPartListener((IPartListener)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        if (this.fReuseEditor && memento != null && (index = memento.getString(IDebugUIConstants.PREF_REUSE_EDITOR)) != null) {
            try {
                this.fEditorIndex = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    public void dispose() {
        if (this.getViewer() != null) {
            this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        this.getSite().getWorkbenchWindow().removePageListener((IPageListener)this);
        this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fEditConfigAction);
        this.cleanup();
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void cleanup() {
        this.setEditorId(null);
        this.setEditorInput(null);
        this.setStackFrame(null);
    }

    protected IStructuredContentProvider createContentProvider() {
        return new LaunchViewContentProvider();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.clearStatusLine();
        this.updateObjects();
        this.showEditorForCurrentSelection();
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer tViewer;
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o instanceof IStackFrame) {
            return;
        }
        boolean expanded = (tViewer = (TreeViewer)this.getViewer()).getExpandedState(o);
        tViewer.setExpandedState(o, !expanded);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
        this.showEditorForCurrentSelection();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
            this.showEditorForCurrentSelection();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.fEditor)) {
            this.fEditor = null;
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    protected IMarker getInstructionPointer(final int lineNumber, final int charStart, final int charEnd) {
        if (this.fInstructionPointer == null) {
            try {
                this.fInstructionPointer = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.debug.ui.instructionPointer");
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                return null;
            }
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (lineNumber == -1) {
                    LaunchView.this.fInstructionPointer.setAttributes(fgStartEnd, new Object[]{new Integer(charStart), new Integer(charEnd)});
                } else {
                    LaunchView.this.fInstructionPointer.setAttributes(fgLineStartEnd, new Object[]{new Integer(lineNumber), new Integer(charStart), new Integer(charEnd)});
                }
            }
        };
        try {
            workspace.run(runnable, null);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return this.fInstructionPointer;
    }

    protected void showEditorForCurrentSelection() {
        if (!this.isActive()) {
            return;
        }
        ISelection selection = this.getViewer().getSelection();
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
        }
        if (!(obj instanceof IStackFrame)) {
            return;
        }
        this.openEditorForStackFrame((IStackFrame)obj);
    }

    private void lookupEditorInput(IStackFrame stackFrame) {
        this.setEditorId(null);
        this.setEditorInput(null);
        this.setSourceElement(null);
        Object sourceElement = null;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return;
        }
        sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement == null) {
            this.sourceNotFound(stackFrame);
            return;
        }
        ISourcePresentation presentation = null;
        presentation = locator instanceof ISourcePresentation ? (ISourcePresentation)locator : this.getPresentation(stackFrame.getModelIdentifier());
        IEditorInput editorInput = null;
        String editorId = null;
        if (presentation != null) {
            editorInput = presentation.getEditorInput(sourceElement);
        }
        if (editorInput != null) {
            editorId = presentation.getEditorId(editorInput, sourceElement);
        }
        this.setEditorInput(editorInput);
        this.setEditorId(editorId);
        this.setSourceElement(sourceElement);
    }

    private void sourceNotFound(IStackFrame frame) {
        this.setEditorInput(new SourceNotFoundEditorInput(frame));
        this.setEditorId("org.eclipse.debug.ui.NoSourceFoundEditor");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openEditorForStackFrame(IStackFrame stackFrame) {
        block17: {
            block16: {
                block15: {
                    if (this.fShowingEditor) {
                        return;
                    }
                    try {
                        this.fShowingEditor = true;
                        if (!stackFrame.isSuspended()) {
                            Object var7_2 = null;
                            this.fShowingEditor = false;
                            return;
                        }
                        if (stackFrame.equals(this.getStackFrame())) {
                            if (this.getEditorInput() == null || this.getEditorId() == null) {
                                this.lookupEditorInput(stackFrame);
                            }
                        } else {
                            this.setStackFrame(stackFrame);
                            this.lookupEditorInput(stackFrame);
                        }
                        if (this.getEditorInput() == null) break block15;
                        if (this.getEditorId() == null) {
                            break block15;
                        }
                        IEditorPart editor = this.openEditor();
                        if (editor == null) {
                            break block16;
                        }
                        int lineNumber = 0;
                        int charStart = -1;
                        int charEnd = -1;
                        try {
                            lineNumber = stackFrame.getLineNumber();
                            charStart = stackFrame.getCharStart();
                            charEnd = stackFrame.getCharEnd();
                        }
                        catch (DebugException de) {
                            DebugUIPlugin.log(de);
                        }
                        if (lineNumber >= 0 || charStart >= 0) {
                            if (editor instanceof ITextEditor) {
                                this.selectAndReveal((ITextEditor)editor, lineNumber, charStart, charEnd);
                                InstructionPointerManager.getDefault().addAnnotation((ITextEditor)editor, stackFrame);
                            } else {
                                IMarker marker = this.getInstructionPointer(lineNumber, charStart, charEnd);
                                if (marker != null) {
                                    editor.gotoMarker(marker);
                                }
                            }
                            this.fLastCharStart = charStart;
                            this.fLastCharEnd = charEnd;
                            this.fLastLine = lineNumber;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var7_5 = null;
                        this.fShowingEditor = false;
                        throw throwable;
                    }
                }
                Object var7_3 = null;
                this.fShowingEditor = false;
                return;
            }
            Object var7_4 = null;
            this.fShowingEditor = false;
            return;
        }
        Object var7_6 = null;
        this.fShowingEditor = false;
    }

    private void selectAndReveal(ITextEditor editor, int lineNumber, int charStart, int charEnd) {
        --lineNumber;
        if (charStart > 0 && charEnd > charStart) {
            editor.selectAndReveal(charStart, charEnd - charStart);
            return;
        }
        int offset = -1;
        int length = -1;
        IRegion region = this.getLineInformation(editor, lineNumber);
        if (region == null) {
            IMarker marker;
            if ((marker = this.getInstructionPointer(++lineNumber, charStart, charEnd)) != null) {
                editor.gotoMarker(marker);
            }
            return;
        }
        offset = charStart > 0 ? charStart : region.getOffset();
        length = region.getLength();
        editor.selectAndReveal(offset, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IEditorInput input;
        IDocumentProvider provider;
        block6: {
            IRegion iRegion;
            provider = editor.getDocumentProvider();
            input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                try {
                    IDocument document = provider.getDocument((Object)input);
                    if (document == null) break block6;
                    iRegion = document.getLineInformation(lineNumber);
                    Object var6_7 = null;
                }
                catch (BadLocationException badLocationException) {
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
            return iRegion;
        }
        Object var6_9 = null;
        provider.disconnect((Object)input);
        return null;
    }

    private IEditorPart openEditor() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        if (this.fEditorIndex >= 0) {
            IEditorReference[] refs = page.getEditorReferences();
            if (this.fEditorIndex < refs.length) {
                this.fEditor = refs[this.fEditorIndex].getEditor(false);
            }
            this.fEditorIndex = -1;
        }
        IEditorPart editor = null;
        IEditorInput input = this.getEditorInput();
        String id = this.getEditorId();
        if (input == null || id == null) {
            return null;
        }
        if (this.fReuseEditor) {
            editor = page.getActiveEditor();
            if (editor != null && !editor.getEditorInput().equals(input)) {
                editor = null;
            }
            if (editor == null) {
                IEditorReference[] refs = page.getEditorReferences();
                int i = 0;
                while (i < refs.length) {
                    IEditorPart refEditor = refs[i].getEditor(true);
                    if (refEditor != null && input.equals(refEditor.getEditorInput())) {
                        editor = refEditor;
                        page.bringToTop((IWorkbenchPart)editor);
                        break;
                    }
                    ++i;
                }
            }
            if (editor == null) {
                if (this.fEditor == null || this.fEditor.isDirty() || page.isEditorPinned(this.fEditor)) {
                    this.fEditor = editor = this.openEditor(page, input, id);
                } else if (this.fEditor instanceof IReusableEditor && this.fEditor.getSite().getId().equals(id)) {
                    ((IReusableEditor)this.fEditor).setInput(input);
                    editor = this.fEditor;
                    page.bringToTop((IWorkbenchPart)editor);
                } else {
                    page.closeEditor(this.fEditor, false);
                    this.fEditor = editor = this.openEditor(page, input, id);
                }
            }
        } else {
            editor = this.openEditor(page, input, id);
        }
        return editor;
    }

    private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    editor[0] = page.openEditor(input, id, false);
                }
                catch (PartInitException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.getString("LaunchView.Error_1"), DebugUIViewsMessages.getString("LaunchView.Exception_occurred_opening_editor_for_debugger._2"), e);
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return editor[0];
    }

    public void clearSourceSelection() {
        this.cleanup();
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (!(editor instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editor;
        ITextSelection textSelection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        if (textSelection.isEmpty()) {
            return;
        }
        int startChar = textSelection.getOffset();
        int endChar = startChar + textSelection.getLength() - 1;
        int startLine = textSelection.getStartLine();
        if (this.fLastCharStart == -1 ? this.fLastLine - 1 != startLine : this.fLastCharStart != startChar || this.fLastCharEnd != endChar) {
            return;
        }
        ITextSelection nullSelection = this.getNullSelection(startLine, startChar);
        textEditor.getSelectionProvider().setSelection((ISelection)nullSelection);
    }

    protected ITextSelection getNullSelection(final int startLine, final int startChar) {
        return new ITextSelection(){

            public int getStartLine() {
                return startLine;
            }

            public int getEndLine() {
                return startLine;
            }

            public int getOffset() {
                return startChar;
            }

            public String getText() {
                return "";
            }

            public int getLength() {
                return 0;
            }

            public boolean isEmpty() {
                return true;
            }
        };
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        if (this.fEditConfigAction.isEnabled()) {
            menu.add((IAction)this.fEditConfigAction);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        action.setEnabled(action.isApplicableForSelection());
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void autoExpand(Object element, boolean refreshNeeded, boolean selectNeeded) {
        Object selectee = element;
        IThread[] children = null;
        if (element instanceof IThread) {
            if (!refreshNeeded) {
                refreshNeeded = this.threadRefreshNeeded((IThread)element);
            }
            try {
                selectee = ((IThread)element).getTopStackFrame();
            }
            catch (DebugException debugException) {}
            if (selectee == null) {
                selectee = element;
            }
        } else if (element instanceof ILaunch) {
            IDebugTarget dt = ((ILaunch)element).getDebugTarget();
            if (dt != null) {
                selectee = dt;
                try {
                    children = dt.getThreads();
                }
                catch (DebugException de) {
                    DebugUIPlugin.log(de);
                }
            } else {
                IProcess[] processes = ((ILaunch)element).getProcesses();
                if (processes.length != 0) {
                    selectee = processes[0];
                }
            }
        }
        if (refreshNeeded) {
            this.getStructuredViewer().refresh(element);
        }
        if (selectNeeded) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(selectee), true);
        }
        if (children != null && children.length > 0) {
            this.getStructuredViewer().reveal((Object)children[0]);
        }
    }

    protected boolean threadRefreshNeeded(IThread thread) {
        LaunchViewer viewer = (LaunchViewer)this.getStructuredViewer();
        ILaunch launch = thread.getLaunch();
        TreeItem[] launches = viewer.getTree().getItems();
        int i = 0;
        block2: while (i < launches.length) {
            if (launches[i].getData() == launch) {
                IDebugTarget target = thread.getDebugTarget();
                TreeItem[] targets = launches[i].getItems();
                int j = 0;
                while (j < targets.length) {
                    if (targets[j].getData() == target) {
                        TreeItem[] threads = targets[j].getItems();
                        int k = 0;
                        while (k < threads.length) {
                            if (threads[k].getData() == thread) {
                                IStackFrame[] frames = null;
                                try {
                                    frames = thread.getStackFrames();
                                }
                                catch (DebugException debugException) {
                                    return true;
                                }
                                TreeItem[] treeFrames = threads[k].getItems();
                                if (frames.length != treeFrames.length) {
                                    return true;
                                }
                                int l = 0;
                                int numFrames = treeFrames.length;
                                while (l < numFrames) {
                                    if (treeFrames[l].getData() != frames[l]) {
                                        return true;
                                    }
                                    ++l;
                                }
                                break block2;
                            }
                            ++k;
                        }
                        break block2;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return false;
    }

    protected IStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    protected void setStackFrame(IStackFrame frame) {
        this.fStackFrame = frame;
    }

    private void setEditorInput(IEditorInput editorInput) {
        this.fEditorInput = editorInput;
    }

    protected IEditorInput getEditorInput() {
        return this.fEditorInput;
    }

    private void setEditorId(String editorId) {
        this.fEditorId = editorId;
    }

    protected String getEditorId() {
        return this.fEditorId;
    }

    private void setSourceElement(Object sourceElement) {
        this.fSourceElement = sourceElement;
    }

    protected Object getSourceElement() {
        return this.fSourceElement;
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IDebugUIConstants.PREF_REUSE_EDITOR)) {
            this.fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_REUSE_EDITOR);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fReuseEditor && this.fEditor != null) {
            IWorkbenchWindow dwindow = this.getSite().getWorkbenchWindow();
            if (dwindow == null) {
                return;
            }
            IWorkbenchPage page = dwindow.getActivePage();
            if (page == null) {
                return;
            }
            IEditorReference[] refs = page.getEditorReferences();
            int index = -1;
            int i = 0;
            while (i < refs.length) {
                if (this.fEditor.equals(refs[i].getEditor(false))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                memento.putString(IDebugUIConstants.PREF_REUSE_EDITOR, Integer.toString(index));
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept(this.getVisitor());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    protected IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new LaunchViewVisitor();
        }
        return this.fVisitor;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.isEmpty() || !selection.getFirstElement().equals(this.getStackFrame())) {
            this.initializeSelection();
        }
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            this.getViewer().setSelection(selection, true);
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        Object sourceElement;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()) != null && !selection.isEmpty() && (sourceElement = this.getSourceElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) {
                return new ShowInContext(null, (ISelection)new StructuredSelection(this.getSourceElement()));
            }
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    }

    class LaunchViewVisitor
    implements IResourceDeltaVisitor {
        LaunchViewVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if ((delta.getFlags() & 0x4000) != 0) {
                IProject project;
                if (resource instanceof IProject && !(project = (IProject)resource).isOpen()) {
                    LaunchView.this.cleanup();
                }
                return false;
            }
            return resource instanceof IWorkspaceRoot;
        }
    }
}

