/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleView;
import org.eclipse.debug.internal.ui.views.console.ShowCurrentProcessAction;
import org.eclipse.debug.internal.ui.views.console.ShowProcessAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class ProcessDropDownAction
extends Action
implements IMenuCreator,
ILaunchListener {
    private ConsoleView fView;
    private Menu fMenu;

    public ProcessDropDownAction(ConsoleView view) {
        this.fView = view;
        this.setText(ActionMessages.getString("ProcessDropDownAction.Select_Process_1"));
        this.setToolTipText(ActionMessages.getString("ProcessDropDownAction.Display_output_of_selected_process._2"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_OBJS_OS_PROCESS"));
        this.setMenuCreator(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int mode = this.fView.getMode();
        boolean terminatedLaunches = false;
        IProcess[] processes = DebugPlugin.getDefault().getLaunchManager().getProcesses();
        IProcess current = this.fView.getProcess();
        int i = 0;
        while (i < processes.length) {
            IProcess process = processes[i];
            ShowProcessAction action = new ShowProcessAction(this.fView, process);
            action.setChecked(mode == 2 && process.equals(current));
            this.addActionToMenu(this.fMenu, action);
            ILaunch launch = process.getLaunch();
            if (launch.isTerminated()) {
                terminatedLaunches = true;
            }
            ++i;
        }
        if (processes.length > 0) {
            this.addMenuSeparator();
        }
        Action action = new ShowCurrentProcessAction(this.fView);
        action.setChecked(mode == 1);
        this.addActionToMenu(this.fMenu, action);
        if (terminatedLaunches) {
            action = new ConsoleRemoveAllTerminatedAction();
            this.addActionToMenu(this.fMenu, action);
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    protected void addMenuSeparator() {
        new MenuItem(this.fMenu, 2);
    }

    public void run() {
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
        Display display = DebugUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (ProcessDropDownAction.this.fMenu != null) {
                    ProcessDropDownAction.this.fMenu.dispose();
                }
            }
        });
    }
}

