/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ClearOutputAction;
import org.eclipse.debug.internal.ui.actions.FollowHyperlinkAction;
import org.eclipse.debug.internal.ui.actions.KeyBindingFollowHyperlinkAction;
import org.eclipse.debug.internal.ui.actions.TextViewerAction;
import org.eclipse.debug.internal.ui.actions.TextViewerGotoLineAction;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocument;
import org.eclipse.debug.internal.ui.views.console.ConsoleOutputTextStore;
import org.eclipse.debug.internal.ui.views.console.ConsoleViewEventHandler;
import org.eclipse.debug.internal.ui.views.console.ConsoleViewer;
import org.eclipse.debug.internal.ui.views.console.ProcessDropDownAction;
import org.eclipse.debug.internal.ui.views.console.ScrollLockAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleView
extends AbstractDebugEventHandlerView
implements IDocumentListener,
ISelectionListener,
IShowInSource,
IShowInTargetList {
    protected ClearOutputAction fClearOutputAction = null;
    protected FollowHyperlinkAction fFollowLinkAction = null;
    protected KeyBindingFollowHyperlinkAction fKeyBindingFollowLinkAction = null;
    protected ProcessDropDownAction fProcessDropDownAction = null;
    protected ScrollLockAction fScrollLockAction = null;
    private boolean fIsLocked = false;
    protected Map fGlobalActions = new HashMap(10);
    protected List fSelectionActions = new ArrayList(3);
    protected IDocument fCurrentDocument = null;
    protected int fMode = 1;
    public static final int MODE_CURRENT_PROCESS = 1;
    public static final int MODE_SPECIFIC_PROCESS = 2;
    private IProcess fProcess;
    private ILaunchListener fLaunchListener = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected Viewer createViewer(Composite parent) {
        ConsoleViewer cv = new ConsoleViewer(parent);
        cv.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        cv.addTextInputListener(this.getTextInputListener());
        this.getSite().setSelectionProvider(cv.getSelectionProvider());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(new ConsoleViewEventHandler(this));
        return cv;
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.CONSOLE_VIEW;
    }

    public void setViewerInputFromConsoleDocumentManager(IProcess process) {
        IViewPart debugView;
        if (this.getMode() == 1 && ((debugView = this.findView("org.eclipse.debug.ui.DebugView")) == null || process == null)) {
            this.setViewerInput(process);
        }
    }

    public void setViewerInput(IProcess process) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.getProcess() == process) {
            if (this.getConsoleViewer().getDocument() == null) {
                this.getConsoleViewer().setDocument((IDocument)new EmptyConsoleDocument());
                this.getConsoleViewer().setEditable(false);
                this.updateObjects();
            }
            return;
        }
        this.setProcess(process);
        Runnable r = new Runnable(){

            public void run() {
                if (!ConsoleView.this.isAvailable()) {
                    return;
                }
                Object doc = null;
                if (ConsoleView.this.getProcess() != null) {
                    doc = DebugUIPlugin.getDefault().getConsoleDocumentManager().getConsoleDocument(ConsoleView.this.getProcess());
                }
                if (doc == null) {
                    doc = new EmptyConsoleDocument();
                }
                ConsoleView.this.getConsoleViewer().setDocument((IDocument)doc);
                ConsoleView.this.getConsoleViewer().setEditable(ConsoleView.this.getProcess() != null && !ConsoleView.this.getProcess().isTerminated());
                ConsoleView.this.updateTitle();
                ConsoleView.this.updateObjects();
                ConsoleView.this.updateSelectionDependentActions();
                ConsoleView.this.fKeyBindingFollowLinkAction.clearStatusLine();
            }
        };
        this.asyncExec(r);
    }

    protected void updateTitle() {
        String title = null;
        if (this.getProcess() == null) {
            title = DebugUIViewsMessages.getString("ConsoleView.Console_1");
        } else {
            Object obj;
            IProcess iProcess = this.getProcess();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((obj = iProcess.getAdapter((Class)clazz)) == null) {
                obj = this.getProcess();
            }
            StringBuffer buff = new StringBuffer(DebugUIViewsMessages.getString("ConsoleView.Console_1"));
            buff.append(" [");
            buff.append(DebugUIPlugin.getModelPresentation().getText(obj));
            buff.append(']');
            title = buff.toString();
        }
        this.setTitle(title);
    }

    protected void createActions() {
        this.fClearOutputAction = new ClearOutputAction(this.getConsoleViewer());
        IActionBars actionBars = this.getViewSite().getActionBars();
        TextViewerAction action = new TextViewerAction((ITextViewer)this.getTextViewer(), 3);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.Cu&t@Ctrl+X_3"), DebugUIViewsMessages.getString("ConsoleView.Cut_4"), DebugUIViewsMessages.getString("ConsoleView.Cut_4"));
        this.setGlobalAction(actionBars, "cut", (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getTextViewer(), 4);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.&Copy@Ctrl+C_6"), DebugUIViewsMessages.getString("ConsoleView.Copy_7"), DebugUIViewsMessages.getString("ConsoleView.Copy_7"));
        this.setGlobalAction(actionBars, "copy", (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getTextViewer(), 5);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.&Paste@Ctrl+V_9"), DebugUIViewsMessages.getString("ConsoleView.Paste_10"), DebugUIViewsMessages.getString("ConsoleView.Paste_Clipboard_Text_11"));
        this.setGlobalAction(actionBars, "paste", (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getTextViewer(), 7);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.Select_&All@Ctrl+A_12"), DebugUIViewsMessages.getString("ConsoleView.Select_All"), DebugUIViewsMessages.getString("ConsoleView.Select_All"));
        this.setGlobalAction(actionBars, "selectAll", (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.debug.internal.ui.views.DebugUIViewsMessages");
        this.setGlobalAction(actionBars, "find", (IAction)new FindReplaceAction(bundle, "find_replace_action.", (IWorkbenchPart)this));
        action = new TextViewerGotoLineAction(this.getConsoleViewer());
        this.setGlobalAction(actionBars, "GotoLine", (IAction)action);
        this.fFollowLinkAction = new FollowHyperlinkAction((ISelectionProvider)this.getConsoleViewer());
        this.fKeyBindingFollowLinkAction = new KeyBindingFollowHyperlinkAction(this);
        this.fKeyBindingFollowLinkAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.getSite().getKeyBindingService().registerAction((IAction)this.fKeyBindingFollowLinkAction);
        this.fProcessDropDownAction = new ProcessDropDownAction(this);
        this.fScrollLockAction = new ScrollLockAction(this.getConsoleViewer());
        this.fScrollLockAction.setChecked(this.fIsLocked);
        this.getConsoleViewer().setAutoScroll(!this.fIsLocked);
        actionBars.updateActionBars();
        this.getConsoleViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                IAction gotoLine;
                if (event.stateMask == 262144 && event.keyCode == 0 && event.character == '\f' && (gotoLine = (IAction)ConsoleView.this.fGlobalActions.get("GotoLine")).isEnabled()) {
                    gotoLine.run();
                    event.doit = false;
                }
            }
        });
        this.fSelectionActions.add("cut");
        this.fSelectionActions.add("copy");
        this.fSelectionActions.add("paste");
        this.setViewerInput(DebugUITools.getCurrentProcess());
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.add((IContributionItem)new Separator("launchGroup"));
        mgr.add((IContributionItem)new Separator("outputGroup"));
        mgr.add((IAction)this.fProcessDropDownAction);
        mgr.add((IAction)this.fScrollLockAction);
        mgr.add((IAction)this.fClearOutputAction);
    }

    protected void fillContextMenu(IMenuManager menu) {
        ConsoleDocument doc = (ConsoleDocument)this.getConsoleViewer().getDocument();
        if (doc == null) {
            return;
        }
        if (doc.isReadOnly()) {
            menu.add((IAction)this.fGlobalActions.get("copy"));
            menu.add((IAction)this.fGlobalActions.get("selectAll"));
        } else {
            this.updateAction("paste");
            menu.add((IAction)this.fGlobalActions.get("cut"));
            menu.add((IAction)this.fGlobalActions.get("copy"));
            menu.add((IAction)this.fGlobalActions.get("paste"));
            menu.add((IAction)this.fGlobalActions.get("selectAll"));
        }
        menu.add((IContributionItem)new Separator("FIND"));
        menu.add((IAction)this.fGlobalActions.get("find"));
        menu.add((IAction)this.fGlobalActions.get("GotoLine"));
        this.fFollowLinkAction.setEnabled(this.fFollowLinkAction.getHyperLink() != null);
        menu.add((IAction)this.fFollowLinkAction);
        menu.add((IAction)this.fClearOutputAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public Object getAdapter(Class required) {
        if (!this.isAvailable()) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getConsoleViewer().getFindReplaceTarget();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.getConsoleViewer().getTextWidget();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            return this;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(required)) {
            return this;
        }
        return super.getAdapter(required);
    }

    protected final ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConsoleView.this.updateSelectionDependentActions();
            }
        };
    }

    protected final ITextInputListener getTextInputListener() {
        return new ITextInputListener(){

            public void inputDocumentAboutToBeChanged(IDocument old, IDocument nw) {
                if (old != null) {
                    old.removeDocumentListener((IDocumentListener)ConsoleView.this);
                }
                ConsoleView.this.fCurrentDocument = nw;
                if (nw != null) {
                    nw.addDocumentListener((IDocumentListener)ConsoleView.this);
                }
            }

            public void inputDocumentChanged(IDocument doc, IDocument doc2) {
                ConsoleView.this.updateAction("find");
            }
        };
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        if (!this.isAvailable()) {
            return;
        }
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        if (this.getConsoleViewer() != null) {
            this.getConsoleViewer().dispose();
        }
        if (this.fCurrentDocument != null) {
            this.fCurrentDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fFollowLinkAction != null) {
            this.fFollowLinkAction.dispose();
        }
        if (this.fKeyBindingFollowLinkAction != null) {
            this.fKeyBindingFollowLinkAction.dispose();
            this.getSite().getKeyBindingService().unregisterAction((IAction)this.fKeyBindingFollowLinkAction);
        }
        if (this.fLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchListener);
            this.fLaunchListener = null;
        }
        if (this.fProcessDropDownAction != null) {
            this.fProcessDropDownAction.dispose();
            this.fProcessDropDownAction = null;
        }
        super.dispose();
    }

    public void documentAboutToBeChanged(DocumentEvent e) {
    }

    public void documentChanged(DocumentEvent e) {
        this.updateAction("find");
    }

    public ConsoleViewer getConsoleViewer() {
        return (ConsoleViewer)this.getViewer();
    }

    private void setProcess(IProcess process) {
        this.fProcess = process;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getMode() == 1) {
            this.setViewerInput(DebugUITools.getCurrentProcess());
        }
    }

    protected void becomesHidden() {
        super.becomesHidden();
        this.getConsoleViewer().setVisible(false);
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getConsoleViewer().setVisible(true);
    }

    protected int getMode() {
        return this.fMode;
    }

    protected void setMode(int mode) {
        if (this.getMode() != mode) {
            this.fMode = mode;
            if (mode == 2) {
                this.fLaunchListener = new LaunchListener();
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fLaunchListener);
            } else if (this.fLaunchListener != null) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchListener);
                this.fLaunchListener = null;
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fScrollLockAction != null) {
            memento.putString(String.valueOf(this.getViewSite().getId()) + ".scrollLock", new Boolean(this.fScrollLockAction.isChecked()).toString());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String lock;
        super.init(site, memento);
        if (memento != null && (lock = memento.getString(String.valueOf(site.getId()) + ".scrollLock")) != null) {
            this.fIsLocked = new Boolean(lock);
        }
    }

    public ShowInContext getShowInContext() {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter((Class)clazz);
        StructuredSelection selection = null;
        selection = target == null ? new StructuredSelection((Object)process) : new StructuredSelection((Object)target);
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    class EmptyConsoleDocument
    extends ConsoleDocument {
        public EmptyConsoleDocument() {
            super(new ConsoleColorProvider());
        }

        protected ITextStore newTextStore() {
            return new ConsoleOutputTextStore(0);
        }
    }

    class LaunchListener
    implements ILaunchListener {
        LaunchListener() {
        }

        public void launchAdded(ILaunch launch) {
        }

        public void launchChanged(ILaunch launch) {
        }

        public void launchRemoved(ILaunch launch) {
            IProcess process;
            if (ConsoleView.this.getMode() == 2 && (process = ConsoleView.this.getProcess()) != null && launch.equals(process.getLaunch())) {
                ConsoleView.this.setMode(1);
                ConsoleView.this.setViewerInput(DebugUITools.getCurrentProcess());
            }
        }
    }
}

