/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.ListenerList;

public class ConsoleLineNotifier
implements IDebugEventSetListener {
    private int fLinesProcessed = 0;
    private ListenerList fListeners = new ListenerList(2);
    private IConsole fConsole = null;

    public void connect(IConsole console) {
        this.fConsole = console;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
            listener.init(console);
            ++i;
        }
    }

    public void disconnect() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
            listener.dispose();
            ++i;
        }
        this.fListeners = null;
        this.fConsole = null;
    }

    public void consoleChanged(DocumentEvent event) {
        this.processNewLines();
    }

    protected synchronized void processNewLines() {
        IDocument document = this.fConsole.getDocument();
        int lines = document.getNumberOfLines();
        Object[] listeners = this.fListeners.getListeners();
        int line = this.fLinesProcessed;
        while (line < lines) {
            String delimiter = null;
            try {
                delimiter = document.getLineDelimiter(line);
            }
            catch (BadLocationException e) {
                DebugUIPlugin.log(e);
                return;
            }
            if (delimiter == null && !this.fConsole.getProcess().isTerminated()) {
                return;
            }
            ++this.fLinesProcessed;
            IRegion lineRegion = null;
            try {
                lineRegion = document.getLineInformation(line);
            }
            catch (BadLocationException e) {
                DebugUIPlugin.log(e);
                return;
            }
            int i = 0;
            while (i < listeners.length) {
                IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
                listener.lineAppended(lineRegion);
                ++i;
            }
            ++line;
        }
    }

    public void addConsoleListener(IConsoleLineTracker listener) {
        this.fListeners.add((Object)listener);
    }

    protected void setLinesProcessed(int linesProcessed) {
        this.fLinesProcessed = linesProcessed;
    }

    protected int getLinesProcessed() {
        return this.fLinesProcessed;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.fConsole != null) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                if (event.getSource() == this.fConsole.getProcess() && event.getKind() == 8) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    this.processNewLines();
                }
                ++i;
            }
        }
    }
}

