/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.BreakPartition;
import org.eclipse.debug.internal.ui.views.console.ConsoleLineNotifier;
import org.eclipse.debug.internal.ui.views.console.HyperlinkPosition;
import org.eclipse.debug.internal.ui.views.console.InputPartition;
import org.eclipse.debug.internal.ui.views.console.OutputPartition;
import org.eclipse.debug.internal.ui.views.console.StreamPartition;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class ConsoleDocumentPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IPropertyChangeListener,
IConsole {
    private boolean fClosed = false;
    private boolean fKilled = false;
    protected IProcess fProcess;
    protected IConsoleColorProvider fContentProvider;
    private IStreamsProxy fProxy;
    protected List fStreamListeners = new ArrayList(2);
    private String[] fSortedLineDelimiters;
    private boolean fUpdatingBuffer = false;
    private int fLowWaterMark;
    private int fHighWaterMark;
    private Vector fQueue = new Vector(10);
    private Thread fPollingThread = null;
    private boolean fAppending = false;
    private boolean fPoll = false;
    private IDocument fDocument = null;
    private int fLineLength = 0;
    private int fMaxLineLength = 80;
    private boolean fWrap = false;
    private List fPartitions = new ArrayList(5);
    private static final long BASE_DELAY = 100L;
    private String fLastStreamIdentifier = null;
    private StringBuffer fInputBuffer = new StringBuffer();
    private Vector fPendingLinks = new Vector();
    private ConsoleLineNotifier fLineNotifier = null;

    public void connect(IDocument document) {
        this.fDocument = document;
        this.fDocument.addPositionCategory(HyperlinkPosition.HYPER_LINK_CATEGORY);
        document.setDocumentPartitioner((IDocumentPartitioner)this);
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        this.fWrap = store.getBoolean("Console.wrap");
        this.fMaxLineLength = store.getInt("Console.width");
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fContentProvider.connect(this.fProcess, this);
    }

    public void disconnect() {
        this.kill();
        if (this.fLineNotifier != null) {
            this.fLineNotifier.disconnect();
        }
        this.fContentProvider.disconnect();
        this.fDocument.setDocumentPartitioner(null);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{InputPartition.INPUT_PARTITION_TYPE, OutputPartition.OUTPUT_PARTITION_TYPE, BreakPartition.BREAK_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        ITypedRegion[] affectedRegions;
        if (this.fUpdatingBuffer) {
            return new Region(0, this.fDocument.getLength());
        }
        this.addPendingLinks();
        String text = event.getText();
        if (this.isAppendInProgress()) {
            this.addPartition(new OutputPartition(this.fLastStreamIdentifier, event.getOffset(), text.length()));
            if (this.fLineNotifier != null) {
                this.fLineNotifier.consoleChanged(event);
            }
        } else {
            int amountDeleted = event.getLength() - text.length();
            int docLength = this.fDocument.getLength();
            int bufferStartOffset = docLength + amountDeleted - this.fInputBuffer.length();
            int bufferModifyOffset = event.getOffset() - bufferStartOffset;
            int bufferModifyOffsetEnd = bufferModifyOffset + event.getLength();
            if (docLength == 0) {
                this.fQueue.clear();
                this.fInputBuffer.setLength(0);
                this.fPartitions.clear();
                if (this.fLineNotifier != null) {
                    this.fLineNotifier.setLinesProcessed(0);
                }
                try {
                    Position[] positions = this.fDocument.getPositions(HyperlinkPosition.HYPER_LINK_CATEGORY);
                    int i = 0;
                    while (i < positions.length) {
                        Position position = positions[i];
                        this.fDocument.removePosition(HyperlinkPosition.HYPER_LINK_CATEGORY, position);
                        ++i;
                    }
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                return new Region(0, 0);
            }
            if (amountDeleted > 0) {
                this.fInputBuffer.replace(bufferModifyOffset, bufferModifyOffsetEnd, text);
                InputPartition partition = new InputPartition(IDebugUIConstants.ID_STANDARD_INPUT_STREAM, bufferStartOffset, this.fInputBuffer.length());
                this.fPartitions.set(this.fPartitions.size() - 1, partition);
            } else {
                String[] lineDelimiters = this.getLegalLineDelimiters();
                StringBuffer temp = new StringBuffer(this.fInputBuffer.toString());
                temp.replace(bufferModifyOffset, bufferModifyOffsetEnd, text);
                String remaining = temp.toString();
                int partitionOffset = bufferStartOffset;
                this.fInputBuffer.setLength(0);
                boolean includesLF = false;
                int i = lineDelimiters.length - 1;
                while (i >= 0) {
                    int lf = remaining.indexOf(lineDelimiters[i]);
                    while (lf >= 0) {
                        includesLF = true;
                        int split = lf + lineDelimiters[i].length();
                        this.fInputBuffer.append(remaining.substring(0, split));
                        remaining = remaining.substring(split);
                        String buffer = this.fInputBuffer.toString();
                        this.fInputBuffer.setLength(0);
                        InputPartition written = (InputPartition)this.addPartition(new InputPartition(IDebugUIConstants.ID_STANDARD_INPUT_STREAM, partitionOffset, split));
                        written.setReadOnly(true);
                        this.addPartition(new InputPartition(IDebugUIConstants.ID_STANDARD_INPUT_STREAM, partitionOffset += split, 0));
                        if (this.fProxy != null) {
                            try {
                                this.fProxy.write(buffer);
                            }
                            catch (IOException ioe) {
                                DebugUIPlugin.log(ioe);
                            }
                        }
                        lf = remaining.indexOf(lineDelimiters[i]);
                    }
                    if (includesLF) break;
                    --i;
                }
                if (remaining.length() > 0) {
                    this.fInputBuffer.append(remaining);
                    this.addPartition(new InputPartition(IDebugUIConstants.ID_STANDARD_INPUT_STREAM, partitionOffset, remaining.length()));
                }
            }
        }
        if ((affectedRegions = this.computePartitioning(event.getOffset(), text.length())).length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    protected StreamPartition addPartition(StreamPartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add(partition);
        } else {
            int index = this.fPartitions.size() - 1;
            StreamPartition last = (StreamPartition)((Object)this.fPartitions.get(index));
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, partition);
            } else {
                this.fPartitions.add(partition);
            }
        }
        return partition;
    }

    protected void addPendingLinks() {
        Vector vector = this.fPendingLinks;
        synchronized (vector) {
            if (this.fPendingLinks.isEmpty()) {
                return;
            }
            Iterator links = ((AbstractList)this.fPendingLinks).iterator();
            while (links.hasNext()) {
                HyperlinkPosition link = (HyperlinkPosition)((Object)links.next());
                if (link.getOffset() + link.getLength() > this.fDocument.getLength()) continue;
                links.remove();
                this.addLink(link.getHyperLink(), link.getOffset(), link.getLength());
            }
        }
    }

    public ConsoleDocumentPartitioner(IProcess process, IConsoleColorProvider contentProvider) {
        this.fProcess = process;
        this.fContentProvider = contentProvider;
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean limit = store.getBoolean("Console.limitConsoleOutput");
        if (limit) {
            this.fLowWaterMark = store.getInt("Console.lowWaterMark");
            this.fHighWaterMark = store.getInt("Console.highWaterMark");
        } else {
            this.fLowWaterMark = -1;
            this.fHighWaterMark = -1;
        }
    }

    public void close() {
        if (!this.fClosed) {
            this.fClosed = true;
            this.fPoll = false;
            Iterator iter = this.fStreamListeners.iterator();
            while (iter.hasNext()) {
                StreamListener listener = (StreamListener)iter.next();
                listener.disconnect();
            }
            DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void kill() {
        this.fKilled = true;
        if (this.fPollingThread != null && this.fPollingThread.isAlive()) {
            this.fPollingThread.interrupt();
        }
        this.close();
    }

    protected boolean isClosed() {
        return this.fClosed;
    }

    public synchronized void startReading() {
        if (this.fPollingThread != null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                ConsoleDocumentPartitioner.this.pollAndSleep();
            }
        };
        this.fPoll = true;
        this.fPollingThread = new Thread(r, "Console Polling Thread");
        this.fPollingThread.start();
    }

    protected void pollAndSleep() {
        while (!(this.fKilled || !this.fPoll || this.isTerminated() && this.fQueue.isEmpty())) {
            this.poll();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void poll() {
        if (this.isAppendInProgress()) {
            return;
        }
        Vector vector = this.fQueue;
        synchronized (vector) {
            StringBuffer buffer = null;
            StreamEntry prev = null;
            int processed = 0;
            int amount = 0;
            String[] lds = this.fDocument.getLegalLineDelimiters();
            while (!this.fKilled && processed < this.fQueue.size() && amount < 8096) {
                StreamEntry entry = (StreamEntry)this.fQueue.get(processed);
                if (prev == null || prev.getStreamIdentifier().equals(entry.getStreamIdentifier())) {
                    String text = entry.getText();
                    if (buffer == null) {
                        buffer = new StringBuffer(text.length());
                    }
                    if (this.isWrap()) {
                        int i = 0;
                        while (i < text.length()) {
                            if (this.fLineLength >= this.fMaxLineLength) {
                                String d = this.getLineDelimiter(text, i, lds);
                                if (d == null) {
                                    buffer.append(lds[0]);
                                } else {
                                    buffer.append(d);
                                    i += d.length();
                                }
                                this.fLineLength = 0;
                            }
                            if (i < text.length()) {
                                String lineDelimiter = this.getLineDelimiter(text, i, lds);
                                if (lineDelimiter == null) {
                                    buffer.append(text.charAt(i));
                                    ++this.fLineLength;
                                } else {
                                    buffer.append(lineDelimiter);
                                    this.fLineLength = 0;
                                    i = i + lineDelimiter.length() - 1;
                                }
                            }
                            ++i;
                        }
                    } else {
                        buffer.append(text);
                    }
                    prev = entry;
                    ++processed;
                    amount += entry.getText().length();
                    continue;
                }
                this.appendToDocument(buffer.toString(), prev.getStreamIdentifier());
                buffer.setLength(0);
                prev = null;
            }
            if (buffer != null) {
                this.appendToDocument(buffer.toString(), prev.getStreamIdentifier());
            }
            int i = 0;
            while (i < processed) {
                this.fQueue.remove(0);
                ++i;
            }
        }
    }

    protected String getLineDelimiter(String text, int pos, String[] lineDelimiters) {
        String ld = null;
        int i = 0;
        while (i < lineDelimiters.length) {
            if (text.regionMatches(pos, lineDelimiters[i], 0, lineDelimiters[i].length())) {
                if (ld == null) {
                    ld = lineDelimiters[i];
                } else if (ld.length() < lineDelimiters[i].length()) {
                    ld = lineDelimiters[i];
                }
            }
            ++i;
        }
        return ld;
    }

    protected boolean isWrap() {
        return this.fWrap;
    }

    protected void appendToDocument(final String text, final String streamIdentifier) {
        Runnable r = new Runnable(){

            public void run() {
                ConsoleDocumentPartitioner.this.setAppendInProgress(true);
                ConsoleDocumentPartitioner.this.fLastStreamIdentifier = streamIdentifier;
                try {
                    ConsoleDocumentPartitioner.this.fDocument.replace(ConsoleDocumentPartitioner.this.fDocument.getLength(), 0, text);
                }
                catch (BadLocationException badLocationException) {}
                ConsoleDocumentPartitioner.this.setAppendInProgress(false);
                ConsoleDocumentPartitioner.this.checkOverflow();
            }
        };
        Display display = DebugUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(r);
        }
    }

    protected void checkOverflow() {
        block21: {
            if (this.fHighWaterMark < 0 || this.fDocument.getLength() <= this.fHighWaterMark) break block21;
            int lineDifference = 0;
            if (this.fLineNotifier != null) {
                int processed = this.fLineNotifier.getLinesProcessed();
                int numLines = this.fDocument.getNumberOfLines();
                lineDifference = numLines - processed;
            }
            int overflow = this.fDocument.getLength() - this.fLowWaterMark;
            this.fUpdatingBuffer = true;
            try {
                Object hyperlinks;
                ArrayList<StreamPartition> newParitions = new ArrayList<StreamPartition>(this.fPartitions.size());
                Iterator partitions = this.fPartitions.iterator();
                while (partitions.hasNext()) {
                    ITypedRegion region = (ITypedRegion)partitions.next();
                    if (!(region instanceof StreamPartition)) continue;
                    StreamPartition streamPartition = (StreamPartition)region;
                    StreamPartition newPartition = null;
                    int offset = region.getOffset();
                    if (offset < overflow) {
                        int endOffset = offset + region.getLength();
                        if (endOffset >= overflow) {
                            int length = endOffset - overflow;
                            newPartition = streamPartition.createNewPartition(streamPartition.getStreamIdentifier(), 0, length);
                        }
                    } else {
                        newPartition = streamPartition.createNewPartition(streamPartition.getStreamIdentifier(), streamPartition.getOffset() - overflow, streamPartition.getLength());
                    }
                    if (newPartition == null) continue;
                    newParitions.add(newPartition);
                }
                this.fPartitions = newParitions;
                try {
                    hyperlinks = this.fDocument.getPositions(HyperlinkPosition.HYPER_LINK_CATEGORY);
                    int i = 0;
                    while (i < ((Position[])hyperlinks).length) {
                        HyperlinkPosition position = (HyperlinkPosition)hyperlinks[i];
                        this.fDocument.removePosition(HyperlinkPosition.HYPER_LINK_CATEGORY, (Position)position);
                        if (position.getOffset() >= overflow) {
                            try {
                                this.fDocument.addPosition(HyperlinkPosition.HYPER_LINK_CATEGORY, (Position)new HyperlinkPosition(position.getHyperLink(), position.getOffset() - overflow, position.getLength()));
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                        ++i;
                    }
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                hyperlinks = this.fPendingLinks;
                synchronized (hyperlinks) {
                    Vector<HyperlinkPosition> newPendingLinks = new Vector<HyperlinkPosition>(this.fPendingLinks.size());
                    Iterator pendingLinks = ((AbstractList)this.fPendingLinks).iterator();
                    while (pendingLinks.hasNext()) {
                        HyperlinkPosition position = (HyperlinkPosition)((Object)pendingLinks.next());
                        if (position.getOffset() < overflow) continue;
                        newPendingLinks.add(new HyperlinkPosition(position.getHyperLink(), position.getOffset() - overflow, position.getLength()));
                    }
                    this.fPendingLinks = newPendingLinks;
                }
                try {
                    this.fDocument.replace(0, overflow, "");
                }
                catch (BadLocationException e) {
                    DebugUIPlugin.log(e);
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (this.fLineNotifier != null) {
                    this.fLineNotifier.setLinesProcessed(this.fDocument.getNumberOfLines() - lineDifference);
                }
                this.fUpdatingBuffer = false;
                throw throwable;
            }
            Object var11_18 = null;
            if (this.fLineNotifier != null) {
                this.fLineNotifier.setLinesProcessed(this.fDocument.getNumberOfLines() - lineDifference);
            }
            this.fUpdatingBuffer = false;
        }
    }

    protected void streamAppended(String text, String streamIdetifier) {
        this.fQueue.add(new StreamEntry(text, streamIdetifier));
    }

    protected void setAppendInProgress(boolean appending) {
        this.fAppending = appending;
    }

    protected boolean isAppendInProgress() {
        return this.fAppending;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Console.wrap")) {
            this.fWrap = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("Console.wrap");
        } else if (event.getProperty().equals("Console.width")) {
            this.fMaxLineLength = DebugUIPlugin.getDefault().getPreferenceStore().getInt("Console.width");
        }
    }

    protected String[] getLegalLineDelimiters() {
        if (this.fSortedLineDelimiters == null) {
            String[] lineDelimiters = this.fDocument.getLegalLineDelimiters();
            ArrayList<String> list = new ArrayList<String>(lineDelimiters.length);
            int i = 0;
            while (i < lineDelimiters.length) {
                list.add(lineDelimiters[i]);
                ++i;
            }
            Comparator comparator = new Comparator(){

                public int compare(Object a, Object b) {
                    String s1 = (String)a;
                    String s2 = (String)b;
                    return s2.length() - s1.length();
                }
            };
            Collections.sort(list, comparator);
            this.fSortedLineDelimiters = list.toArray(new String[lineDelimiters.length]);
        }
        return this.fSortedLineDelimiters;
    }

    public void connect(IStreamMonitor streamMonitor, String streamIdentifer) {
        if (streamMonitor != null) {
            StreamListener listener = new StreamListener(streamIdentifer, streamMonitor);
            this.fStreamListeners.add(listener);
            listener.connect();
            this.startReading();
        }
    }

    public void connect(IStreamsProxy streamsProxy) {
        this.fProxy = streamsProxy;
        this.connect(streamsProxy.getOutputStreamMonitor(), IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM);
        this.connect(streamsProxy.getErrorStreamMonitor(), IDebugUIConstants.ID_STANDARD_ERROR_STREAM);
    }

    protected boolean isTerminated() {
        return this.fProcess.isTerminated();
    }

    protected IConsoleColorProvider getContentProvider() {
        return this.fContentProvider;
    }

    public void addLink(IConsoleHyperlink link, int offset, int length) {
        HyperlinkPosition hyperlinkPosition = new HyperlinkPosition(link, offset, length);
        try {
            this.fDocument.addPosition(HyperlinkPosition.HYPER_LINK_CATEGORY, (Position)hyperlinkPosition);
        }
        catch (BadPositionCategoryException e) {
            DebugUIPlugin.log(e);
        }
        catch (BadLocationException badLocationException) {
            this.fPendingLinks.add(hyperlinkPosition);
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public void connectLineNotifier(ConsoleLineNotifier lineNotifier) {
        this.fLineNotifier = lineNotifier;
        lineNotifier.connect(this);
    }

    public IRegion getRegion(IConsoleHyperlink link) {
        try {
            Position[] positions = this.getDocument().getPositions(HyperlinkPosition.HYPER_LINK_CATEGORY);
            int i = 0;
            while (i < positions.length) {
                HyperlinkPosition position = (HyperlinkPosition)positions[i];
                if (position.getHyperLink().equals(link)) {
                    return new Region(position.getOffset(), position.getLength());
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    class StreamEntry {
        private String fStreamIdentifier;
        private String fText = null;

        StreamEntry(String text, String streamIdentifier) {
            this.fText = text;
            this.fStreamIdentifier = streamIdentifier;
        }

        public String getStreamIdentifier() {
            return this.fStreamIdentifier;
        }

        public String getText() {
            return this.fText;
        }
    }

    class StreamListener
    implements IStreamListener {
        private String fStreamIdentifier;
        private IStreamMonitor fStreamMonitor;
        private boolean fIsSystemOut = false;
        private boolean fIsSystemErr = false;

        public StreamListener(String streamIdentifier, IStreamMonitor streamMonitor) {
            this.fStreamIdentifier = streamIdentifier;
            this.fStreamMonitor = streamMonitor;
            this.fIsSystemOut = IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM.equals(streamIdentifier);
            this.fIsSystemErr = IDebugUIConstants.ID_STANDARD_ERROR_STREAM.equals(streamIdentifier);
        }

        public void streamAppended(String newText, IStreamMonitor monitor) {
            if (this.fIsSystemOut) {
                DebugUIPlugin.getDefault().getConsoleDocumentManager().aboutToWriteSystemOut(ConsoleDocumentPartitioner.this.fDocument);
            } else if (this.fIsSystemErr) {
                DebugUIPlugin.getDefault().getConsoleDocumentManager().aboutToWriteSystemErr(ConsoleDocumentPartitioner.this.fDocument);
            }
            ConsoleDocumentPartitioner.this.streamAppended(newText, this.fStreamIdentifier);
        }

        public void connect() {
            this.fStreamMonitor.addListener((IStreamListener)this);
            String contents = this.fStreamMonitor.getContents();
            if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                IFlushableStreamMonitor flushableStreamMonitor = (IFlushableStreamMonitor)this.fStreamMonitor;
                flushableStreamMonitor.flushContents();
                flushableStreamMonitor.setBuffered(false);
            }
            if (contents.length() > 0) {
                this.streamAppended(contents, this.fStreamMonitor);
            }
        }

        public void disconnect() {
            this.fStreamMonitor.removeListener((IStreamListener)this);
        }
    }
}

