/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentProvider;
import org.eclipse.debug.internal.ui.views.console.ConsoleLineNotifier;
import org.eclipse.debug.internal.ui.views.console.ConsoleView;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ConsoleDocumentManager
implements ILaunchListener {
    private IProcess fCurrentProcess = null;
    private Map fColorProviders;
    private Map fLineTrackers;
    protected IDocumentProvider fDefaultDocumentProvider = null;

    public void launchRemoved(ILaunch launch) {
        this.removeLaunch(launch);
        DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                ConsoleDocumentManager.this.notifyConsoleViews();
            }
        });
    }

    protected void removeLaunch(ILaunch launch) {
        IProcess currentProcess = this.getCurrentProcess();
        IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            IProcess iProcess = processes[i];
            IDocumentProvider provider = this.getDocumentProvider(iProcess);
            provider.disconnect((Object)iProcess);
            if (iProcess.equals(currentProcess)) {
                this.setCurrentProcess(null);
                ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                if (launches.length > 0) {
                    ILaunch prev = launches[launches.length - 1];
                    this.setCurrentProcess(this.getOutputProcess(prev));
                }
            }
            ++i;
        }
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(final ILaunch launch) {
        if (launch.getProcesses().length > 0) {
            this.setCurrentProcess(this.getOutputProcess(launch));
            DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    IProcess[] processes = launch.getProcesses();
                    int i = 0;
                    while (i < processes.length) {
                        if (ConsoleDocumentManager.this.getConsoleDocument(processes[i]) == null) {
                            IProcess process = processes[i];
                            IDocumentProvider provider = ConsoleDocumentManager.this.getDocumentProvider(process);
                            try {
                                provider.connect((Object)process);
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                    ConsoleDocumentManager.this.notifyConsoleViews();
                }
            });
        }
    }

    private IProcess getOutputProcess(ILaunch launch) {
        IProcess process = null;
        IDebugTarget target = launch.getDebugTarget();
        if (target != null) {
            process = target.getProcess();
        } else {
            IProcess[] processes = launch.getProcesses();
            if (processes.length > 0) {
                process = processes[processes.length - 1];
            }
        }
        return process;
    }

    private void notifyConsoleViews() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow iWorkbenchWindow = windows[i];
            IWorkbenchPage[] pages = iWorkbenchWindow.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage iWorkbenchPage = pages[j];
                IViewPart part = iWorkbenchPage.findView("org.eclipse.debug.ui.ConsoleView");
                if (part instanceof ConsoleView) {
                    ConsoleView view = (ConsoleView)part;
                    view.setViewerInputFromConsoleDocumentManager(this.getCurrentProcess());
                }
                ++j;
            }
            ++i;
        }
    }

    protected IProcess getCurrentProcess() {
        return this.fCurrentProcess;
    }

    protected void setCurrentProcess(IProcess currentProcess) {
        this.fCurrentProcess = currentProcess;
    }

    public IDocument getConsoleDocument(IProcess process) {
        IDocumentProvider provider = this.getDocumentProvider(process);
        return provider.getDocument((Object)process);
    }

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            this.launchAdded(launches[i]);
            ++i;
        }
    }

    public void shutdown() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            this.removeLaunch(launch);
            ++i;
        }
        launchManager.removeLaunchListener((ILaunchListener)this);
    }

    protected void aboutToWriteSystemErr(IDocument doc) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnErr")) {
            this.showConsole(doc);
        }
    }

    protected void aboutToWriteSystemOut(IDocument doc) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnOut")) {
            this.showConsole(doc);
        }
    }

    protected IProcess getDebugViewProcess() {
        ISelection selection;
        IProcess debugViewProcess = null;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection("org.eclipse.debug.ui.DebugView")) instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IProcess) {
                debugViewProcess = (IProcess)element;
            } else if (element instanceof ILaunch) {
                IDebugTarget target = ((ILaunch)element).getDebugTarget();
                if (target != null) {
                    debugViewProcess = target.getProcess();
                } else {
                    IProcess[] processes = ((ILaunch)element).getProcesses();
                    if (processes != null && processes.length > 0) {
                        debugViewProcess = processes[0];
                    }
                }
            } else if (element instanceof IDebugElement) {
                debugViewProcess = ((IDebugElement)element).getDebugTarget().getProcess();
            }
        }
        return debugViewProcess;
    }

    protected void showConsole(IDocument doc) {
        IProcess debugViewProcess = this.getDebugViewProcess();
        if (doc != null && debugViewProcess != null && !doc.equals(this.getConsoleDocument(debugViewProcess))) {
            return;
        }
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    try {
                        IViewPart consoleView = page.findView("org.eclipse.debug.ui.ConsoleView");
                        if (consoleView == null) {
                            IWorkbenchPart activePart = page.getActivePart();
                            page.showView("org.eclipse.debug.ui.ConsoleView");
                            page.activate(activePart);
                        } else {
                            page.bringToTop((IWorkbenchPart)consoleView);
                        }
                    }
                    catch (PartInitException pie) {
                        DebugUIPlugin.log(pie);
                    }
                }
            }
        });
    }

    protected IDocumentProvider getDocumentProvider(IProcess process) {
        if (this.fDefaultDocumentProvider == null) {
            this.fDefaultDocumentProvider = new ConsoleDocumentProvider();
        }
        return this.fDefaultDocumentProvider;
    }

    public IConsoleColorProvider getColorProvider(String type) {
        IConfigurationElement extension;
        if (this.fColorProviders == null) {
            this.fColorProviders = new HashMap();
            IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
            IExtensionPoint extensionPoint = descriptor.getExtensionPoint("consoleColorProviders");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension2 = elements[i];
                this.fColorProviders.put(extension2.getAttributeAsIs("processType"), extension2);
                ++i;
            }
        }
        if ((extension = (IConfigurationElement)this.fColorProviders.get(type)) != null) {
            try {
                Object contentProvider = extension.createExecutableExtension("class");
                if (contentProvider instanceof IConsoleColorProvider) {
                    return (IConsoleColorProvider)contentProvider;
                }
                DebugUIPlugin.logErrorMessage(MessageFormat.format(DebugUIViewsMessages.getString("ConsoleDocumentManager.Invalid_extension_{0}_-_class_must_be_an_instance_of_IConsoleDocumentContentProvider._1"), extension.getDeclaringExtension().getUniqueIdentifier()));
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public ConsoleLineNotifier newLineNotifier(String type) {
        if (this.fLineTrackers == null) {
            this.fLineTrackers = new HashMap();
            IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
            IExtensionPoint extensionPoint = descriptor.getExtensionPoint("consoleLineTrackers");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension = elements[i];
                String processType = extension.getAttributeAsIs("processType");
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)this.fLineTrackers.get(processType);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    this.fLineTrackers.put(processType, list);
                }
                list.add(extension);
                ++i;
            }
        }
        List extensions = (List)this.fLineTrackers.get(type);
        ConsoleLineNotifier lineNotifier = null;
        if (extensions != null) {
            lineNotifier = new ConsoleLineNotifier();
            Iterator iter = extensions.iterator();
            while (iter.hasNext()) {
                IConfigurationElement extension = (IConfigurationElement)iter.next();
                try {
                    Object tracker = extension.createExecutableExtension("class");
                    if (tracker instanceof IConsoleLineTracker) {
                        lineNotifier.addConsoleListener((IConsoleLineTracker)tracker);
                        continue;
                    }
                    DebugUIPlugin.logErrorMessage(MessageFormat.format(DebugUIViewsMessages.getString("ConsoleDocumentManager.Invalid_extension"), extension.getDeclaringExtension().getUniqueIdentifier()));
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return lineNotifier;
    }
}

