/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.viewers.TableViewer;

public class BreakpointsViewEventHandler
implements IBreakpointsListener {
    private BreakpointsView fView;

    public BreakpointsViewEventHandler(BreakpointsView view) {
        this.fView = view;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
    }

    public void breakpointsAdded(final IBreakpoint[] breakpoints) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        ((TableViewer)BreakpointsViewEventHandler.this.fView.getViewer()).add((Object[])breakpoints);
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsRemoved(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        TableViewer viewer = (TableViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        int[] indices = viewer.getTable().getSelectionIndices();
                        viewer.getControl().setRedraw(false);
                        viewer.remove((Object[])breakpoints);
                        viewer.getControl().setRedraw(true);
                        if (viewer.getSelection().isEmpty()) {
                            if (indices.length > 0) {
                                int index = indices[0];
                                viewer.getTable().select(Math.min(index, viewer.getTable().getItemCount() - 1));
                            }
                            viewer.setSelection(viewer.getSelection());
                        }
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsChanged(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() & this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        BreakpointsViewEventHandler.this.fView.getViewer().getControl().setRedraw(false);
                        int i = 0;
                        while (i < breakpoints.length) {
                            ((TableViewer)BreakpointsViewEventHandler.this.fView.getViewer()).refresh((Object)breakpoints[i]);
                            ++i;
                        }
                        BreakpointsViewEventHandler.this.fView.getViewer().getControl().setRedraw(true);
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }
}

