/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.OpenBreakpointMarkerAction;
import org.eclipse.debug.internal.ui.actions.ShowSupportedBreakpointsAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsSorter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewEventHandler;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public class BreakpointsView
extends AbstractDebugView {
    private BreakpointsViewEventHandler fEventHandler;

    protected Viewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 770);
        viewer.setContentProvider((IContentProvider)new BreakpointsViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingModelPresentation());
        viewer.setSorter((ViewerSorter)new BreakpointsSorter());
        viewer.setInput((Object)DebugPlugin.getDefault().getBreakpointManager());
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.setEventHandler(new BreakpointsViewEventHandler(this));
        return viewer;
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.BREAKPOINT_VIEW;
    }

    public void dispose() {
        IAction action = this.getAction("ShowBreakpointsForModel");
        if (action != null) {
            ((ShowSupportedBreakpointsAction)action).dispose();
        }
        super.dispose();
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
    }

    protected void createActions() {
        OpenBreakpointMarkerAction action = new OpenBreakpointMarkerAction((ISelectionProvider)this.getViewer());
        this.setAction("GotoMarker", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        this.setAction("ShowBreakpointsForModel", (IAction)new ShowSupportedBreakpointsAction(this.getStructuredViewer(), this));
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.updateObjects();
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("navigationGroup"));
        menu.add(this.getAction("GotoMarker"));
        menu.add((IContributionItem)new Separator("emptyBreakpointGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroup"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("breakpointGroup"));
        tbm.add(this.getAction("ShowBreakpointsForModel"));
        tbm.add(this.getAction("GotoMarker"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    protected BreakpointsViewEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    private void setEventHandler(BreakpointsViewEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
    }
}

