/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.LaunchHistoryPreferencePage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class LaunchHistoryPreferenceTab {
    private TableViewer fFavoritesTable;
    private TableViewer fRecentTable;
    private Button fAddFavoriteButton;
    private Button fRemoveFavoritesButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private Button fMakeRecentButton;
    private Button fMakeFavoritesButton;
    private Button fRemoveRecentButton;
    private List fFavorites;
    private List fRecents;
    private LaunchHistory fLaunchHistory;
    private Image fImage;
    private LaunchHistoryPreferencePage fPreferencePage;
    private SelectionAdapter fButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == LaunchHistoryPreferenceTab.this.fAddFavoriteButton) {
                LaunchHistoryPreferenceTab.this.handleAddConfigButtonSelected();
            } else if (button == LaunchHistoryPreferenceTab.this.fRemoveFavoritesButton) {
                LaunchHistoryPreferenceTab.this.removeSelectedFavorites();
            } else if (button == LaunchHistoryPreferenceTab.this.fMoveUpButton) {
                LaunchHistoryPreferenceTab.this.handleMoveUpButtonSelected();
            } else if (button == LaunchHistoryPreferenceTab.this.fMoveDownButton) {
                LaunchHistoryPreferenceTab.this.handleMoveDownButtonSelected();
            } else if (button == LaunchHistoryPreferenceTab.this.fMakeRecentButton) {
                LaunchHistoryPreferenceTab.this.handleMakeRecentButtonSelected();
            } else if (button == LaunchHistoryPreferenceTab.this.fMakeFavoritesButton) {
                LaunchHistoryPreferenceTab.this.handleMakeFavoriteButtonSelected();
            } else if (button == LaunchHistoryPreferenceTab.this.fRemoveRecentButton) {
                LaunchHistoryPreferenceTab.this.removeSelectedRecent();
            }
        }
    };
    private ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TableViewer table = (TableViewer)event.getSource();
            if (table == LaunchHistoryPreferenceTab.this.getRecentTable()) {
                LaunchHistoryPreferenceTab.this.handleRecentSelectionChanged();
            } else if (table == LaunchHistoryPreferenceTab.this.getFavoritesTable()) {
                LaunchHistoryPreferenceTab.this.handleFavoriteSelectionChanged();
            }
        }
    };
    private KeyListener fKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.character == '\u007f' && event.stateMask == 0) {
                if (event.widget == LaunchHistoryPreferenceTab.this.getRecentTable().getTable()) {
                    LaunchHistoryPreferenceTab.this.removeSelectedRecent();
                } else if (event.widget == LaunchHistoryPreferenceTab.this.getFavoritesTable().getTable()) {
                    LaunchHistoryPreferenceTab.this.removeSelectedFavorites();
                }
            }
        }
    };

    public LaunchHistoryPreferenceTab(LaunchHistory history, LaunchHistoryPreferencePage page) {
        this.fLaunchHistory = history;
        this.fPreferencePage = page;
    }

    protected LaunchHistory getLaunchHistory() {
        return this.fLaunchHistory;
    }

    protected Control createControl(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        topComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        this.createLabel(topComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Fa&vorites__1"));
        this.fFavoritesTable = this.createTable(topComp, (IContentProvider)new FavoritesContentProvider());
        Composite buttonComp = this.createButtonComposite(topComp);
        this.fAddFavoriteButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Add_&Config_1"));
        this.fAddFavoriteButton.setEnabled(true);
        this.fRemoveFavoritesButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Re&move_2"));
        this.fMoveUpButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.U&p_3"));
        this.fMoveDownButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Do&wn_4"));
        this.fMakeRecentButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Ma&ke_Recent_2"));
        this.createSpacer(topComp, 1);
        this.createLabel(topComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.&Launch_History__3"));
        this.fRecentTable = this.createTable(topComp, (IContentProvider)new RecentContentProvider());
        buttonComp = this.createButtonComposite(topComp);
        this.fMakeFavoritesButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Make_&Favorite_5"));
        this.fRemoveRecentButton = this.createPushButton(buttonComp, DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Remo&ve_6"));
        return topComp;
    }

    private Composite createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(2);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private Label createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        return label;
    }

    private TableViewer createTable(Composite parent, IContentProvider contentProvider) {
        TableViewer tableViewer = new TableViewer(parent, 67586);
        tableViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        tableViewer.setContentProvider(contentProvider);
        tableViewer.setInput((Object)DebugUIPlugin.getDefault());
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 100;
        tableViewer.getTable().setLayoutData((Object)gd);
        tableViewer.getTable().setFont(parent.getFont());
        tableViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        tableViewer.getControl().addKeyListener(this.fKeyListener);
        return tableViewer;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(parent.getFont());
        this.fPreferencePage.setButtonLayoutData(button);
        button.addSelectionListener((SelectionListener)this.fButtonListener);
        button.setEnabled(false);
        return button;
    }

    public void init(IWorkbench workbench) {
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected TableViewer getFavoritesTable() {
        return this.fFavoritesTable;
    }

    protected void handleFavoriteSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.getFavoritesTable().getSelection();
        List favs = this.getFavorites();
        boolean notEmpty = !selection.isEmpty();
        Iterator elements = selection.iterator();
        boolean first = false;
        boolean last = false;
        int lastFav = favs.size() - 1;
        while (elements.hasNext()) {
            Object element = elements.next();
            if (!first && favs.indexOf(element) == 0) {
                first = true;
            }
            if (last || favs.indexOf(element) != lastFav) continue;
            last = true;
        }
        this.fRemoveFavoritesButton.setEnabled(notEmpty);
        this.fMakeRecentButton.setEnabled(notEmpty);
        this.fMoveUpButton.setEnabled(notEmpty && !first);
        this.fMoveDownButton.setEnabled(notEmpty && !last);
    }

    protected TableViewer getRecentTable() {
        return this.fRecentTable;
    }

    protected void handleRecentSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.getRecentTable().getSelection();
        boolean notEmpty = !selection.isEmpty();
        this.fRemoveRecentButton.setEnabled(notEmpty);
        this.fMakeFavoritesButton.setEnabled(notEmpty);
    }

    protected void handleAddConfigButtonSelected() {
        ListSelectionDialog dialog = new ListSelectionDialog(this.fFavoritesTable.getControl().getShell(), (Object)this.getMode(), (IStructuredContentProvider)new LaunchConfigurationContentProvider(), (ILabelProvider)DebugUITools.newDebugModelPresentation(), DebugPreferencesMessages.getString("LaunchHistoryPreferenceTab.Select_Launch_Configurations_7"));
        dialog.open();
        Object[] selection = dialog.getResult();
        if (selection != null) {
            int i = 0;
            while (i < selection.length) {
                this.getFavorites().add(selection[i]);
                this.getRecents().remove(selection[i]);
                ++i;
            }
            this.updateStatus();
        }
    }

    protected void removeSelectedFavorites() {
        IStructuredSelection sel = (IStructuredSelection)this.getFavoritesTable().getSelection();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            Object config = iter.next();
            this.getFavorites().remove(config);
        }
        this.getFavoritesTable().refresh();
    }

    protected void handleMoveUpButtonSelected() {
        this.handleMove(-1);
    }

    protected void handleMoveDownButtonSelected() {
        this.handleMove(1);
    }

    protected void handleMove(int direction) {
        Object config;
        IStructuredSelection sel = (IStructuredSelection)this.getFavoritesTable().getSelection();
        List selList = sel.toList();
        Object[] movedFavs = new Object[this.getFavorites().size()];
        Iterator favs = selList.iterator();
        while (favs.hasNext()) {
            config = favs.next();
            int i = this.getFavorites().indexOf(config);
            movedFavs[i + direction] = config;
        }
        this.getFavorites().removeAll(selList);
        int j = 0;
        while (j < movedFavs.length) {
            config = movedFavs[j];
            if (config != null) {
                this.getFavorites().add(j, config);
            }
            ++j;
        }
        this.getFavoritesTable().refresh();
        this.handleFavoriteSelectionChanged();
    }

    protected void removeSelectedRecent() {
        IStructuredSelection sel = (IStructuredSelection)this.getRecentTable().getSelection();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            Object config = iter.next();
            this.getRecents().remove(config);
        }
        this.getRecentTable().refresh();
    }

    protected void handleMakeFavoriteButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.getRecentTable().getSelection();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            Object config = iter.next();
            this.getFavorites().add(config);
            this.getRecents().remove(config);
        }
        this.updateStatus();
    }

    protected void handleMakeRecentButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.getFavoritesTable().getSelection();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            Object config = iter.next();
            this.getRecents().add(config);
            this.getFavorites().remove(config);
        }
        this.updateStatus();
    }

    protected String getMode() {
        return this.getLaunchHistory().getLaunchGroup().getMode();
    }

    protected ILaunchConfiguration[] getInitialFavorites() {
        return this.getLaunchHistory().getFavorites();
    }

    protected ILaunchConfiguration[] getInitialRecents() {
        return this.getLaunchHistory().getHistory();
    }

    protected List getFavorites() {
        if (this.fFavorites == null) {
            Object[] favs = this.getInitialFavorites();
            this.fFavorites = new ArrayList(favs.length);
            this.addAll(favs, this.fFavorites);
        }
        return this.fFavorites;
    }

    protected List getRecents() {
        if (this.fRecents == null) {
            Object[] recent = this.getInitialRecents();
            this.fRecents = new ArrayList(recent.length);
            this.addAll(recent, this.fRecents);
        }
        return this.fRecents;
    }

    protected void addAll(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
    }

    protected void performDefaults() {
        this.fFavorites = null;
        this.fRecents = null;
        this.updateStatus();
    }

    protected void updateStatus() {
        this.getFavoritesTable().refresh();
        this.getRecentTable().refresh();
        this.handleFavoriteSelectionChanged();
        this.handleRecentSelectionChanged();
    }

    public void performOK() {
        ILaunchConfiguration configuration;
        ILaunchConfiguration[] initial = this.getInitialFavorites();
        List current = this.getFavorites();
        String groupId = this.getLaunchHistory().getLaunchGroup().getIdentifier();
        int i = 0;
        while (i < initial.length) {
            configuration = initial[i];
            if (!current.contains(configuration)) {
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                    workingCopy.setAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, null);
                    workingCopy.setAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, null);
                    List groups = workingCopy.getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, null);
                    if (groups != null) {
                        groups.remove(groupId);
                        if (groups.isEmpty()) {
                            groups = null;
                        }
                        workingCopy.setAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, groups);
                    }
                    workingCopy.doSave();
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            ++i;
        }
        Iterator favs = current.iterator();
        while (favs.hasNext()) {
            configuration = (ILaunchConfiguration)favs.next();
            try {
                ArrayList<String> groups = configuration.getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, null);
                if (groups == null) {
                    groups = new ArrayList<String>();
                }
                if (groups.contains(groupId)) continue;
                groups.add(groupId);
                ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                workingCopy.setAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, groups);
                workingCopy.doSave();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        this.fLaunchHistory.setFavorites(this.getArray(current));
        this.fLaunchHistory.setHistory(this.getArray(this.getRecents()));
    }

    protected ILaunchConfiguration[] getArray(List list) {
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }

    protected void setImage(Image image) {
        this.fImage = image;
    }

    protected void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }

    protected class FavoritesContentProvider
    implements IStructuredContentProvider {
        protected FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return LaunchHistoryPreferenceTab.this.getFavorites().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class RecentContentProvider
    extends FavoritesContentProvider {
        protected RecentContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return LaunchHistoryPreferenceTab.this.getRecents().toArray();
        }
    }

    protected class LaunchConfigurationContentProvider
    extends FavoritesContentProvider {
        protected LaunchConfigurationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchConfiguration[] all = null;
            try {
                all = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                return new ILaunchConfiguration[0];
            }
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>(all.length);
            LaunchGroupFilter filter = new LaunchGroupFilter(LaunchHistoryPreferenceTab.this.getLaunchHistory().getLaunchGroup());
            int i = 0;
            while (i < all.length) {
                if (filter.select(null, null, all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
            list.removeAll(LaunchHistoryPreferenceTab.this.getFavorites());
            Object[] objs = list.toArray();
            new WorkbenchViewerSorter().sort((Viewer)LaunchHistoryPreferenceTab.this.getFavoritesTable(), objs);
            return objs;
        }
    }
}

