/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.LaunchHistoryPreferenceTab;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class LaunchHistoryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor fHistoryMaxEditor;
    protected LaunchHistoryPreferenceTab[] fTabs;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fHistoryMaxEditor = new IntegerFieldEditor(IDebugUIConstants.PREF_MAX_HISTORY_SIZE, DebugPreferencesMessages.getString("LaunchHistoryPreferencePage.Maximum_launch_history_size_1"), composite);
        int historyMax = 20;
        this.fHistoryMaxEditor.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
        this.fHistoryMaxEditor.setPreferencePage((PreferencePage)this);
        this.fHistoryMaxEditor.setTextLimit(Integer.toString(historyMax).length());
        this.fHistoryMaxEditor.setErrorMessage(MessageFormat.format(DebugPreferencesMessages.getString("LaunchHistoryPreferencePage.The_size_of_the_launch_history_should_be_between_{0}_and_{1}_1"), new Integer(1), new Integer(historyMax)));
        this.fHistoryMaxEditor.setValidateStrategy(0);
        this.fHistoryMaxEditor.setValidRange(1, historyMax);
        this.fHistoryMaxEditor.load();
        this.fHistoryMaxEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    LaunchHistoryPreferencePage.this.setValid(LaunchHistoryPreferencePage.this.fHistoryMaxEditor.isValid());
                }
            }
        });
        this.fHistoryMaxEditor.fillIntoGrid(composite, 2);
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)gd);
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchGroupExtension[] groups = manager.getLaunchGroups();
        ArrayList<LaunchHistoryPreferenceTab> tabList = new ArrayList<LaunchHistoryPreferenceTab>();
        LaunchHistory history = manager.getLaunchHistory(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP);
        tabList.add(this.createTab(history, tabFolder));
        history = manager.getLaunchHistory(IDebugUIConstants.ID_RUN_LAUNCH_GROUP);
        tabList.add(this.createTab(history, tabFolder));
        int i = 0;
        while (i < groups.length) {
            LaunchGroupExtension extension = groups[i];
            String id = extension.getIdentifier();
            if (!id.equals(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP) && !id.equals(IDebugUIConstants.ID_RUN_LAUNCH_GROUP) && (history = manager.getLaunchHistory(id)) != null) {
                tabList.add(this.createTab(history, tabFolder));
            }
            ++i;
        }
        this.fTabs = tabList.toArray(new LaunchHistoryPreferenceTab[tabList.size()]);
        return composite;
    }

    protected LaunchHistoryPreferenceTab createTab(LaunchHistory history, TabFolder tabFolder) {
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(history.getLaunchGroup().getLabel());
        ImageDescriptor descriptor = history.getLaunchGroup().getImageDescriptor();
        Image image = null;
        if (descriptor != null) {
            image = descriptor.createImage();
            tab.setImage(image);
        }
        LaunchHistoryPreferenceTab prefTab = new LaunchHistoryPreferenceTab(history, this);
        prefTab.setImage(image);
        tab.setControl(prefTab.createControl((Composite)tabFolder));
        return prefTab;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DebugPreferencesMessages.getString("LaunchHistoryPreferencePage.description"));
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.fTabs.length) {
            LaunchHistoryPreferenceTab tab = this.fTabs[i];
            tab.performOK();
            ++i;
        }
        if (this.fHistoryMaxEditor.getIntValue() != this.fHistoryMaxEditor.getPreferenceStore().getInt(IDebugUIConstants.PREF_MAX_HISTORY_SIZE)) {
            this.fHistoryMaxEditor.store();
            LaunchHistory.launchHistoryChanged();
        }
        DebugUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        int i = 0;
        while (i < this.fTabs.length) {
            LaunchHistoryPreferenceTab tab = this.fTabs[i];
            tab.performDefaults();
            ++i;
        }
        this.fHistoryMaxEditor.loadDefault();
        super.performDefaults();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.LAUNCH_HISTORY_PREFERENCE_PAGE);
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.fTabs.length) {
            LaunchHistoryPreferenceTab tab = this.fTabs[i];
            tab.dispose();
            ++i;
        }
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

