/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.preferences.ComboFieldEditor;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class DebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IDebugPreferenceConstants {
    private RadioGroupFieldEditor fSaveRadioFieldEditor;
    private static final String PERSPECTIVE_NONE_NAME = LaunchConfigurationsMessages.getString("CommonTab.None");

    public DebugPreferencePage() {
        super(1);
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(DebugPreferencesMessages.getString("DebugPreferencePage.General_Settings_for_Debugging_1"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.DEBUG_PREFERENCE_PAGE);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH, DebugPreferencesMessages.getString("DebugPreferencePage.auto_build_before_launch"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, DebugPreferencesMessages.getString("DebugPreferencePage.Remove_terminated_launches_when_a_new_launch_is_created_1"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_REUSE_EDITOR, DebugPreferencesMessages.getString("DebugPreferencePage.Reuse_editor_when_displa&ying_source_code_1"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH, DebugPreferencesMessages.getString("DebugPreferencePage.Activate_the_&workbench_when_a_breakpoint_is_hit_1"), 0, this.getFieldEditorParent()));
        this.createSpacer(this.getFieldEditorParent(), 1);
        this.createSaveBeforeLaunchEditors(this.getFieldEditorParent());
        this.createSpacer(this.getFieldEditorParent(), 1);
        String[][] perspectiveNamesAndIds = DebugPreferencePage.getPerspectiveNamesAndIds();
        this.addField(new ComboFieldEditor(IDebugUIConstants.PREF_SHOW_DEBUG_PERSPECTIVE_DEFAULT, DebugPreferencesMessages.getString("DebugPreferencePage.Default_perspective_for_Debug_2"), perspectiveNamesAndIds, this.getFieldEditorParent()));
        this.addField(new ComboFieldEditor(IDebugUIConstants.PREF_SHOW_RUN_PERSPECTIVE_DEFAULT, DebugPreferencesMessages.getString("DebugPreferencePage.Default_perspective_for_Run_3"), perspectiveNamesAndIds, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private void createSaveBeforeLaunchEditors(Composite parent) {
        this.fSaveRadioFieldEditor = new RadioGroupFieldEditor(IDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH_RADIO, DebugPreferencesMessages.getString("DebugPreferencePage.Save_dirty_editors_before_launching_4"), 1, (String[][])new String[][]{{DebugPreferencesMessages.getString("DebugPreferencePage.&Never_5"), IDebugUIConstants.PREF_NEVER_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH}, {DebugPreferencesMessages.getString("DebugPreferencePage.&Prompt_6"), IDebugUIConstants.PREF_PROMPT_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH}, {DebugPreferencesMessages.getString("DebugPreferencePage.Auto-sav&e_7"), IDebugUIConstants.PREF_AUTOSAVE_DIRTY_EDITORS_BEFORE_LAUNCH}}, parent, true);
        this.addField((FieldEditor)this.fSaveRadioFieldEditor);
    }

    protected static String[][] getPerspectiveNamesAndIds() {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] persps = reg.getPerspectives();
        String[][] table = new String[persps.length + 1][2];
        table[0][0] = PERSPECTIVE_NONE_NAME;
        table[0][1] = "perspective_none";
        int i = 0;
        while (i < persps.length) {
            table[i + 1][0] = persps[i].getLabel();
            table[i + 1][1] = persps[i].getId();
            ++i;
        }
        return table;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        DebugUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }
}

