/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

public class PerspectiveManager
implements ILaunchListener,
IDebugEventSetListener {
    public void startup() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        plugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    public void shutdown() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            String name = DebugUIPlugin.getModelPresentation().getText(launch);
            this.switchFailed(e, name);
        }
        if (perspectiveId != null) {
            this.switchToPerspective(perspectiveId);
        }
    }

    protected void switchToPerspective(final String id) {
        this.async(new Runnable(){

            public void run() {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    try {
                        window.getWorkbench().showPerspective(id, window);
                    }
                    catch (WorkbenchException e) {
                        DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.getString("PerspectiveManager.Error_1"), MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectiveManager.Unable_to_switch_to_perspective__{0}_2"), id), e);
                    }
                }
            }
        });
    }

    protected void async(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.asyncExec(r);
        }
    }

    protected void sync(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.syncExec(r);
        }
    }

    protected void switchFailed(final Throwable t, final String launchName) {
        this.sync(new Runnable(){

            public void run() {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.getString("PerspectiveManager.Error_1"), MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectiveManager.Unable_to_switch_perpsectives_as_specified_by_launch__{0}_4"), launchName), t);
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 2 && (event.getDetail() == 16 || event.getDetail() == 8)) {
                ILaunch launch = null;
                Object source = event.getSource();
                if (source instanceof IDebugElement) {
                    launch = ((IDebugElement)source).getLaunch();
                } else if (source instanceof IProcess) {
                    launch = ((IProcess)source).getLaunch();
                }
                String perspectiveId = null;
                try {
                    perspectiveId = this.getPerspectiveId(launch);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                final String id = perspectiveId;
                Runnable r = new Runnable(){

                    public void run() {
                        IViewPart part;
                        IWorkbenchPage page;
                        String targetId = id;
                        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                        if (window == null) {
                            return;
                        }
                        if (targetId == null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.debug.ui.DebugView")) == null) {
                            targetId = IDebugUIConstants.ID_DEBUG_PERSPECTIVE;
                        }
                        if (targetId != null) {
                            Shell shell = window.getShell();
                            if (shell != null) {
                                if (shell.getMinimized()) {
                                    shell.setMinimized(false);
                                }
                                if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH)) {
                                    shell.forceActive();
                                }
                            }
                            PerspectiveManager.this.switchToPerspective(targetId);
                        }
                    }
                };
                this.async(r);
            }
            ++i;
        }
    }

    protected String getPerspectiveId(ILaunch launch) throws CoreException {
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return null;
        }
        String perspectiveId = null;
        String mode = launch.getLaunchMode();
        if (mode.equals("debug")) {
            perspectiveId = config.getAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE, null);
            if (perspectiveId != null && perspectiveId.equals("perspective_default")) {
                perspectiveId = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_SHOW_DEBUG_PERSPECTIVE_DEFAULT);
            }
        } else {
            perspectiveId = config.getAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, null);
            if (perspectiveId != null && perspectiveId.equals("perspective_default")) {
                perspectiveId = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_SHOW_RUN_PERSPECTIVE_DEFAULT);
            }
        }
        if (perspectiveId != null && perspectiveId.equals("perspective_none")) {
            perspectiveId = null;
        }
        return perspectiveId;
    }
}

