/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class LaunchShortcutExtension
implements ILaunchShortcut {
    private ImageDescriptor fImageDescriptor = null;
    private List fPerspectives = null;
    private ILaunchShortcut fDelegate = null;
    private Set fModes = null;
    private IConfigurationElement fConfig;

    public LaunchShortcutExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    public String getLabel() {
        return this.getConfigurationElement().getAttribute("label");
    }

    public String getId() {
        return this.getConfigurationElement().getAttribute("id");
    }

    protected String getIconPath() {
        return this.getConfigurationElement().getAttribute("icon");
    }

    public String getHelpContextId() {
        return this.getConfigurationElement().getAttribute("helpContextId");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor == null) {
            URL iconURL = this.getConfigurationElement().getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
            String iconPath = this.getIconPath();
            try {
                iconURL = new URL(iconURL, iconPath);
                this.fImageDescriptor = ImageDescriptor.createFromURL((URL)iconURL);
            }
            catch (MalformedURLException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.fImageDescriptor;
    }

    public List getPerspectives() {
        if (this.fPerspectives == null) {
            IConfigurationElement[] perspectives = this.getConfigurationElement().getChildren("perspective");
            this.fPerspectives = new ArrayList(perspectives.length);
            int i = 0;
            while (i < perspectives.length) {
                this.fPerspectives.add(perspectives[i].getAttribute("id"));
                ++i;
            }
        }
        return this.fPerspectives;
    }

    protected ILaunchShortcut getDelegate() {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (ILaunchShortcut)this.fConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.getString("LaunchShortcutExtension.Error_4"), LaunchConfigurationsMessages.getString("LaunchShortcutExtension.Unable_to_use_launch_shortcut_5"), e.getStatus());
            }
        }
        return this.fDelegate;
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchShortcut shortcut = this.getDelegate();
        if (shortcut != null) {
            shortcut.launch(editor, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        ILaunchShortcut shortcut = this.getDelegate();
        if (shortcut != null) {
            shortcut.launch(selection, mode);
        }
    }

    public Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }
}

