/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;

public class LaunchConfigurationPresentationManager {
    private static LaunchConfigurationPresentationManager fgDefault;
    private Hashtable fTabGroupExtensions;

    private LaunchConfigurationPresentationManager() {
        fgDefault = this;
        this.initializeTabGroupExtensions();
    }

    public static LaunchConfigurationPresentationManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new LaunchConfigurationPresentationManager();
        }
        return fgDefault;
    }

    private void initializeTabGroupExtensions() {
        this.fTabGroupExtensions = new Hashtable();
        IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("launchConfigurationTabGroups");
        IConfigurationElement[] groups = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < groups.length) {
            LaunchConfigurationTabGroupExtension group = new LaunchConfigurationTabGroupExtension(groups[i]);
            String typeId = group.getTypeIdentifier();
            if (typeId == null) {
                IExtension ext = groups[i].getDeclaringExtension();
                Status status = new Status(4, IDebugUIConstants.PLUGIN_ID, 100, MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationPresentationManager.Launch_configuration_tab_group_extension_{0}_does_not_specify_launch_configuration_type_1"), ext.getUniqueIdentifier()), null);
                DebugUIPlugin.log((IStatus)status);
            } else {
                ILaunchConfigurationType lct = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId);
                if (lct == null) {
                    IExtension ext = groups[i].getDeclaringExtension();
                    Status status = new Status(4, IDebugUIConstants.PLUGIN_ID, 100, MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationPresentationManager.Launch_configuration_tab_group_extension_{0}_refers_to_non-existant_launch_configuration_type_{1}_2"), ext.getUniqueIdentifier(), typeId), null);
                    DebugUIPlugin.log((IStatus)status);
                }
            }
            if (typeId != null) {
                this.fTabGroupExtensions.put(typeId, group);
            }
            ++i;
        }
    }

    public ILaunchConfigurationTabGroup getTabGroup(ILaunchConfigurationType type) throws CoreException {
        LaunchConfigurationTabGroupExtension ext = (LaunchConfigurationTabGroupExtension)this.fTabGroupExtensions.get(type.getIdentifier());
        if (ext == null) {
            Status status = new Status(4, IDebugUIConstants.PLUGIN_ID, 120, MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationPresentationManager.No_tab_group_defined_for_launch_configuration_type_{0}_3"), type.getIdentifier()), null);
            throw new CoreException((IStatus)status);
        }
        return ext.newTabGroup();
    }

    public String getHelpContext(ILaunchConfigurationType type) throws CoreException {
        LaunchConfigurationTabGroupExtension ext = (LaunchConfigurationTabGroupExtension)this.fTabGroupExtensions.get(type.getIdentifier());
        if (ext == null) {
            Status status = new Status(4, IDebugUIConstants.PLUGIN_ID, 120, MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationPresentationManager.No_tab_group_defined_for_launch_configuration_type_{0}_3"), type.getIdentifier()), null);
            throw new CoreException((IStatus)status);
        }
        return ext.getHelpContextId();
    }
}

