/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabImageDescriptor;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.ShortcutComparator;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LaunchConfigurationManager
implements ILaunchListener {
    protected Map fLaunchGroups;
    protected Map fLaunchHistories;
    protected List fLaunchHistoryChangedListeners = new ArrayList(3);
    private List fLaunchShortcuts = null;
    private Map fLaunchShortcutsByPerspective = null;
    protected ImageRegistry fErrorImages = null;
    protected boolean fRestoring = false;
    private static final String LAUNCH_CONFIGURATION_HISTORY_FILENAME = "launchConfigurationHistory.xml";
    private static final String HISTORY_ROOT_NODE = "launchHistory";
    private static final String HISTORY_LAUNCH_NODE = "launch";
    private static final String HISTORY_LAST_LAUNCH_NODE = "lastLaunch";
    private static final String HISTORY_MEMENTO_ATT = "memento";
    private static final String HISTORY_MODE_ATT = "mode";

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            this.launchAdded(launches[i]);
            ++i;
        }
    }

    public static boolean isVisible(ILaunchConfiguration launchConfiguration) {
        try {
            return !launchConfiguration.getAttribute(IDebugUIConstants.ATTR_PRIVATE, false);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
            return false;
        }
    }

    public void shutdown() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener((ILaunchListener)this);
        if (this.fLaunchHistories != null) {
            Iterator histories = this.fLaunchHistories.values().iterator();
            while (histories.hasNext()) {
                LaunchHistory history = (LaunchHistory)histories.next();
                history.dispose();
            }
        }
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        this.removeTerminatedLaunches(launch);
    }

    protected void removeTerminatedLaunches(ILaunch newLaunch) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES)) {
            ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] launches = lManager.getLaunches();
            int i = 0;
            while (i < launches.length) {
                ILaunch launch = launches[i];
                if (launch != newLaunch && launch.isTerminated()) {
                    lManager.removeLaunch(launch);
                }
                ++i;
            }
        }
    }

    public ILaunchConfiguration getLastLaunch(String groupId) {
        LaunchHistory history = this.getLaunchHistory(groupId);
        if (history != null) {
            return history.getRecentLaunch();
        }
        return null;
    }

    public void addLaunchHistoryListener(ILaunchHistoryChangedListener listener) {
        if (!this.fLaunchHistoryChangedListeners.contains(listener)) {
            this.fLaunchHistoryChangedListeners.add(listener);
        }
    }

    public void removeLaunchHistoryListener(ILaunchHistoryChangedListener listener) {
        this.fLaunchHistoryChangedListeners.remove(listener);
    }

    protected void fireLaunchHistoryChanged() {
        Iterator iterator = this.fLaunchHistoryChangedListeners.iterator();
        while (iterator.hasNext()) {
            ILaunchHistoryChangedListener listener = (ILaunchHistoryChangedListener)iterator.next();
            listener.launchHistoryChanged();
        }
    }

    protected String getHistoryAsXML() throws IOException, CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element historyRootElement = doc.createElement(HISTORY_ROOT_NODE);
        doc.appendChild(historyRootElement);
        Iterator histories = this.fLaunchHistories.values().iterator();
        while (histories.hasNext()) {
            LaunchHistory history = (LaunchHistory)histories.next();
            this.createEntry((Document)doc, historyRootElement, history.getLaunchGroup().getMode(), history.getHistory());
            this.createEntry((Document)doc, historyRootElement, history.getLaunchGroup().getMode(), history.getFavorites());
            ILaunchConfiguration configuration = history.getRecentLaunch();
            if (configuration == null || !configuration.exists()) continue;
            Element last = doc.createElement(HISTORY_LAST_LAUNCH_NODE);
            last.setAttribute(HISTORY_MEMENTO_ATT, configuration.getMemento());
            last.setAttribute(HISTORY_MODE_ATT, history.getLaunchGroup().getMode());
            historyRootElement.appendChild(last);
        }
        return DebugUIPlugin.serializeDocument((Document)doc);
    }

    protected void createEntry(Document doc, Element historyRootElement, String mode, ILaunchConfiguration[] configurations) throws CoreException {
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.exists()) {
                Element launch = doc.createElement(HISTORY_LAUNCH_NODE);
                launch.setAttribute(HISTORY_MEMENTO_ATT, configuration.getMemento());
                launch.setAttribute(HISTORY_MODE_ATT, mode);
                historyRootElement.appendChild(launch);
            }
            ++i;
        }
    }

    protected IPath getHistoryFilePath() {
        return DebugUIPlugin.getDefault().getStateLocation().append(LAUNCH_CONFIGURATION_HISTORY_FILENAME);
    }

    protected void persistLaunchHistory() throws IOException, CoreException {
        if (this.fRestoring) {
            return;
        }
        IPath historyPath = this.getHistoryFilePath();
        String osHistoryPath = historyPath.toOSString();
        String xml = this.getHistoryAsXML();
        File file = new File(osHistoryPath);
        file.createNewFile();
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(xml.getBytes("UTF8"));
        stream.close();
        this.fireLaunchHistoryChanged();
    }

    private void restoreLaunchHistory() {
        IPath historyPath = this.getHistoryFilePath();
        String osHistoryPath = historyPath.toOSString();
        File file = new File(osHistoryPath);
        if (!file.exists()) {
            return;
        }
        FileInputStream stream = null;
        Element rootHistoryElement = null;
        try {
            stream = new FileInputStream(file);
            rootHistoryElement = null;
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    rootHistoryElement = parser.parse(new InputSource(stream)).getDocumentElement();
                }
                catch (SAXException e) {
                    DebugUIPlugin.log(e);
                    Object var7_10 = null;
                    stream.close();
                    return;
                }
                catch (ParserConfigurationException e) {
                    DebugUIPlugin.log(e);
                    Object var7_11 = null;
                    stream.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                stream.close();
                throw throwable;
            }
            Object var7_13 = null;
            stream.close();
        }
        catch (IOException exception) {
            DebugUIPlugin.log(exception);
            return;
        }
        if (!rootHistoryElement.getNodeName().equalsIgnoreCase(HISTORY_ROOT_NODE)) {
            return;
        }
        Collection l = this.fLaunchHistories.values();
        LaunchHistory[] histories = l.toArray(new LaunchHistory[l.size()]);
        NodeList list = rootHistoryElement.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element entry = (Element)node;
                if (entry.getNodeName().equalsIgnoreCase(HISTORY_LAUNCH_NODE)) {
                    this.createHistoryElement(entry, histories);
                } else if (entry.getNodeName().equalsIgnoreCase(HISTORY_LAST_LAUNCH_NODE)) {
                    this.createRecentElement(entry, histories);
                }
            }
            ++i;
        }
    }

    private void createHistoryElement(Element entry, LaunchHistory[] histories) {
        String memento = entry.getAttribute(HISTORY_MEMENTO_ATT);
        String mode = entry.getAttribute(HISTORY_MODE_ATT);
        try {
            ILaunchConfiguration launchConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
            if (launchConfig.exists()) {
                int i = 0;
                while (i < histories.length) {
                    LaunchHistory history = histories[i];
                    if (history.accepts(launchConfig) && history.getLaunchGroup().getMode().equals(mode)) {
                        history.addHistory(launchConfig, false);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private void createRecentElement(Element entry, LaunchHistory[] histories) {
        String memento = entry.getAttribute(HISTORY_MEMENTO_ATT);
        String mode = entry.getAttribute(HISTORY_MODE_ATT);
        try {
            ILaunchConfiguration launchConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
            if (launchConfig.exists()) {
                int i = 0;
                while (i < histories.length) {
                    LaunchHistory history = histories[i];
                    if (history.accepts(launchConfig) && history.getLaunchGroup().getMode().equals(mode)) {
                        history.setRecentLaunch(launchConfig);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private void loadLaunchShortcuts() {
        IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("launchShortcuts");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fLaunchShortcuts = new ArrayList(infos.length);
        int i = 0;
        while (i < infos.length) {
            LaunchShortcutExtension ext = new LaunchShortcutExtension(infos[i]);
            this.fLaunchShortcuts.add(ext);
            ++i;
        }
    }

    private void loadLaunchGroups() {
        if (this.fLaunchGroups == null) {
            IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
            IExtensionPoint extensionPoint = descriptor.getExtensionPoint("launchGroups");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchGroups = new HashMap(infos.length);
            int i = 0;
            while (i < infos.length) {
                LaunchGroupExtension ext = new LaunchGroupExtension(infos[i]);
                this.fLaunchGroups.put(ext.getIdentifier(), ext);
                ++i;
            }
        }
    }

    public List getLaunchShortcuts() {
        if (this.fLaunchShortcuts == null) {
            this.loadLaunchShortcuts();
        }
        return this.fLaunchShortcuts;
    }

    public List getLaunchShortcuts(String category) {
        if (this.fLaunchShortcuts == null) {
            this.loadLaunchShortcuts();
        }
        return this.filterShortcuts(this.fLaunchShortcuts, category);
    }

    protected List filterShortcuts(List unfiltered, String category) {
        ArrayList<LaunchShortcutExtension> filtered = new ArrayList<LaunchShortcutExtension>(unfiltered.size());
        Iterator iter = unfiltered.iterator();
        while (iter.hasNext()) {
            LaunchShortcutExtension extension = (LaunchShortcutExtension)iter.next();
            if (category == null) {
                if (extension.getCategory() != null) continue;
                filtered.add(extension);
                continue;
            }
            if (!category.equals(extension.getCategory())) continue;
            filtered.add(extension);
        }
        return filtered;
    }

    public List getLaunchShortcuts(String perpsective, String category) {
        List list;
        if (this.fLaunchShortcutsByPerspective == null) {
            Iterator shortcuts = this.getLaunchShortcuts().iterator();
            this.fLaunchShortcutsByPerspective = new HashMap(10);
            while (shortcuts.hasNext()) {
                LaunchShortcutExtension ext = (LaunchShortcutExtension)shortcuts.next();
                Iterator perspectives = ext.getPerspectives().iterator();
                while (perspectives.hasNext()) {
                    String id = (String)perspectives.next();
                    ArrayList<LaunchShortcutExtension> list2 = (ArrayList<LaunchShortcutExtension>)this.fLaunchShortcutsByPerspective.get(id);
                    if (list2 == null) {
                        list2 = new ArrayList<LaunchShortcutExtension>(4);
                        this.fLaunchShortcutsByPerspective.put(id, list2);
                    }
                    list2.add(ext);
                }
            }
            Iterator perspectives = this.fLaunchShortcutsByPerspective.keySet().iterator();
            while (perspectives.hasNext()) {
                String id = (String)perspectives.next();
                List list3 = (List)this.fLaunchShortcutsByPerspective.get(id);
                Collections.sort(list3, new ShortcutComparator());
            }
        }
        if ((list = (List)this.fLaunchShortcutsByPerspective.get(perpsective)) == null) {
            return null;
        }
        return this.filterShortcuts(list, category);
    }

    public Image getErrorTabImage(ILaunchConfigurationTab tab) {
        String key;
        Image image;
        if (this.fErrorImages == null) {
            this.fErrorImages = new ImageRegistry();
        }
        if ((image = this.fErrorImages.get(key = tab.getClass().getName())) == null) {
            Image base = tab.getImage();
            if (base == null) {
                base = DebugPluginImages.getImage("IMG_OVR_TRANSPARENT");
            }
            base = new Image((Device)Display.getCurrent(), base, 0);
            LaunchConfigurationTabImageDescriptor desc = new LaunchConfigurationTabImageDescriptor(base, 1);
            image = desc.createImage();
            this.fErrorImages.put(key, image);
        }
        return image;
    }

    public LaunchGroupExtension getLaunchGroup(String id) {
        if (this.fLaunchGroups == null) {
            this.loadLaunchGroups();
        }
        return (LaunchGroupExtension)this.fLaunchGroups.get(id);
    }

    public LaunchGroupExtension[] getLaunchGroups() {
        if (this.fLaunchGroups == null) {
            this.loadLaunchGroups();
        }
        Collection groups = this.fLaunchGroups.values();
        return groups.toArray(new LaunchGroupExtension[groups.size()]);
    }

    public LaunchHistory getLaunchHistory(String id) {
        if (this.fLaunchHistories == null) {
            this.loadLaunchHistories();
        }
        return (LaunchHistory)this.fLaunchHistories.get(id);
    }

    private void loadLaunchHistories() {
        if (this.fLaunchHistories == null) {
            this.fRestoring = true;
            LaunchGroupExtension[] groups = this.getLaunchGroups();
            this.fLaunchHistories = new HashMap(groups.length);
            int i = 0;
            while (i < groups.length) {
                LaunchGroupExtension extension = groups[i];
                if (extension.isPublic()) {
                    this.fLaunchHistories.put(extension.getIdentifier(), new LaunchHistory(extension));
                }
                ++i;
            }
            this.restoreLaunchHistory();
            this.fRestoring = false;
        }
    }

    public LaunchGroupExtension getDefaultLanuchGroup(String mode) {
        if (mode.equals("debug")) {
            return this.getLaunchGroup(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP);
        }
        return this.getLaunchGroup(IDebugUIConstants.ID_RUN_LAUNCH_GROUP);
    }

    public LaunchGroupExtension getLaunchGroup(ILaunchConfiguration configuration, String mode) {
        try {
            String category = configuration.getCategory();
            LaunchGroupExtension[] groups = this.getLaunchGroups();
            int i = 0;
            while (i < groups.length) {
                LaunchGroupExtension extension = groups[i];
                if (category == null ? extension.getCategory() == null && extension.getMode().equals(mode) : category.equals(extension.getCategory()) && extension.getMode().equals(mode)) {
                    return extension;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return null;
    }
}

