/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class AbstractLaunchConfigurationAction
extends SelectionListenerAction {
    private IConfirmationRequestor fConfirmationRequestor;
    private Viewer fViewer;

    public AbstractLaunchConfigurationAction(String text, Viewer viewer) {
        super(text);
        this.fViewer = viewer;
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected abstract void performAction();

    public final void run() {
        if (this.fConfirmationRequestor != null && !this.fConfirmationRequestor.getConfirmation()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                AbstractLaunchConfigurationAction.this.performAction();
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    public void setConfirmationRequestor(IConfirmationRequestor confirmationRequestor) {
        this.fConfirmationRequestor = confirmationRequestor;
    }

    public void dispose() {
        this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void errorDialog(CoreException exception) {
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)exception.getStatus());
    }

    public interface IConfirmationRequestor {
        public boolean getConfirmation();
    }
}

