/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.text.MessageFormat;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.TextViewerAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleViewer;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TextViewerGotoLineAction
extends TextViewerAction {
    protected int fLastLine;
    protected ITextViewer fTextViewer;

    public TextViewerGotoLineAction(ConsoleViewer viewer) {
        super((ITextViewer)viewer, -1);
        this.fTextViewer = viewer;
        this.setText(ActionMessages.getString("TextViewerGotoLineAction.Go_to_&Line...@Ctrl+L_4"));
        this.setToolTipText(ActionMessages.getString("TextViewerGotoLineAction.Go_To_Line_1"));
        this.setDescription(ActionMessages.getString("TextViewerGotoLineAction.Go_To_Line_1"));
    }

    public void update() {
    }

    protected void gotoLine(int line) {
        IDocument document = this.fTextViewer.getDocument();
        try {
            int start = document.getLineOffset(line);
            int length = document.getLineLength(line);
            this.fTextViewer.getTextWidget().setSelection(start, start + length);
            this.fTextViewer.revealRange(start, length);
        }
        catch (BadLocationException x) {
            DebugUIPlugin.errorDialog(this.fTextViewer.getTextWidget().getShell(), ActionMessages.getString("TextViewerGotoLineAction.Go_To_Line_1"), ActionMessages.getString("TextViewerGotoLineAction.Exceptions_occurred_attempt_to_go_to_line_2"), x);
        }
    }

    public void run() {
        try {
            Point selection = this.fTextViewer.getTextWidget().getSelection();
            IDocument document = this.fTextViewer.getDocument();
            this.fLastLine = document.getLineOfOffset(document.getLength()) + 1;
            int startLine = selection == null ? 1 : this.fTextViewer.getTextWidget().getLineAtOffset(selection.x) + 1;
            String title = ActionMessages.getString("TextViewerGotoLineAction.Go_To_Line_1");
            String message = MessageFormat.format(ActionMessages.getString("TextViewerGotoLineAction.Enter_line_number__8"), new Integer(this.fLastLine));
            String value = Integer.toString(startLine);
            Shell activeShell = this.fTextViewer.getTextWidget().getShell();
            InputDialog d = new InputDialog(activeShell, title, message, value, (IInputValidator)new NumberValidator());
            if (d.open() == 0) {
                try {
                    int line = Integer.parseInt(d.getValue());
                    this.gotoLine(line - 1);
                }
                catch (NumberFormatException x) {
                    DebugUIPlugin.errorDialog(activeShell, ActionMessages.getString("TextViewerGotoLineAction.Go_To_Line_1"), ActionMessages.getString("TextViewerGotoLineAction.Exceptions_occurred_attempt_to_go_to_line_2"), x);
                }
            }
        }
        catch (BadLocationException x) {
            DebugUIPlugin.errorDialog(this.fTextViewer.getTextWidget().getShell(), ActionMessages.getString("TextViewerGotoLineAction.Go_To_Line_1"), ActionMessages.getString("TextViewerGotoLineAction.Exceptions_occurred_attempt_to_go_to_line_2"), x);
            return;
        }
    }

    class NumberValidator
    implements IInputValidator {
        NumberValidator() {
        }

        public String isValid(String input) {
            try {
                int i = Integer.parseInt(input);
                if (i <= 0 || TextViewerGotoLineAction.this.fLastLine < i) {
                    return ActionMessages.getString("TextViewerGotoLineAction.Line_number_out_of_range_1");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return ActionMessages.getString("TextViewerGotoLineAction.Not_a_number_2");
            }
            return null;
        }
    }
}

