/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;

public class RemoveAllTerminatedAction
extends AbstractRemoveAllActionDelegate
implements ILaunchesListener {
    static /* synthetic */ Class class$0;

    protected void doHandleDebugEvent(DebugEvent event) {
        if (event.getKind() == 8) {
            ILaunch launch;
            Object source = event.getSource();
            if (source instanceof IDebugTarget) {
                ILaunch launch2 = ((IDebugTarget)source).getLaunch();
                if (launch2.isTerminated() && this.launchIsRegistered(launch2)) {
                    this.getAction().setEnabled(true);
                }
            } else if (source instanceof IProcess && (launch = ((IProcess)source).getLaunch()).isTerminated() && this.launchIsRegistered(launch)) {
                this.getAction().setEnabled(true);
            }
        }
    }

    private boolean launchIsRegistered(ILaunch iLaunch) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.equals(iLaunch)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void update() {
        Object[] elements = this.getElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                ILaunch launch;
                if (elements[i] instanceof ILaunch && (launch = (ILaunch)elements[i]).isTerminated()) {
                    this.getAction().setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.getAction().setEnabled(false);
    }

    protected void doAction() {
        Object[] elements = this.getElements();
        RemoveAllTerminatedAction.removeTerminatedLaunches(elements);
    }

    public Object[] getElements() {
        Viewer viewer;
        IDebugView view = this.getDebugView();
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            IStructuredContentProvider cp = (IStructuredContentProvider)((StructuredViewer)viewer).getContentProvider();
            Object input = viewer.getInput();
            return cp.getElements(input);
        }
        return null;
    }

    public static void removeTerminatedLaunches(Object[] elements) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>();
        int i = 0;
        while (i < elements.length) {
            ILaunch launch;
            if (elements[i] instanceof ILaunch && (launch = (ILaunch)elements[i]).isTerminated()) {
                removed.add(launch);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            manager.removeLaunches(removed.toArray(new ILaunch[removed.size()]));
        }
    }

    protected IDebugView getDebugView() {
        IViewPart iViewPart = this.getView();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IDebugView)iViewPart.getAdapter((Class)clazz);
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        if (this.getAction().isEnabled()) {
            this.update();
        }
    }
}

