/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.FollowHyperlinkAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleView;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class KeyBindingFollowHyperlinkAction
extends FollowHyperlinkAction {
    ConsoleView fView;
    boolean fSelectionNotAHyperlink = false;

    public KeyBindingFollowHyperlinkAction(ConsoleView view) {
        super((ISelectionProvider)view.getConsoleViewer());
        this.fView = view;
    }

    public void run() {
        IConsoleHyperlink link = this.getHyperLink();
        if (link == null) {
            IStatusLineManager statusLine = this.getStatusLineManager();
            if (statusLine != null) {
                statusLine.setErrorMessage(ActionMessages.getString("KeyBindingFollowHyperLinkAction.No_hyperlink"));
                this.fSelectionNotAHyperlink = true;
            }
            this.fView.getSite().getShell().getDisplay().beep();
        } else {
            link.linkActivated();
            this.fSelectionNotAHyperlink = false;
        }
    }

    public void clearStatusLine() {
        IStatusLineManager statusLine;
        if (this.fSelectionNotAHyperlink && (statusLine = this.getStatusLineManager()) != null) {
            statusLine.setErrorMessage(null);
            this.fSelectionNotAHyperlink = false;
        }
    }

    public void selectionChanged(ISelection selection) {
        if (this.isEmptySelection(selection)) {
            this.clearStatusLine();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    protected boolean isEmptySelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() < 1;
        }
        return selection.isEmpty();
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.fView.getViewSite().getActionBars().getStatusLineManager();
    }
}

