/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class EnableBreakpointsAction
implements IViewActionDelegate,
IPartListener,
IBreakpointsListener {
    private IViewPart fView;
    private IAction fAction;

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart view) {
        this.fView = view;
    }

    public void init(IViewPart view) {
        this.setView(view);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        view.getViewSite().getPage().addPartListener((IPartListener)this);
    }

    protected void update() {
        this.selectionChanged(this.getAction(), this.getView().getViewSite().getSelectionProvider().getSelection());
    }

    protected boolean isEnableAction() {
        return true;
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        final int size = selection.size();
        if (size == 0) {
            return;
        }
        final Iterator iterator = selection.iterator();
        final MultiStatus ms = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("EnableBreakpointAction.Enable_breakpoint(s)_failed_2"), null);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                while (iterator.hasNext()) {
                    IBreakpoint breakpoint = (IBreakpoint)iterator.next();
                    try {
                        if (size > 1) {
                            if (EnableBreakpointsAction.this.isEnableAction()) {
                                breakpoint.setEnabled(true);
                                continue;
                            }
                            breakpoint.setEnabled(false);
                            continue;
                        }
                        breakpoint.setEnabled(!breakpoint.isEnabled());
                    }
                    catch (CoreException e) {
                        ms.merge(e.getStatus());
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.getString("EnableBreakpointAction.Enabling_breakpoints_3"), ActionMessages.getString("EnableBreakpointAction.Exceptions_occurred_enabling_the_breakpoint(s)._4"), (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getView().getViewSite().getSelectionProvider().getSelection();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object o = sel.getFirstElement();
        if (!(o instanceof IBreakpoint)) {
            return;
        }
        Iterator iterator = sel.iterator();
        boolean allEnabled = true;
        boolean allDisabled = true;
        while (iterator.hasNext()) {
            IBreakpoint bp = (IBreakpoint)iterator.next();
            try {
                if (bp.isEnabled()) {
                    allDisabled = false;
                    continue;
                }
                allEnabled = false;
            }
            catch (CoreException ce) {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.getString("EnableBreakpointAction.Enabling_breakpoints_3"), ActionMessages.getString("EnableBreakpointAction.Exceptions_occurred_enabling_the_breakpoint(s)._4"), ce);
                    continue;
                }
                DebugUIPlugin.log(ce);
            }
        }
        if (this.isEnableAction()) {
            action.setEnabled(!allEnabled);
        } else {
            action.setEnabled(!allDisabled);
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.asynchUpdate();
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.asynchUpdate();
    }

    protected void asynchUpdate() {
        if (this.getAction() == null) {
            return;
        }
        IWorkbenchWindow window = this.getView().getViewSite().getPage().getWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                IWorkbenchWindow window = EnableBreakpointsAction.this.getView().getViewSite().getPage().getWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                EnableBreakpointsAction.this.update();
            }
        };
        shell.getDisplay().asyncExec(r);
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

