/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class CopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private ContentViewer fViewer;
    static /* synthetic */ Class class$0;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter;
            IViewPart iViewPart = this.getView();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
                if (adapter.getViewer() instanceof ContentViewer) {
                    this.setViewer((ContentViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return "copy";
    }

    protected boolean isEnabledFor(Object element) {
        return this.getViewer() != null && element instanceof IDebugElement;
    }

    protected void doAction(Object element, StringBuffer buffer) {
        this.append(element, buffer, (ILabelProvider)this.getViewer().getLabelProvider(), 0);
    }

    protected void append(Object e, StringBuffer buffer, ILabelProvider lp, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append('\t');
            ++i;
        }
        buffer.append(lp.getText(e));
        buffer.append(System.getProperty("line.separator"));
        if (this.shouldAppendChildren(e)) {
            Object[] children = new Object[]{};
            children = this.getChildren(e);
            int i2 = 0;
            while (i2 < children.length) {
                Object de = children[i2];
                this.append(de, buffer, lp, indent + 1);
                ++i2;
            }
        }
    }

    protected Object getParent(Object e) {
        return ((ITreeContentProvider)this.getViewer().getContentProvider()).getParent(e);
    }

    protected Object[] getChildren(Object parent) {
        Object[] children = ((ITreeContentProvider)this.getViewer().getContentProvider()).getChildren(parent);
        ViewerFilter[] filters = ((StructuredViewer)this.getViewer()).getFilters();
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                ViewerFilter f = filters[i];
                children = f.filter((Viewer)this.getViewer(), parent, children);
                ++i;
            }
        }
        return children;
    }

    public void run(IAction action) {
        final Iterator iter = this.pruneSelection();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                StringBuffer buffer = new StringBuffer();
                while (iter.hasNext()) {
                    CopyToClipboardActionDelegate.this.doAction(iter.next(), buffer);
                }
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(CopyToClipboardActionDelegate.this.getViewer().getControl().getDisplay());
                try {
                    CopyToClipboardActionDelegate.this.doCopy(clipboard, plainTextTransfer, buffer);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    clipboard.dispose();
                    throw throwable;
                }
                Object var4_6 = null;
                clipboard.dispose();
            }
        });
    }

    protected void doCopy(Clipboard clipboard, TextTransfer plainTextTransfer, StringBuffer buffer) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getViewer().getControl().getShell(), (String)ActionMessages.getString("CopyToClipboardActionDelegate.Problem_Copying_to_Clipboard_1"), (String)ActionMessages.getString("CopyToClipboardActionDelegate.There_was_a_problem_when_accessing_the_system_clipboard._Retry__2"))) break block3;
                this.doCopy(clipboard, plainTextTransfer, buffer);
            }
        }
    }

    protected Iterator pruneSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        ArrayList elements = new ArrayList(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!this.isEnabledFor(element) || !this.walkHierarchy(element, elements)) continue;
            elements.add(element);
        }
        return elements.iterator();
    }

    protected boolean walkHierarchy(Object element, List elements) {
        Object parent = this.getParent(element);
        if (parent == null || parent == element) {
            return true;
        }
        if (elements.contains(parent)) {
            return false;
        }
        return this.walkHierarchy(parent, elements);
    }

    protected boolean shouldAppendChildren(Object e) {
        return e instanceof IDebugTarget || e instanceof IThread;
    }

    protected ContentViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(ContentViewer viewer) {
        this.fViewer = viewer;
    }

    protected void doAction(Object element) {
    }
}

