/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class InstructionPointerAnnotation
extends Annotation {
    private IStackFrame fStackFrame;
    private boolean fTopStackFrame;
    public static final int INSTRUCTION_POINTER_ANNOTATION_LAYER = 6;

    public InstructionPointerAnnotation(IStackFrame stackFrame) {
        this.setLayer(6);
        this.setStackFrame(stackFrame);
        this.setTopStackFrame(stackFrame);
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Image image = this.getInstructionPointerImage(this.isTopStackFrame());
        Annotation.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
    }

    protected Image getInstructionPointerImage(boolean topStackFrame) {
        if (topStackFrame) {
            return DebugPluginImages.getImage("IMG_OBJS_INSTRUCTION_POINTER_TOP");
        }
        return DebugPluginImages.getImage("IMG_OBJS_INSTRUCTION_POINTER");
    }

    public boolean equals(Object other) {
        if (other instanceof InstructionPointerAnnotation) {
            return this.getStackFrame().equals(((InstructionPointerAnnotation)((Object)other)).getStackFrame());
        }
        return false;
    }

    public int hashCode() {
        return this.getStackFrame().hashCode();
    }

    private void setStackFrame(IStackFrame stackFrame) {
        this.fStackFrame = stackFrame;
    }

    public IStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    private void setTopStackFrame(IStackFrame stackFrame) {
        IThread thread = stackFrame.getThread();
        try {
            this.fTopStackFrame = stackFrame.equals(thread.getTopStackFrame());
        }
        catch (DebugException debugException) {
            this.fTopStackFrame = false;
        }
    }

    public boolean isTopStackFrame() {
        return this.fTopStackFrame;
    }
}

