/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.textdriver;

import com.sap.tc.jtools.jver.JverVersion;
import com.sap.tc.jtools.jver.driver.JverOption;
import com.sap.tc.jtools.jver.scanner.JverClassLoaderType;
import com.sap.tc.jtools.jver.textdriver.IArgHandlerMsg;
import com.sap.tc.jtools.jver.textdriver.IJverTextdriverMsg;

public class ArgumentHandler {
    private static final char OPTION_NOT_RECOGNIZED = '\u0000';
    private static final char OPTION_HANDLED = '\u0001';
    private AComposedLongOptionOnly longOptionOnly = null;
    private JverOption option_;
    private static String[] nonOptions_ = null;
    private static final char surrogateSimpleOption_ = '-';
    private IArgHandlerMsg msgHandler_ = null;
    private boolean isAllDone_ = false;
    static /* synthetic */ Class class$com$sap$tc$jtools$jver$textdriver$Driver;

    public ArgumentHandler(IArgHandlerMsg msgHandler) {
        this.msgHandler_ = msgHandler;
        this.option_ = new JverOption();
    }

    public JverOption getJverOption() {
        return this.option_;
    }

    public String[] getNonOptions() {
        return nonOptions_ == null ? new String[]{} : nonOptions_;
    }

    public void printUsage() {
        this.msgHandler_.info("Usage: " + (class$com$sap$tc$jtools$jver$textdriver$Driver == null ? (class$com$sap$tc$jtools$jver$textdriver$Driver = ArgumentHandler.class$("com.sap.tc.jtools.jver.textdriver.Driver")) : class$com$sap$tc$jtools$jver$textdriver$Driver).getName() + " [option]* <package-node> [<package-node>*]");
        String[] options = this.getOptionHelpList();
        int i = 0;
        while (i < options.length) {
            this.msgHandler_.info(options[i]);
            ++i;
        }
    }

    private String[] getOptionHelpList() {
        String[] options = new String[]{"  -help, -h:             prints out this information", "  -addpath, -a <path>:   additional path specification for loading test classes (dir/jar)", "  -class, -c:            targets are classes (default: targets are packages)", "  -config <file>:        use this config properties (default: JverConfig.properties)", "  -debuglog, -d <name>:  write debug log file with the specified name", "  -d-:                   suppress debug log", "  -init, -i <name>:      initialize test parameters using this property file", "  -Loader, -L <name>:    custom class loader", "  -listener, -o <name>:  redirect output to custom listener implementation", "  -addListener, -O <name>:  add custom listener rather than exchanging listener", "  -performance, -p <name>: do performance checking, log results in file with the specified name", "  -silent, -s:           silent mode - no output during test run", "  -tasklist, -t <name>:  the jver task list (get test classes from this file)", "                         extension defaults to 'jvertask' if omitted", "  -userlog, -u System.err | System.out | <name>: ", "                         write user log file with the specified name or to the System stream", "  -verbose, -v:          prints out verbose information during processing", "  -Version, -V:          prints out the jver version", "  -xml, -x:              uses xml format for message output"};
        return options;
    }

    public void printVersion() {
        this.msgHandler_.info(JverVersion.VERSION);
    }

    public void readArguments(String[] args) {
        int nNonOptions = 0;
        int ii = 0;
        String longOption = "";
        ii = 0;
        while (ii < args.length) {
            args[ii] = args[ii].trim();
            ++ii;
        }
        ii = 0;
        while (ii < args.length) {
            String arg = args[ii];
            if (this.isOption(arg)) {
                char cc = '\u0000';
                if (arg.length() > 2) {
                    longOption = arg.substring(1);
                    cc = this.readVerboseOption(longOption);
                } else if (arg.length() == 2) {
                    cc = arg.charAt(1);
                }
                if (!this.readSimpleOption(cc)) {
                    if (this.isComposedOption(cc)) {
                        int next = ii + 1;
                        if (next < args.length && !this.isOption(args[next])) {
                            this.readComposedOption(cc, args[next]);
                            args[next] = "-";
                            ++ii;
                        } else {
                            String sShortOption = cc == '-' ? "" : String.valueOf(cc) + "'/";
                            String sBothOptions = sShortOption + longOption;
                            this.msgHandler_.warn(IJverTextdriverMsg.COMPOSED_OPTION_INCOMPLETE, sBothOptions);
                        }
                    } else {
                        this.msgHandler_.warn(IJverTextdriverMsg.UNKNOWN_OPTION, arg);
                    }
                }
            } else {
                ++nNonOptions;
            }
            ++ii;
        }
        nonOptions_ = new String[nNonOptions];
        int index = 0;
        ii = 0;
        while (ii < args.length) {
            String arg = args[ii];
            if (!this.isOption(arg)) {
                ArgumentHandler.nonOptions_[index] = arg;
                ++index;
            }
            ++ii;
        }
    }

    private boolean readSimpleOption(char cc) {
        switch (cc) {
            case '\u0001': {
                break;
            }
            case 'c': {
                this.option_.setClassTargets(true);
                break;
            }
            case 'h': {
                this.printVersion();
                this.printUsage();
                this.isAllDone_ = true;
                break;
            }
            case 's': {
                this.option_.setSilent(true);
                break;
            }
            case 'v': {
                this.option_.setVerbose(true);
                break;
            }
            case 'V': {
                this.printVersion();
                this.isAllDone_ = true;
                break;
            }
            case 'x': {
                this.option_.setXmlOutput(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean isComposedOption(char cc) {
        return this.composedOption(cc, null, false);
    }

    private boolean readComposedOption(char cc, String value) {
        return this.composedOption(cc, value, true);
    }

    private boolean composedOption(char cc, String value, boolean doProcess) {
        switch (cc) {
            case 'a': {
                if (!doProcess) break;
                this.option_.setAdditionalPath(value);
                break;
            }
            case 'd': {
                if (!doProcess) break;
                this.option_.setDbgLogFile(value);
                break;
            }
            case 'f': {
                if (!doProcess) {
                    this.msgHandler_.warn(IJverTextdriverMsg.OBSOLETE_OPTION, "<-f>", "<-t> or <-tasklist>");
                }
                return this.composedOption('t', value, doProcess);
            }
            case 'i': {
                if (!doProcess) break;
                this.option_.setParametersFromFile(true);
                this.option_.setParametersFromThisFile(value);
                break;
            }
            case 'l': {
                if (!doProcess) {
                    // empty if block
                }
                return this.composedOption('a', value, doProcess);
            }
            case 'L': {
                if (!doProcess) break;
                this.option_.setClassLoaderType(JverClassLoaderType.registerCustomClassLoader(value));
                break;
            }
            case 'o': {
                if (!doProcess) break;
                this.option_.setCustomListenerName(value);
                break;
            }
            case 'O': {
                if (!doProcess) break;
                this.option_.addCustomListenerName(value);
                break;
            }
            case 'p': {
                if (!doProcess) break;
                this.option_.setPerfLogFile(value);
                break;
            }
            case 't': {
                if (!doProcess) break;
                if (value.indexOf(46) < 0) {
                    value = value.concat(".jvertask");
                }
                this.option_.setTaskFromFile(value);
                this.option_.setClassTargets(true);
                break;
            }
            case 'u': {
                if (!doProcess) break;
                this.option_.setUserLogFile(value);
                break;
            }
            case '-': {
                if (this.longOptionOnly != null) {
                    if (!doProcess) break;
                    this.longOptionOnly.processValue(value);
                    this.longOptionOnly = null;
                    break;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private char readVerboseOption(String longOption) {
        int simpleOption = 0;
        String slcOption = longOption.toLowerCase();
        if (slcOption.equals("help")) {
            simpleOption = 104;
        } else if (slcOption.equals("addpath")) {
            simpleOption = 97;
        } else if (slcOption.equals("class")) {
            simpleOption = 99;
        } else if (slcOption.equals("config")) {
            this.longOptionOnly = new CLOOConfig();
            simpleOption = 45;
        } else if (slcOption.equals("debuglog")) {
            simpleOption = 100;
        } else if (slcOption.equals("d-")) {
            this.option_.setDbgLogFile(null);
            simpleOption = 1;
        } else if (slcOption.equals("file")) {
            this.msgHandler_.warn(IJverTextdriverMsg.OBSOLETE_OPTION, "<-file>", "<-t> or <-tasklist>");
            simpleOption = 116;
        } else if (slcOption.equals("filepreselection")) {
            this.option_.setPreselection(true);
            simpleOption = 116;
        } else if (slcOption.equals("init")) {
            simpleOption = 105;
        } else if (slcOption.equals("location")) {
            simpleOption = 97;
        } else if (slcOption.equals("loader")) {
            simpleOption = 76;
        } else if (slcOption.equals("listener")) {
            simpleOption = 111;
        } else if (slcOption.equals("addlistener")) {
            simpleOption = 79;
        } else if (slcOption.equals("performance")) {
            simpleOption = 112;
        } else if (slcOption.equals("selftestmode")) {
            JverOption.setSelfTest(true);
            simpleOption = 1;
        } else if (slcOption.equals("selftestpath")) {
            this.longOptionOnly = new CLOOSelfTestPath();
            simpleOption = 45;
        } else if (slcOption.equals("silent")) {
            simpleOption = 115;
        } else if (slcOption.equals("tasklist")) {
            simpleOption = 116;
        } else if (slcOption.equals("userlog")) {
            simpleOption = 117;
        } else if (slcOption.equals("verbose")) {
            simpleOption = 118;
        } else if (slcOption.equals("version")) {
            simpleOption = 86;
        } else if (slcOption.equals("xml")) {
            simpleOption = 120;
        }
        return (char)simpleOption;
    }

    private final boolean isOption(String item) {
        return item.length() > 0 && item.charAt(0) == '-';
    }

    public boolean isAllDone() {
        return this.isAllDone_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CLOOConfig
    extends AComposedLongOptionOnly {
        private CLOOConfig() {
        }

        void processValue(String value) {
            ArgumentHandler.this.option_.setJverConfigFile(value);
        }
    }

    private class CLOOSelfTestPath
    extends AComposedLongOptionOnly {
        private CLOOSelfTestPath() {
        }

        void processValue(String value) {
            JverOption.setSelfTest(true);
            JverOption.setSelfTestPath(value);
        }
    }

    private abstract class AComposedLongOptionOnly {
        AComposedLongOptionOnly() {
        }

        abstract void processValue(String var1);
    }
}

