/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.scanner.IJverClassEnumeration;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.IJverScannerMsg;
import com.sap.tc.jtools.jver.scanner.IScanner;
import com.sap.tc.jtools.jver.scanner.JverCheckTestClass;
import com.sap.tc.jtools.jver.scanner.JverTarget;
import com.sap.tc.jtools.jver.scanner.JverTargetVector;
import java.io.File;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ScannerFixTestSet
implements IScanner,
IJverClassEnumeration {
    private String commonPath_ = null;
    private IJverClassLoader classLoader_ = null;
    private IMsgCollector msgCollector = null;
    private JverConfig config_ = null;
    private Enumeration testClassEnumeration = null;
    private Class currentClass = null;
    private File currentPropertyFile = null;
    private boolean needsFetch = true;

    public void init(IJverClassLoader classLoader, IMsgCollector msgCollector) {
        this.classLoader_ = classLoader;
        this.msgCollector = msgCollector;
    }

    public void setTargets(JverConfig config, JverTargetVector testClasses, String path) {
        this.setConfig(config);
        this.setTestClassEnumeration(testClasses.elements());
        StringBuffer bufPath = new StringBuffer(path);
        if (bufPath.length() > 0 && testClasses.getCommonClassPath().length() > 0) {
            bufPath.append(';');
        }
        bufPath.append(testClasses.getCommonClassPath());
        this.setCommonPath(bufPath.toString());
    }

    public Enumeration elements() {
        return this;
    }

    public File getCurrentPropertyFile() {
        return this.currentPropertyFile;
    }

    public boolean hasMoreElements() {
        this.fetchIfNecessary();
        return this.getCurrentClass() != null;
    }

    public Object nextElement() {
        ScannerFixTestSet scannerFixTestSet = this;
        synchronized (scannerFixTestSet) {
            this.fetchIfNecessary();
            this.needsFetch = true;
            Class clazz = this.getCurrentClass();
            if (clazz == null) {
                throw new NoSuchElementException("TestClassSet Enumeration");
            }
            Class clazz2 = clazz;
            return clazz2;
        }
    }

    public void setCommonPath(String value) {
        this.commonPath_ = value;
    }

    public String getCommonPath() {
        return this.commonPath_ == null ? "" : this.commonPath_;
    }

    protected void setCurrentPropertyFile(File value) {
        this.currentPropertyFile = value;
    }

    private Class getCurrentClass() {
        return this.currentClass;
    }

    private void setCurrentClass(Class value) {
        this.currentClass = value;
    }

    private void setTestClassEnumeration(Enumeration enumeration) {
        this.testClassEnumeration = enumeration;
    }

    private void setConfig(JverConfig config) {
        this.config_ = config;
    }

    private void fetchIfNecessary() {
        if (this.needsFetch) {
            this.loadNextClass();
            this.needsFetch = false;
        }
    }

    private void loadNextClass() {
        Class clazz = null;
        Object next = null;
        String name = "";
        String specificPath = "";
        File propertyFile = null;
        StringBuffer path = null;
        while (clazz == null && this.testClassEnumeration != null && this.testClassEnumeration.hasMoreElements()) {
            path = new StringBuffer(this.getCommonPath());
            next = this.testClassEnumeration.nextElement();
            if (next instanceof JverTarget) {
                name = ((JverTarget)next).getTarget();
                specificPath = ((JverTarget)next).getClassPath();
                propertyFile = ((JverTarget)next).getPropertyFile();
                if (specificPath.length() > 0) {
                    if (path.length() > 0) {
                        path.append(';');
                    }
                    path.append(specificPath);
                }
            } else {
                name = next;
            }
            if (!JverCheckTestClass.isTestClassName(name)) {
                IJverScannerMsg.CLASS_NAMING_CONVENTION.add(this.msgCollector, name);
                continue;
            }
            if (!this.config_.passesSkipFilter(name)) {
                IJverScannerMsg.PROHIBITED_PACKAGE.add(this.msgCollector, name);
                continue;
            }
            try {
                clazz = this.classLoader_.loadClassForName(name, path.toString());
            }
            catch (ClassNotFoundException e) {
                IJverScannerMsg.CLASS_NOT_FOUND.add(this.msgCollector, name);
            }
        }
        this.setCurrentClass(clazz);
        this.setCurrentPropertyFile(propertyFile);
    }
}

