/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.scanner.IJverScannerMsg;
import com.sap.tc.jtools.jver.scanner.JverCheckTestClass;
import com.sap.tc.jtools.jver.scanner.JverJ2eeConfig;
import com.sap.tc.jtools.jver.scanner.PTComponent;
import com.sap.tc.jtools.jver.scanner.PTComposite;
import com.sap.tc.jtools.jver.scanner.PTLeafArchiveEntry;
import com.sap.tc.jtools.jver.scanner.PTLeafClassFile;
import com.sap.tc.jtools.jver.scanner.PTViewer;
import java.io.File;
import java.io.FileFilter;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

class PackageTree {
    private final FileFilter filter = new FileFilter(){

        public boolean accept(File file) {
            boolean doAcceptFile;
            boolean bl = doAcceptFile = file.isDirectory() || JverCheckTestClass.isClassFile(file.getName());
            if (JverJ2eeConfig.isRunningInJ2ee()) {
                doAcceptFile = JverJ2eeConfig.isTestClassesInSeparateJar() ? doAcceptFile || PackageTree.this.config_.isTestArchive(file) : doAcceptFile || PackageTree.this.config_.isArchive(file);
            }
            return doAcceptFile;
        }
    };
    private PTViewer logTree_ = null;
    private IMsgCollector msgCollector_ = null;
    private JverConfig config_ = null;
    private PTComposite root = new PTComposite("");

    public PackageTree(IMsgCollector collector, JverConfig config) {
        this.msgCollector_ = collector;
        this.config_ = config;
        this.setLogTreeActive(config.getBooleanValue("debug.packageTree.view", false));
    }

    public void fill(AbstractCollection collection) {
        Iterator pathIterator = collection.iterator();
        DbgLog.println("Path information for scanner:");
        while (pathIterator.hasNext()) {
            File directory = (File)pathIterator.next();
            DbgLog.println(directory.toString());
            this.scanPath(directory, "", false);
        }
        this.logTree();
        this.showLogTree();
    }

    private void logTree() {
        DbgLog.println("Scan package structure:");
        this.logTree(this.root, "", false);
    }

    private void logTree(PTComponent node, String indent, boolean hasMoreBrothers) {
        boolean isComposite = node.getComposite() != null;
        Enumeration e = node.getChildren();
        String name = node.getName();
        if (isComposite) {
            String addIndent;
            String string = addIndent = hasMoreBrothers ? "| " : "  ";
            if (name.length() > 0) {
                DbgLog.println(indent + "| ");
                DbgLog.println(indent + "+-" + name + "/");
                DbgLog.println(indent + addIndent + "|");
            }
            while (e.hasMoreElements()) {
                PTComponent child = (PTComponent)e.nextElement();
                this.logTree(child, indent + addIndent, e.hasMoreElements());
            }
            DbgLog.println(indent + addIndent);
        } else {
            DbgLog.println(indent + "+-* " + name);
        }
    }

    public PTComposite getRoot() {
        return this.root;
    }

    public PTComponent findComponent(String name) {
        return this.findComponent(this.root, name, false);
    }

    private PTComposite findOrGenerateComposite(String name) {
        return (PTComposite)this.findComponent(this.root, name, true);
    }

    private String convertToQualifiedClassName(String fileName) {
        String className = fileName.substring(0, fileName.lastIndexOf(46));
        className = className.replace(File.separatorChar, '.').replace('/', '.');
        return className;
    }

    private void scanPath(File f, String path, boolean bIsRecursiveCall) {
        String name = f.getName();
        if (f.isDirectory()) {
            File[] localFiles = f.getAbsoluteFile().listFiles(this.filter);
            String newPath = path.endsWith(".WEB-INF.") && name.equals("classes") ? "" : (bIsRecursiveCall ? path + name + '.' : "");
            int i = 0;
            while (i < localFiles.length) {
                this.scanPath(localFiles[i], newPath, true);
                ++i;
            }
            this.logTreeAdd(newPath);
        } else if (this.config_.isArchive(f)) {
            this.addArchiveEntries(f);
        } else if (JverCheckTestClass.isTestClassFile(name)) {
            this.addClass(path, name);
        } else {
            return;
        }
    }

    private void addArchiveEntries(File archive) {
        try {
            JarFile jarFile = new JarFile(archive, true, 1);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName();
                boolean bIsTestClass = JverCheckTestClass.isTestClassFile(fileName);
                if (bIsTestClass) {
                    String className = this.convertToQualifiedClassName(fileName);
                    this.addClassFromArchive(className, archive);
                    continue;
                }
                this.logTreeDirectoryStructure(fileName);
            }
            jarFile.close();
        }
        catch (ZipException e) {
            IJverScannerMsg.ZIP_OPEN_ERROR.add(this.msgCollector_, archive.getName());
        }
        catch (Exception e) {
            IJverScannerMsg.UNEXPECTED_ERROR.add(this.msgCollector_, e.toString());
            DbgLog.printStackTrace(e);
        }
    }

    private void addClassFromArchive(String qualName, File jarFile) {
        if (!this.config_.passesSkipFilter(qualName)) {
            this.logTreeMarkSkipped(qualName);
            return;
        }
        int posFilename = qualName.lastIndexOf(46) + 1;
        String parentName = qualName.substring(0, posFilename);
        PTComposite parentNode = this.findOrGenerateComposite(parentName);
        if (parentNode != null) {
            String className = qualName.substring(posFilename);
            PTLeafArchiveEntry cNew = new PTLeafArchiveEntry(className, jarFile);
            parentNode.add(cNew);
            this.logTreeAddTestClassArchive(qualName, jarFile);
        }
    }

    private void addClass(String parentName, String fileName) {
        if (!this.config_.passesSkipFilter(parentName)) {
            this.logTreeMarkSkipped(parentName);
            return;
        }
        String className = fileName.substring(0, fileName.lastIndexOf(46));
        PTComposite parentNode = this.findOrGenerateComposite(parentName);
        if (parentNode != null) {
            PTLeafClassFile cNew = new PTLeafClassFile(className);
            parentNode.add(cNew);
            this.logTreeAddTestClass(parentName + '.' + className);
        }
    }

    private PTComponent findComponent(PTComposite startNode, String name, boolean bParentNode) {
        String remainingName;
        String thisLevelName;
        int posDot = name.indexOf(46);
        if (posDot < 0) {
            if (name.equals("")) {
                return startNode;
            }
            thisLevelName = name;
            remainingName = "";
        } else {
            thisLevelName = name.substring(0, posDot);
            remainingName = name.substring(posDot + 1);
        }
        PTComposite matchComposite = null;
        Enumeration e = startNode.getChildren();
        while (e.hasMoreElements()) {
            PTComponent component = (PTComponent)e.nextElement();
            if (!thisLevelName.equals(component.getName())) continue;
            PTComposite composite = component.getComposite();
            if (composite == null) {
                if (!bParentNode) {
                    return component;
                }
                IJverScannerMsg.AMBIGUOUS_PACKAGE_OR_CLASS.add(this.msgCollector_);
                continue;
            }
            matchComposite = composite;
        }
        if (matchComposite == null) {
            if (bParentNode) {
                matchComposite = new PTComposite(thisLevelName);
                startNode.add(matchComposite);
            } else {
                return null;
            }
        }
        if (remainingName.equals("")) {
            return matchComposite;
        }
        return this.findComponent(matchComposite, remainingName, bParentNode);
    }

    private final void logTreeAdd(String name) {
        if (this.logTree_ != null) {
            this.logTree_.add(name);
        }
    }

    private final void logTreeAddTestClass(String name) {
        if (this.logTree_ != null) {
            this.logTree_.add(name + ": TESTCLASS?");
        }
    }

    private final void logTreeAddTestClassArchive(String name, File file) {
        if (this.logTree_ != null) {
            String fileName = file.getName();
            fileName = fileName.replace('.', ',');
            this.logTree_.add(name + " (" + fileName + ") : TESTCLASS?");
        }
    }

    private void logTreeMarkSkipped(String name) {
        this.logTreeAdd(name + '.' + "SKIPPED");
    }

    private final void logTreeDirectoryStructure(String fileName) {
        if (this.logTree_ != null) {
            if (!JverCheckTestClass.isClassFile(fileName)) {
                return;
            }
            String className = this.convertToQualifiedClassName(fileName);
            int cutPath = className.lastIndexOf(46);
            if (cutPath > 0) {
                this.logTree_.add(className.substring(0, cutPath));
            }
        }
    }

    public void setLogTreeActive(boolean setActive) {
        if (setActive) {
            this.logTree_ = new PTViewer("Class Path Parsing (only checks test class naming convention)");
        }
    }

    public void showLogTree() {
        if (this.logTree_ != null) {
            Vector skipPackages = this.config_.getSkipPackages();
            Iterator iterator = ((AbstractCollection)skipPackages).iterator();
            while (iterator.hasNext()) {
                String packageName = (String)iterator.next();
                if (!this.logTree_.findAndRemoveAllChildren(packageName)) continue;
                this.logTreeMarkSkipped(packageName);
            }
            PTViewer.runUntilReady(this.logTree_);
        }
    }
}

