/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.IJverScannerMsg;
import com.sap.tc.jtools.jver.scanner.PTComponent;
import com.sap.tc.jtools.jver.scanner.PTComposite;
import java.util.Enumeration;
import java.util.Stack;

class PTWalker {
    private Class baseTest_ = null;
    private Stack stackQualifiedName_ = null;
    private Stack stackChildrenEnum_ = null;
    private Class nextClass_ = null;
    private IJverClassLoader loader_ = null;
    private IMsgCollector collector_ = null;
    private String loadPath_ = null;

    public PTWalker(IJverClassLoader loader, String loadPath, IMsgCollector collector) {
        this.loader_ = loader;
        this.loadPath_ = loadPath;
        this.collector_ = collector;
    }

    public void setSubTreeRoot(PTComposite node, String packageName) {
        this.stackChildrenEnum_ = new Stack();
        Enumeration e = node.getChildren();
        this.stackChildrenEnum_.push(e);
        this.stackQualifiedName_ = new Stack();
        this.stackQualifiedName_.push(packageName);
    }

    public boolean setNextTestClassIfValid(String packageName) {
        Class clazz;
        this.nextClass_ = clazz = this.getClassIfDerivedFromTestFW(packageName);
        return clazz != null;
    }

    public Class getNextClassFromCurrentPackage() {
        Class clazz = null;
        if (this.nextClass_ != null) {
            clazz = this.nextClass_;
            this.nextClass_ = null;
            return clazz;
        }
        PTComponent child = null;
        PTComposite compositeChild = null;
        String path = "";
        StringBuffer qualifiedName = null;
        Enumeration e = null;
        while (this.stackChildrenEnum_ != null && !this.stackChildrenEnum_.empty()) {
            e = (Enumeration)this.stackChildrenEnum_.pop();
            while (e.hasMoreElements()) {
                child = (PTComponent)e.nextElement();
                compositeChild = child.getComposite();
                path = (String)this.stackQualifiedName_.peek();
                qualifiedName = new StringBuffer(200);
                if (path.length() > 0) {
                    qualifiedName.append(path);
                    qualifiedName.append('.');
                }
                qualifiedName.append(child.getName());
                if (compositeChild == null) {
                    clazz = this.getClassIfDerivedFromTestFW(qualifiedName.toString());
                    if (clazz != null) {
                        this.stackChildrenEnum_.push(e);
                        return clazz;
                    }
                    qualifiedName = null;
                    continue;
                }
                this.stackChildrenEnum_.push(e);
                this.stackQualifiedName_.push(qualifiedName.toString());
                e = compositeChild.getChildren();
            }
            this.stackQualifiedName_.pop();
        }
        return null;
    }

    private Class getClassIfDerivedFromTestFW(String qualifiedName) {
        Class clTest = null;
        try {
            Class baseTest = this.getBaseTest();
            clTest = this.loader_.loadClassForName(qualifiedName, this.getLoadPath());
            DbgLog.println("loaded: " + clTest.getName());
            if (!baseTest.isAssignableFrom(clTest)) {
                String msg = IJverScannerMsg.NOT_A_JVER_TEST_CLASS.formatMessage(new Object[]{clTest.getName()});
                DbgLog.println(msg);
                clTest = null;
            }
        }
        catch (ClassNotFoundException e) {
            IJverScannerMsg.CLASS_NOT_FOUND.add(this.collector_, qualifiedName);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            IJverScannerMsg.INIT_FAILURE.add(this.collector_, qualifiedName);
        }
        catch (LinkageError linkageError) {
            IJverScannerMsg.LINKAGE_FAILURE.add(this.collector_, qualifiedName);
        }
        catch (JverProcessException e) {
            this.collector_.addWarning(e);
        }
        catch (Exception e) {
            DbgLog.printStackTrace(e);
            IJverScannerMsg.UNEXPECTED_ERROR.add(this.collector_, e.toString());
        }
        return clTest;
    }

    private Class getBaseTest() throws JverProcessException {
        if (this.baseTest_ == null) {
            try {
                this.baseTest_ = this.loader_.loadClassForName("com.sap.tc.jtools.jver.framework.Test", null);
            }
            catch (ClassNotFoundException e) {
                throw new JverProcessException("Could not load base test", "Internal problem");
            }
        }
        return this.baseTest_;
    }

    public String getLoadPath() {
        return this.loadPath_;
    }

    public void setLoadPath(String value) {
        this.loadPath_ = value;
    }
}

