/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class PTViewer
extends JFrame
implements Runnable {
    private DefaultMutableTreeNode root_;
    private boolean finished_ = false;

    static void runUntilReady(PTViewer viewer) {
        Thread thread = new Thread(viewer);
        thread.start();
        while (!viewer.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public PTViewer(String name) {
        this.root_ = new DefaultMutableTreeNode(name);
    }

    public void add(String name) {
        DefaultMutableTreeNode node = this.root_;
        DefaultMutableTreeNode child = null;
        StringTokenizer path = new StringTokenizer(name, ".");
        block0: while (path.hasMoreElements()) {
            String branchName = (String)path.nextElement();
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                child = (DefaultMutableTreeNode)children.nextElement();
                if (!child.toString().equals(branchName)) continue;
                node = child;
                continue block0;
            }
            child = new DefaultMutableTreeNode(branchName);
            node.add(child);
            node = child;
        }
    }

    public boolean findAndRemoveAllChildren(String name) {
        DefaultMutableTreeNode node = this.root_;
        DefaultMutableTreeNode child = null;
        StringTokenizer path = new StringTokenizer(name, ".");
        block0: while (path.hasMoreElements()) {
            String branchName = (String)path.nextElement();
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                child = (DefaultMutableTreeNode)children.nextElement();
                if (!child.toString().equals(branchName)) continue;
                node = child;
                continue block0;
            }
            return false;
        }
        node.removeAllChildren();
        return true;
    }

    public void run() {
        this.setTitle("Package Tree");
        ((Component)this).setSize(400, 700);
        ((Component)this).setBackground(Color.gray);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add(topPanel);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root_);
        JTree tree = new JTree(treeModel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(tree);
        topPanel.add((Component)scrollPane, "Center");
        ((Component)this).setVisible(true);
        this.setFinished(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Component)PTViewer.this).setVisible(false);
                PTViewer.this.dispose();
                PTViewer.this.setFinished(true);
            }
        });
    }

    private void setFinished(boolean value) {
        this.finished_ = value;
    }

    public boolean isFinished() {
        return this.finished_;
    }
}

