/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.JverClassLoaderSystem;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class JverClassLoaderType
implements Serializable {
    private static final String S_CLT_SYSTEM = "com.sap.tc.jtools.jver.scanner.JverClassLoaderSystem";
    public static final JverClassLoaderType SYSTEM_CLASS_LOADER = new JverClassLoaderType("com.sap.tc.jtools.jver.scanner.JverClassLoaderSystem");
    private static final String S_CLT_URL = "com.sap.tc.jtools.jver.scanner.JverClassLoaderURL";
    public static final JverClassLoaderType URL_CLASS_LOADER = new JverClassLoaderType("com.sap.tc.jtools.jver.scanner.JverClassLoaderURL");
    private final String name_;

    private JverClassLoaderType(String name) {
        this.name_ = name;
    }

    public static JverClassLoaderType registerCustomClassLoader(String name) {
        return new JverClassLoaderType(name);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.name_.equals(S_CLT_SYSTEM)) {
            return SYSTEM_CLASS_LOADER;
        }
        if (this.name_.equals(S_CLT_URL)) {
            return URL_CLASS_LOADER;
        }
        return new JverClassLoaderType(this.name_);
    }

    public IJverClassLoader getLoader(ClassLoader loader) {
        Class<?> loaderClass = null;
        IJverClassLoader loaderInstance = null;
        try {
            loaderClass = Class.forName(this.name_, true, loader);
            loaderInstance = (IJverClassLoader)loaderClass.newInstance();
            return loaderInstance;
        }
        catch (ClassNotFoundException e) {
            DbgLog.println("Could not find " + this.name_ + " in VM classpath: using system class loader.");
            DbgLog.printStackTrace(e);
        }
        catch (Exception e) {
            DbgLog.println(" could not create " + this.name_ + ": using system class loader.");
            DbgLog.printStackTrace(e);
        }
        loaderInstance = new JverClassLoaderSystem();
        return loaderInstance;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0 instanceof JverClassLoaderType) {
            JverClassLoaderType cmp = (JverClassLoaderType)arg0;
            return this.name_.equals(cmp.name_);
        }
        return false;
    }

    public String toString() {
        return this.name_;
    }
}

