/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.remotedriver.tcp;

import com.sap.tc.jtools.jver.core.IJverListener;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.driver.JverDriver;
import com.sap.tc.jtools.jver.driver.JverOption;
import com.sap.tc.jtools.jver.driver.MsgCollector;
import com.sap.tc.jtools.jver.remotedriver.tcp.ArgumentHandler;
import com.sap.tc.jtools.jver.remotedriver.tcp.ListenerStub;
import com.sap.tc.jtools.jver.remotedriver.tcp.StandardOut;
import java.net.URL;

public class Driver
extends JverDriver {
    private static final String INTERNAL_ERROR_MSG = "Internal error. Please submit a bug report.";
    private static final int RC_SYSTEM_ERROR = 4;
    private static final int RC_FLOPS_AND_WARNINGS = 3;
    private static final int RC_WARNINGS = 2;
    private static final int RC_FLOPS = 1;
    private static final int RC_GOOD = 0;
    private ListenerStub fListener = null;
    private boolean fStopRequested = false;
    private boolean fTraceSteps = false;
    private StandardOut fStandardOut = null;

    private Driver(IMsgCollector pCollector, StandardOut pStandardOut, boolean pTrace) {
        super(pCollector);
        this.fStandardOut = pStandardOut;
        this.fTraceSteps = pTrace;
    }

    public static void main(String[] args) {
        int rc = -1;
        StandardOut standardOut = new StandardOut();
        String host = "";
        int port = -1;
        boolean traceSteps = false;
        boolean localMode = false;
        try {
            JverOption curOption = null;
            String[] curTargets = null;
            URL curTaskFileURL = null;
            try {
                ArgumentHandler argHandler = new ArgumentHandler(standardOut);
                argHandler.processArguments(args);
                curOption = argHandler.getOption();
                curTaskFileURL = argHandler.getTaskFileURL();
                curTargets = argHandler.getTestcases();
                host = argHandler.getHost();
                port = argHandler.getPort();
                traceSteps = argHandler.getTraceRequested();
                localMode = argHandler.getLocalRequested();
            }
            catch (IllegalArgumentException badArgsXpt) {
                standardOut.println("exiting due bad argument list with returncode -2");
                System.exit(-2);
            }
            if (traceSteps) {
                int ii = 0;
                while (ii < args.length) {
                    standardOut.printInfo(args[ii]);
                    ++ii;
                }
            }
            rc = Driver.runDriver(curTargets, curTaskFileURL, curOption, standardOut, host, port, traceSteps, localMode);
        }
        catch (InterruptedException e) {
            standardOut.printError(INTERNAL_ERROR_MSG);
            e.printStackTrace(System.err);
            standardOut.println("exiting due to internal error, return code -4");
            rc = -4;
        }
        catch (Throwable throwable) {
            standardOut.printError(INTERNAL_ERROR_MSG);
            throwable.printStackTrace(System.err);
            standardOut.println("exiting due to internal error, return code -3");
            rc = -3;
        }
        System.exit(rc);
    }

    private static int runDriver(String[] pTestsets, URL pTaskFileURL, JverOption pOption, StandardOut pOutput, String pHost, int pPort, boolean pTraceSteps, boolean pLocalMode) throws Throwable {
        MsgCollector collector;
        ListenerStub listener = null;
        Driver driver = null;
        String step = "";
        try {
            step = "create listener";
            if (pTraceSteps) {
                pOutput.printInfo(step);
                listener = new ListenerStub(pHost, pPort, pOutput, pLocalMode);
            } else {
                listener = new ListenerStub(pHost, pPort, null, pLocalMode);
            }
        }
        catch (Throwable failure) {
            pOutput.println(step + " failed:" + failure.getMessage());
            throw failure;
        }
        try {
            step = "initializing driver";
            if (pTraceSteps) {
                pOutput.printInfo("initializing driver");
            }
            collector = new MsgCollector();
            driver = new Driver(collector, pOutput, pTraceSteps);
            driver.fListener = listener;
            driver.setClassLoaderParent(Thread.currentThread().getContextClassLoader());
            driver.configure(pOption);
        }
        catch (Throwable failure) {
            pOutput.println("failed" + failure.getMessage());
            throw failure;
        }
        try {
            step = "try to establish connection";
            if (pTraceSteps) {
                pOutput.printInfo(step);
            }
            listener.connect(driver);
        }
        catch (Throwable failure) {
            pOutput.println(step + " failed:" + failure.getMessage());
            driver.logThrowable(INTERNAL_ERROR_MSG, failure);
            if (null != collector) {
                collector.logFinish();
            }
            return 4;
        }
        try {
            long milliStart = System.currentTimeMillis();
            step = "executing testjob";
            if (pTraceSteps) {
                pOutput.printInfo(step);
            }
            if (null == pTaskFileURL) {
                driver.runTestList(pTestsets);
            } else {
                String pTaskFileName = pTaskFileURL.getFile();
                if (pTraceSteps) {
                    pOutput.printInfo("using task file " + pTaskFileName);
                }
                driver.runTestTask(pTaskFileName);
            }
            if (driver.fStopRequested) {
                listener.announceMyTestTaskAbortion(System.currentTimeMillis() - milliStart);
            } else {
                listener.announceMyTestTaskCompletion(System.currentTimeMillis() - milliStart);
            }
        }
        catch (Throwable failure) {
            pOutput.println(step + " failed:" + failure.getMessage());
            JverProcessException procXpt = new JverProcessException(failure, "Job Termination", "TCP-DRIVER-00");
            listener.announceMyTestTaskTermination(procXpt);
            driver.logThrowable(INTERNAL_ERROR_MSG, failure);
            try {
                Thread.sleep(200L);
                Object var16_20 = null;
                listener.disconnect();
                collector.logFinish();
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                listener.disconnect();
                collector.logFinish();
                throw throwable;
            }
            return 4;
        }
        try {
            step = "commencing shutdown";
            if (pTraceSteps) {
                pOutput.printInfo(step);
            }
            listener.disconnect();
            collector.logFinish();
        }
        catch (Throwable failure) {
            pOutput.println(step + " failed:" + failure.getMessage());
            driver.logThrowable(INTERNAL_ERROR_MSG, failure);
            return 4;
        }
        if (0 != collector.getFlopCount()) {
            if (0 != collector.getWarningCount()) {
                return 3;
            }
            return 1;
        }
        if (0 != collector.getWarningCount()) {
            return 2;
        }
        return 0;
    }

    void requestHalt() {
        if (this.fTraceSteps && null != this.fStandardOut) {
            this.fStandardOut.println("halt requested!");
        }
        super.requestAbortion();
        this.fStopRequested = true;
    }

    protected IJverListener getStandardListener() {
        return this.fListener;
    }
}

