/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.core.AJverProcessException;
import com.sap.tc.jtools.jver.core.AJverRuntimeException;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.driver.performance.PerfExecStateMT;
import com.sap.tc.jtools.jver.driver.performance.PerfFlopBreakException;
import com.sap.tc.jtools.jver.driver.performance.PerfMsgCollectorMT;
import com.sap.tc.jtools.jver.driver.performance.PerfResultMT;
import com.sap.tc.jtools.jver.driver.performance.PerfTestDescription;
import com.sap.tc.jtools.jver.driver.performance.PerfWarningBreakException;
import com.sap.tc.jtools.jver.framework.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PerfTestThreadMT
implements Runnable {
    private Test fTest;
    private final PerfTestDescription fTestDescription;
    private final PerfResultMT fResult;
    private volatile boolean fCancelRequested = false;

    public PerfTestThreadMT(PerfTestDescription testDescription, Test testObject) {
        this.fTestDescription = testDescription;
        this.fTest = testObject;
        this.fResult = new PerfResultMT();
        this.fCancelRequested = false;
    }

    protected final PerfResultMT getResult() {
        return this.fResult;
    }

    protected final void requestCancel() {
        this.fCancelRequested = true;
    }

    public void run() {
        try {
            try {
                this.fResult.fState = PerfExecStateMT.STATE_STARTED;
                this.execute();
            }
            catch (InterruptedException iEx) {
                this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                Object var3_2 = null;
                if (PerfExecStateMT.STATE_STARTED == this.fResult.fState) {
                    this.fResult.fState = PerfExecStateMT.STATE_ILLEGAL;
                }
            }
            Object var3_1 = null;
            if (PerfExecStateMT.STATE_STARTED == this.fResult.fState) {
                this.fResult.fState = PerfExecStateMT.STATE_ILLEGAL;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (PerfExecStateMT.STATE_STARTED == this.fResult.fState) {
                this.fResult.fState = PerfExecStateMT.STATE_ILLEGAL;
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private void execute() throws InterruptedException {
        Class fClass = this.fTestDescription.getTestClass();
        Method fMethod = this.fTestDescription.getMethod();
        IJverFixture fFixture = this.fTestDescription.getFixture();
        long fRepetitions = this.fTestDescription.getRepetitions();
        ((PerfMsgCollectorMT)fFixture.getMsgCollector()).resetState();
        long testStart = System.currentTimeMillis();
        long jj = fRepetitions;
        while (jj > 0L && !this.fCancelRequested) {
            block40: {
                this.fTest = fFixture.beginTestMethod(fClass, this.fTest);
                fMethod.invoke((Object)this.fTest, (Object[])new Class[0]);
                Object var16_7 = null;
                try {
                    fFixture.finishTestMethod(this.fTest);
                }
                catch (InterruptedException e) {
                    if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                        this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                    }
                    break block40;
                }
                catch (Exception e) {
                    if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                        this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                    }
                    break block40;
                }
                {
                    catch (InterruptedException iEx) {
                        block41: {
                            this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                            var16_7 = null;
                            try {
                                fFixture.finishTestMethod(this.fTest);
                            }
                            catch (InterruptedException e) {
                                if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                                    this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                                }
                            }
                            catch (Exception e) {
                                if (this.fResult.fState != PerfExecStateMT.STATE_STARTED) break block41;
                                this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                            }
                        }
                        return;
                    }
                    catch (InvocationTargetException tEx) {
                        block42: {
                            Throwable methEx = tEx.getTargetException();
                            if (null == methEx || !(methEx instanceof Exception)) {
                                methEx = tEx;
                            }
                            if (methEx instanceof PerfFlopBreakException) {
                                this.fResult.fState = PerfExecStateMT.STATE_TESTCASE_FLOP;
                                this.fResult.fXpt = ((PerfFlopBreakException)methEx).getFlop();
                            } else if (methEx instanceof PerfWarningBreakException) {
                                this.fResult.fState = PerfExecStateMT.STATE_TESTCASE_WARN;
                                this.fResult.fXpt = ((PerfWarningBreakException)methEx).getWarning();
                            } else if (methEx instanceof InterruptedException) {
                                this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                            } else {
                                this.fResult.fState = PerfExecStateMT.STATE_TESTCASE_ERROR;
                                this.fResult.fXpt = (Exception)methEx;
                            }
                            var16_7 = null;
                            try {
                                fFixture.finishTestMethod(this.fTest);
                            }
                            catch (InterruptedException e) {
                                if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                                    this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                                }
                            }
                            catch (Exception e) {
                                if (this.fResult.fState != PerfExecStateMT.STATE_STARTED) break block42;
                                this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                            }
                        }
                        return;
                    }
                    catch (AJverRuntimeException jEx) {
                        block43: {
                            this.fResult.fState = PerfExecStateMT.STATE_TESTCASE_ERROR;
                            this.fResult.fXpt = jEx;
                            var16_7 = null;
                            try {
                                fFixture.finishTestMethod(this.fTest);
                            }
                            catch (InterruptedException e) {
                                if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                                    this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                                }
                            }
                            catch (Exception e) {
                                if (this.fResult.fState != PerfExecStateMT.STATE_STARTED) break block43;
                                this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                            }
                        }
                        return;
                    }
                    catch (AJverProcessException jEx) {
                        block44: {
                            this.fResult.fState = PerfExecStateMT.STATE_TESTCASE_ERROR;
                            this.fResult.fXpt = jEx;
                            var16_7 = null;
                            try {
                                fFixture.finishTestMethod(this.fTest);
                            }
                            catch (InterruptedException e) {
                                if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                                    this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                                }
                            }
                            catch (Exception e) {
                                if (this.fResult.fState != PerfExecStateMT.STATE_STARTED) break block44;
                                this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                            }
                        }
                        return;
                    }
                    catch (Throwable gEx) {
                        block45: {
                            this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                            this.fResult.fXpt = gEx;
                            var16_7 = null;
                            try {
                                fFixture.finishTestMethod(this.fTest);
                            }
                            catch (InterruptedException e) {
                                if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                                    this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                                }
                            }
                            catch (Exception e) {
                                if (this.fResult.fState != PerfExecStateMT.STATE_STARTED) break block45;
                                this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    block46: {
                        var16_7 = null;
                        try {
                            fFixture.finishTestMethod(this.fTest);
                        }
                        catch (InterruptedException e) {
                            if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
                                this.fResult.fState = PerfExecStateMT.STATE_INTERRUPTED;
                            }
                        }
                        catch (Exception e) {
                            if (this.fResult.fState != PerfExecStateMT.STATE_STARTED) break block46;
                            this.fResult.fState = PerfExecStateMT.STATE_RUNTIME_ERROR;
                        }
                    }
                    throw throwable;
                }
            }
            --jj;
        }
        this.fResult.setDurationMilliSeconds(System.currentTimeMillis() - testStart);
        if (this.fResult.fState == PerfExecStateMT.STATE_STARTED) {
            this.fResult.fState = this.fCancelRequested ? PerfExecStateMT.STATE_CANCELLED : PerfExecStateMT.STATE_SUCCESS;
        }
    }
}

