/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.driver.IJverFixture;
import java.lang.reflect.Method;

public final class PerfTestDescription {
    private long fMaxMillis;
    public static final long NO_TIME_LIMIT = -1L;
    private long fRepetitions;
    private long fTotalDuration;
    private final int fNumThreads;
    private final Class fTestClass;
    private IJverFixture fFixture;
    private final Method fMethod;
    static final int MAX_THREADS = 100;
    static final long MAX_REPETITIONS = 10000000L;
    private static long fgThgCount = 0L;

    public PerfTestDescription(Class pTestClass, Method pMethod, IJverFixture pfixture, long pRepetions, long pMaxMillis, int pNumThreads) {
        this.fMaxMillis = pMaxMillis;
        this.fNumThreads = 100 < pNumThreads ? 100 : (1 > pNumThreads ? 1 : pNumThreads);
        this.fTotalDuration = -1L;
        this.fMethod = pMethod;
        this.fTestClass = pTestClass;
        this.fFixture = pfixture;
        this.setRepetitions(pRepetions);
    }

    public long getRepetitions() {
        return this.fRepetitions;
    }

    public void setRepetitions(long pRepetitions) {
        this.fRepetitions = 10000000L < pRepetitions ? pRepetitions : (1L > pRepetitions ? 1L : pRepetitions);
    }

    public int getNumThreads() {
        return this.fNumThreads;
    }

    public Method getMethod() {
        return this.fMethod;
    }

    public String getMethodName() {
        return this.fMethod.getName();
    }

    public long getMaxMillis() {
        return this.fMaxMillis;
    }

    public long getTotalDuration() {
        return this.fTotalDuration;
    }

    public void setTotalDuration(long pTotalDuration) {
        this.fTotalDuration = pTotalDuration;
    }

    public Class getTestClass() {
        return this.fTestClass;
    }

    public IJverFixture getFixture() {
        return this.fFixture;
    }

    public String getFullName() {
        String className = this.getTestClass().getName();
        String methodName = this.getMethodName();
        int len = className.length() + methodName.length() + 4;
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(className);
        buffer.append('.');
        buffer.append(methodName);
        buffer.append("()");
        return buffer.toString();
    }
}

