/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverLogPerf;
import com.sap.tc.jtools.jver.core.JverPerformanceException;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.driver.performance.PerfConfig;
import com.sap.tc.jtools.jver.driver.performance.PerfResultMT;
import com.sap.tc.jtools.jver.driver.performance.PerfTestDescription;
import com.sap.tc.jtools.jver.framework.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class APerfTestRun {
    protected final long fMicroMult = 1000L;
    private final String fMicroUnit = " \u00b5s";
    private final String fMilliUnit = " ms";
    protected IMsgCollector msgCollector_;
    protected PerfConfig config_;

    public APerfTestRun(IMsgCollector msgCollector, PerfConfig config) {
        this.msgCollector_ = msgCollector;
        this.config_ = config;
    }

    public void runPerfTest(Test testObject, Method refMethod, PerfTestDescription description) throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InterruptedException, Exception {
        this.msgCollector_.announceTestStart("perf:" + description.getMethodName());
        IJverFixture fixture = this.getPerfTestFixture(description.getFixture());
        PerfTestDescription refDescription = new PerfTestDescription(description.getTestClass(), refMethod, fixture, description.getRepetitions(), -1L, 1);
        this.garbageCollect();
        IPerfResult refResult = this.execTestMethod(refDescription, testObject);
        long refGcMillis = System.currentTimeMillis();
        System.gc();
        refGcMillis = System.currentTimeMillis() - refGcMillis;
        this.garbageCollect();
        IPerfResult perfResult = this.execTestMethod(description, testObject);
        long curGcMillis = System.currentTimeMillis();
        System.gc();
        curGcMillis = System.currentTimeMillis() - curGcMillis;
        boolean success = this.evalResult(description, perfResult, refResult, curGcMillis, refGcMillis);
        this.msgCollector_.announceTestEnd(success);
        JverLogPerf.println("");
    }

    protected IJverFixture getPerfTestFixture(IJverFixture fixture) {
        return fixture;
    }

    protected abstract IPerfResult execTestMethod(PerfTestDescription var1, Test var2) throws InterruptedException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception;

    protected abstract boolean evalResult(PerfTestDescription var1, IPerfResult var2, IPerfResult var3, long var4, long var6);

    private void garbageCollect() throws InterruptedException {
        System.runFinalization();
        System.gc();
        if (0 < this.config_.getGcSleepAfter()) {
            Thread.sleep(this.config_.getGcSleepAfter());
        } else {
            Thread.sleep(5L);
        }
    }

    protected void performanceWarning(String msg, String id) {
        JverPerformanceException pe = new JverPerformanceException(msg, id);
        this.msgCollector_.add(pe);
    }

    protected String formatMilliSeconds(long millis) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Long.toString(millis));
        buffer.append(' ');
        buffer.append(" ms");
        return buffer.toString();
    }

    protected String formatMicroSeconds(long micros) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Long.toString(micros));
        buffer.append(' ');
        buffer.append(" \u00b5s");
        return buffer.toString();
    }

    static interface IPerfResult {
        public long getDurationMilliSecs();

        public PerfResultMT[] getResultArray();
    }
}

