/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.IJverPrinter;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.scanner.JverClassLoaderType;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class JverOption
implements Serializable {
    private static String selfTestPath_ = "";
    private boolean verbose_ = false;
    private boolean silent_ = false;
    private boolean classTargets_ = false;
    private boolean isJverTask = false;
    private boolean parametersFromFile_ = false;
    private boolean preselection_ = false;
    private boolean performanceTest_ = false;
    private boolean xmlOutput_ = false;
    private JverClassLoaderType classLoaderType_ = JverClassLoaderType.SYSTEM_CLASS_LOADER;
    private String customClassLoaderName_ = null;
    private Vector additionalListenerNames_ = null;
    private String jverTaskFileName_ = "";
    private String parametersFromThisFile_ = "";
    private String addPath_ = "";
    private String dbgLogFile_ = "jver_log.txt";
    private String userLogFile_ = null;
    private String perfLogFile_ = null;
    private String jverConfigFile_ = null;
    private String customListenerName_ = null;
    private String[] additionalStackFilter_ = null;

    public void log(IJverPrinter printer) {
        if (printer != null) {
            printer.println("");
            printer.println("----- driver options ----> ");
            printer.println("verbose: " + this.value(this.isVerbose()));
            printer.println("silent: " + this.value(this.isSilent()));
            printer.println("class targets: " + this.value(this.isClassTargets()));
            printer.println("jver task run: " + this.value(this.isJverTask()));
            printer.println("jver task file: " + this.getJverTaskFileName());
            printer.println("parameter from file: " + this.value(this.isParametersFromFile()));
            printer.println("parameter file: " + this.getParametersFromThisFile());
            printer.println("preselection: " + this.value(this.isPreselection()));
            printer.println("xml output: " + this.value(this.isXmlOutput()));
            printer.println("performance test: " + this.value(this.isPerformanceTest()));
            printer.println("class loader type: " + this.getClassLoaderType().toString());
            printer.println("add path: " + this.getAdditionalPath());
            printer.println("debug log file: " + this.getDbgLogFile());
            printer.println("perf log file: " + this.getPerfLogFile());
            printer.println("user log file: " + this.getUserLogFile());
            printer.println("jver config file: " + this.getJverConfigFile());
            printer.println("custom listener: " + this.getCustomListenerName());
            Vector vAddListeners = this.getAdditionalListenerNames();
            if (vAddListeners != null) {
                Iterator addListeners = ((AbstractList)vAddListeners).iterator();
                while (addListeners.hasNext()) {
                    printer.println("add.listener: " + addListeners.next().toString());
                }
            }
            if (selfTestPath_.length() > 0) {
                printer.println("selfTestPath: " + JverOption.getSelfTestPath());
            }
            printer.println("<------------------------- ");
            printer.println("");
        }
    }

    public boolean isVerbose() {
        return this.verbose_;
    }

    public boolean isSilent() {
        return this.silent_;
    }

    public boolean isClassTargets() {
        return this.classTargets_;
    }

    public boolean isJverTask() {
        return this.isJverTask;
    }

    public boolean isParametersFromFile() {
        return this.parametersFromFile_;
    }

    protected boolean isPreselection() {
        return this.preselection_;
    }

    public boolean isXmlOutput() {
        return this.xmlOutput_;
    }

    protected boolean isPerformanceTest() {
        return this.perfLogFile_ != null && this.perfLogFile_.length() > 0;
    }

    public String getJverTaskFileName() {
        return this.jverTaskFileName_;
    }

    public String getParametersFromThisFile() {
        return this.parametersFromThisFile_;
    }

    public String getAdditionalPath() {
        return this.addPath_;
    }

    public String getDbgLogFile() {
        return this.dbgLogFile_;
    }

    public String getPerfLogFile() {
        return this.perfLogFile_;
    }

    public String getUserLogFile() {
        return this.userLogFile_;
    }

    public String getJverConfigFile() {
        return this.jverConfigFile_;
    }

    protected JverClassLoaderType getClassLoaderType() {
        return this.classLoaderType_;
    }

    protected String getCustomClassLoaderName() {
        return this.customClassLoaderName_;
    }

    public String getCustomListenerName() {
        return this.customListenerName_;
    }

    Vector getAdditionalListenerNames() {
        return this.additionalListenerNames_;
    }

    public void setVerbose(boolean value) {
        this.verbose_ = value;
        this.silent_ = !value;
    }

    public void setSilent(boolean value) {
        this.silent_ = value;
        this.verbose_ = !value;
    }

    public void setClassTargets(boolean value) {
        this.classTargets_ = value;
    }

    public void setParametersFromFile(boolean value) {
        this.parametersFromFile_ = value;
    }

    public void setPreselection(boolean value) {
        this.preselection_ = value;
    }

    public void setClassLoaderType(JverClassLoaderType value) {
        this.classLoaderType_ = value;
    }

    public void setXmlOutput(boolean value) {
        this.xmlOutput_ = value;
    }

    public void setTaskFromFile(String value) {
        this.isJverTask = true;
        this.jverTaskFileName_ = this.safeTrim(value);
    }

    public void setParametersFromThisFile(String value) {
        this.parametersFromThisFile_ = this.safeTrim(value);
    }

    public void setAdditionalPath(String path) {
        this.addPath_ = this.safeTrim(path);
        if (path != null && path.length() > 0 && this.getClassLoaderType().equals(JverClassLoaderType.SYSTEM_CLASS_LOADER)) {
            this.setClassLoaderType(JverClassLoaderType.URL_CLASS_LOADER);
        }
    }

    public void setDbgLogFile(String value) {
        this.dbgLogFile_ = this.safeTrim(value);
    }

    public void setPerfLogFile(String value) {
        this.perfLogFile_ = this.safeTrim(value);
    }

    public void setUserLogFile(String value) {
        this.userLogFile_ = this.safeTrim(value);
    }

    public void setJverConfigFile(String value) {
        this.jverConfigFile_ = this.safeTrim(value);
    }

    public void setCustomListenerName(String value) {
        this.customListenerName_ = this.safeTrim(value);
    }

    public void addCustomListenerName(String value) {
        if (this.additionalListenerNames_ == null) {
            this.additionalListenerNames_ = new Vector(3);
        }
        this.additionalListenerNames_.add(this.safeTrim(value));
    }

    public void setAdditionalStackFilter(String[] additionalFilter) {
        this.additionalStackFilter_ = additionalFilter;
    }

    public String[] getAdditionalStackFilter() {
        return this.additionalStackFilter_;
    }

    public static String getSelfTestPath() {
        return selfTestPath_;
    }

    public static void setSelfTestPath(String value) {
        selfTestPath_ = value != null ? value.trim() : null;
    }

    public static void setSelfTest(boolean value) {
        JverConfig.setSelfTest(value);
    }

    private String safeTrim(String value) {
        return value != null ? value.trim() : null;
    }

    public boolean isAlternativeScanner() {
        return false;
    }

    public String getAlternativeScannerName() {
        return "";
    }

    private String value(boolean bool) {
        return bool ? "true" : "false";
    }
}

