/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverFlopException;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.core.JverRuntimeException;
import com.sap.tc.jtools.jver.driver.AJverMethodRunner;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.driver.IJverDriverState;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.framework.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;

class JverMethodRunnerStd
extends AJverMethodRunner {
    private final IJverDriverState driverState_;

    public JverMethodRunnerStd(IMsgCollector msgCollector, IJverDriverState state) {
        super(msgCollector);
        this.driverState_ = state;
    }

    public Enumeration getTestMethods() {
        return this.getTestMethodEnumeration();
    }

    private MethodRunnerEnumeration getTestMethodEnumeration() {
        if (this.getTestAttributes().hasTestSet()) {
            return this.getTestMethodsFromAttributes();
        }
        return this.getTestMethodsByReflection();
    }

    public int getTestMethodCount() {
        MethodRunnerEnumeration methods = this.getTestMethodEnumeration();
        return methods.getLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runTestMethods() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ExceptionInInitializerError, Exception {
        Test testObject = null;
        IJverFixture fixture = this.getTestFixture();
        try {
            Class testClass = this.getTestClass();
            testObject = fixture.beginTestSet(testClass);
            Enumeration e = this.getTestMethods();
            Method test = null;
            while (true) {
                Object var7_6;
                block8: {
                    block7: {
                        if (!e.hasMoreElements()) break block7;
                        if (!this.driverState_.isAbortionRequested()) break block8;
                    }
                    Object var9_8 = null;
                    break;
                }
                testObject = fixture.beginTestMethod(testClass, testObject);
                try {
                    test = (Method)e.nextElement();
                    this.runTestMethod(testObject, test);
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    fixture.finishTestMethod(testObject);
                    throw throwable;
                }
                fixture.finishTestMethod(testObject);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fixture.finishTestSet(testObject);
            throw throwable;
        }
        fixture.finishTestSet(testObject);
    }

    private void runTestMethod(Test testObject, Method testMethod) throws IllegalAccessException, InvocationTargetException, ExceptionInInitializerError {
        block27: {
            String methodName = testMethod.getName();
            DbgLog.println("->" + methodName);
            boolean success = false;
            boolean skipped = false;
            int countTolerant = 0;
            try {
                try {
                    this.msgCollector_.announceTestStart(methodName);
                    skipped = false;
                    countTolerant = this.msgCollector_.getTolerantFlopCount();
                    testMethod.invoke((Object)testObject, (Object[])AJverMethodRunner.noArg_);
                    success = this.msgCollector_.getTolerantFlopCount() == countTolerant;
                }
                catch (InvocationTargetException e) {
                    Throwable eTarget = e.getTargetException();
                    if (eTarget instanceof JverFlopException) {
                        JverFlopException jverException = (JverFlopException)eTarget;
                        int level = jverException.getLevel();
                        if (level == 2) {
                            this.msgCollector_.addFlop(jverException);
                        } else {
                            if (level == 3) {
                                this.msgCollector_.addFlop(jverException);
                                throw e;
                            }
                            if (level != 1) {
                                JverProcessException pe = new JverProcessException(IJverDriverMsg.WRONG_VERI_LEVEL, (Object)Integer.toString(level), (Object)jverException.toString());
                                this.msgCollector_.addWarning(pe);
                            }
                        }
                    } else if (eTarget instanceof JverProcessException) {
                        this.msgCollector_.addWarning((JverProcessException)eTarget);
                    } else if (eTarget instanceof JverRuntimeException) {
                        JverProcessException pe = new JverProcessException((JverRuntimeException)eTarget);
                        this.msgCollector_.addWarning(pe);
                    } else {
                        String msg = "exception in test";
                        JverFlopException flop = new JverFlopException(eTarget, "exception in test", null);
                        this.msgCollector_.addFlop(flop);
                    }
                    Object var13_8 = null;
                    if (skipped) {
                        this.msgCollector_.announceTestSkip(methodName);
                    } else {
                        this.msgCollector_.announceTestEnd(success);
                    }
                    if (!success) {
                        this.setErrorFlag();
                    }
                    break block27;
                }
                catch (IllegalArgumentException e) {
                    skipped = true;
                    String name = testObject.getClass().getName();
                    name = name + "." + methodName;
                    IJverDriverMsg.ILLEGAL_ARGUMENT.add(this.msgCollector_, e, name);
                    Object var13_9 = null;
                    if (skipped) {
                        this.msgCollector_.announceTestSkip(methodName);
                    } else {
                        this.msgCollector_.announceTestEnd(success);
                    }
                    if (!success) {
                        this.setErrorFlag();
                    }
                }
                Object var13_7 = null;
                if (skipped) {
                    this.msgCollector_.announceTestSkip(methodName);
                } else {
                    this.msgCollector_.announceTestEnd(success);
                }
                if (!success) {
                    this.setErrorFlag();
                }
            }
            catch (Throwable throwable) {
                Object var13_10 = null;
                if (skipped) {
                    this.msgCollector_.announceTestSkip(methodName);
                } else {
                    this.msgCollector_.announceTestEnd(success);
                }
                if (!success) {
                    this.setErrorFlag();
                }
                throw throwable;
            }
        }
    }

    private MethodRunnerEnumeration getTestMethodsFromAttributes() {
        return new MethodRunnerEnumeration(){
            private int index_ = 0;
            private String[] list_ = JverMethodRunnerStd.this.getTestAttributes().getTestSet();
            private Method next_ = null;

            public boolean hasMoreElements() {
                while (this.index_ < this.list_.length && this.next_ == null) {
                    String name = this.list_[this.index_];
                    try {
                        this.next_ = JverMethodRunnerStd.this.getTestClass().getMethod(name, AJverMethodRunner.noArg_);
                    }
                    catch (NoSuchMethodException e) {
                        IJverDriverMsg.NO_SUCH_METHOD.add(JverMethodRunnerStd.this.msgCollector_, name);
                    }
                    ++this.index_;
                }
                return this.next_ != null;
            }

            private Method nextMethod() {
                Method nextMethod = this.next_;
                this.next_ = null;
                return nextMethod;
            }

            public Object nextElement() {
                return this.nextMethod();
            }

            public int getLength() {
                return this.list_.length;
            }
        };
    }

    private MethodRunnerEnumeration getTestMethodsByReflection() {
        return new MethodRunnerEnumeration(){
            private final Method[] am;
            private int index_;
            private int length_;
            {
                this.am = JverMethodRunnerStd.this.getTestClass().getMethods();
                this.index_ = 0;
                this.length_ = -1;
            }

            public boolean hasMoreElements() {
                boolean foundTestMethod = false;
                while (this.index_ < this.am.length) {
                    foundTestMethod = JverMethodRunnerStd.this.isTestMethod(this.am[this.index_]);
                    if (foundTestMethod) break;
                    ++this.index_;
                }
                return foundTestMethod;
            }

            private Method nextMethod() {
                Method next = this.am[this.index_];
                ++this.index_;
                return next;
            }

            public Object nextElement() {
                return this.nextMethod();
            }

            public int getLength() {
                if (this.length_ == -1) {
                    this.length_ = 0;
                    int ii = 0;
                    while (ii < this.am.length) {
                        if (JverMethodRunnerStd.this.isTestMethod(this.am[ii])) {
                            ++this.length_;
                        }
                        ++ii;
                    }
                }
                return this.length_;
            }
        };
    }

    private boolean isTestMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return method.getName().startsWith("test") && returnType.equals(Void.TYPE);
    }

    private static interface MethodRunnerEnumeration
    extends Enumeration {
        public int getLength();
    }
}

