/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.JverVersion;
import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IJverListener;
import com.sap.tc.jtools.jver.core.IJverPrinter;
import com.sap.tc.jtools.jver.core.IJverTestAttributesInternal;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.core.JverLogPerf;
import com.sap.tc.jtools.jver.core.JverPrinter;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.core.JverRuntimeException;
import com.sap.tc.jtools.jver.driver.AJverListener;
import com.sap.tc.jtools.jver.driver.IJverDriver;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.driver.JverClassManager;
import com.sap.tc.jtools.jver.driver.JverListenerConcise;
import com.sap.tc.jtools.jver.driver.JverListenerSilent;
import com.sap.tc.jtools.jver.driver.JverListenerVerbose;
import com.sap.tc.jtools.jver.driver.JverListenerXml;
import com.sap.tc.jtools.jver.driver.JverListenerXmlVerbose;
import com.sap.tc.jtools.jver.driver.JverOption;
import com.sap.tc.jtools.jver.driver.JverTestClassRunner;
import com.sap.tc.jtools.jver.driver.MsgCollector;
import com.sap.tc.jtools.jver.scanner.IJverClassEnumeration;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.JverCheckTestClass;
import com.sap.tc.jtools.jver.scanner.JverClassLoaderType;
import com.sap.tc.jtools.jver.scanner.JverTargetVector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class JverDriver
implements IJverDriver {
    private File currentTestClassParameterFile_ = null;
    private boolean NoTestRunYet_ = true;
    protected IMsgCollector collector_ = null;
    private boolean isConfigured_ = false;
    private Class currentTestClass_ = null;
    private IJverTestAttributesInternal currentAttributes_ = null;
    private JverConfig config_ = null;
    private Enumeration currentSelection_ = null;
    private JverTestClassRunner runner_ = null;
    private JverOption option = null;
    private boolean isFinished = true;
    private IJverClassLoader jverClassLoader_ = null;
    private Properties commonTestParameter_ = null;
    private boolean isAbortionRequested_ = false;
    private ClassLoader parentClassLoader_;
    protected String dbgLogFileName_ = null;
    private IJverPrinter stdOutputChannel = new JverPrinter(System.out);
    private String saveCmdLine_;
    static /* synthetic */ Class class$com$sap$tc$jtools$jver$framework$Test;

    public JverDriver() {
        this.collector_ = new MsgCollector();
    }

    public JverDriver(IMsgCollector collector) {
        this.collector_ = collector;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.finish();
    }

    public static int getVersionRelease() {
        return 0;
    }

    public static int getVersionMajor() {
        return 29;
    }

    public static int getVersionPatch() {
        return 0;
    }

    public static String getVersion() {
        return JverVersion.VERSION;
    }

    public void configure() throws JverProcessException {
        this.configure(new JverOption());
        DbgLog.println("Driver default configuration");
    }

    public void configure(JverOption option) throws JverProcessException {
        this.setConfigured();
        this.setOption(option);
        String logFileName = option.getDbgLogFile();
        if (logFileName != null) {
            try {
                this.dbgLogFileName_ = DbgLog.init(logFileName, false);
                DbgLog.println("JVer - " + JverVersion.VERSION);
                if (this.saveCmdLine_ != null) {
                    DbgLog.println(this.saveCmdLine_);
                }
                this.collector_.addInfo("Debuglog written to: " + this.dbgLogFileName_);
            }
            catch (IOException e) {
                IJverDriverMsg.LOGFILE_IO_EXCEPTION.add(this.collector_, e);
            }
        }
        option.log(DbgLog.getPrintWriter());
        logFileName = option.getPerfLogFile();
        if (logFileName != null) {
            try {
                String logFile = JverLogPerf.init(logFileName);
                this.collector_.addInfo("Performance log written to: " + logFile);
            }
            catch (IOException e) {
                IJverDriverMsg.LOGFILE_IO_EXCEPTION.add(this.collector_, e);
            }
        }
        this.isFinished = false;
        logFileName = option.getUserLogFile();
        if (logFileName != null) {
            this.collector_.logInit(logFileName, false);
        }
        JverClassLoaderType classLoaderType = option.getClassLoaderType();
        ClassLoader driverClassLoader = this.getClass().getClassLoader();
        this.jverClassLoader_ = classLoaderType.getLoader(driverClassLoader);
        if (this.parentClassLoader_ == null) {
            this.parentClassLoader_ = driverClassLoader;
        }
        this.jverClassLoader_.setParentClassLoader(this.parentClassLoader_);
        ClassLoader loader = this.jverClassLoader_.getClassLoader(option.getAdditionalPath());
        DbgLog.println("Class Loader Type:   " + classLoaderType);
        DbgLog.println("Class Loader Parent: " + (this.parentClassLoader_ == null ? "null" : this.parentClassLoader_.toString()));
        DbgLog.println("Class Loader:        " + loader.toString());
        if (classLoaderType == JverClassLoaderType.URL_CLASS_LOADER) {
            DbgLog.println("Additional load path:" + option.getAdditionalPath());
        }
        this.config_ = new JverConfig();
        this.config_.init(loader, option.getJverConfigFile());
        if (!this.collector_.hasListener()) {
            this.configureListener(this.jverClassLoader_);
        }
        this.runner_ = new JverTestClassRunner(this.collector_, this);
        this.runner_.setPerformanceTest(option.isPerformanceTest());
        if (option.isParametersFromFile()) {
            try {
                InputStream in = null;
                String parameterFileName = option.getParametersFromThisFile();
                File parameterFile = new File(parameterFileName);
                if (parameterFile.isAbsolute()) {
                    if (parameterFile.exists() && parameterFile.isFile()) {
                        in = new FileInputStream(parameterFile);
                    } else {
                        IJverDriverMsg.NO_SUCH_PARAMFILE.add(this.collector_, parameterFileName);
                    }
                } else {
                    String addPath = option.getAdditionalPath();
                    in = this.jverClassLoader_.getResourceAsStream(parameterFileName, addPath);
                }
                DbgLog.print(in == null ? "Could not read '" : "Use '");
                DbgLog.print(parameterFileName);
                DbgLog.println("' for default parameter initialisation!");
                if (in != null) {
                    this.commonTestParameter_ = new Properties();
                    this.commonTestParameter_.load(in);
                }
            }
            catch (IOException e) {
                IJverDriverMsg.PARAMFILE_IO_ERROR.add(this.collector_, e);
            }
            catch (JverRuntimeException e) {
                this.collector_.addWarning(new JverProcessException(e));
            }
        }
    }

    public void runSingleTestSet(String name) {
        block9: {
            boolean firstEntry = this.enterDriver();
            if (firstEntry) {
                this.collector_.announceTestTaskStart(1);
            }
            try {
                block8: {
                    try {
                        this.checkConfigured();
                        if (!this.loadTestClass(name)) break block8;
                        this.runCurrentTestClass();
                    }
                    catch (JverProcessException e) {
                        this.collector_.addWarning(e);
                        Object var6_4 = null;
                        this.exitDriver(firstEntry);
                        break block9;
                    }
                    catch (ClassNotFoundException e) {
                        if (name.length() > 0 && name.endsWith(".java")) {
                            IJverDriverMsg.CLASS_NOT_FOUND_JAVA.add(this.collector_, name);
                        } else {
                            IJverDriverMsg.CLASS_NOT_FOUND.add(this.collector_, name);
                        }
                        Object var6_5 = null;
                        this.exitDriver(firstEntry);
                    }
                }
                Object var6_3 = null;
                this.exitDriver(firstEntry);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.exitDriver(firstEntry);
                throw throwable;
            }
        }
    }

    public int runTests(String[] targets, JverOption option) {
        boolean firstEntry = this.enterDriver();
        try {
            block7: {
                try {
                    this.configure(option);
                    if (option.isJverTask()) {
                        String listFileName = option.getJverTaskFileName();
                        if (targets != null && targets.length > 0) {
                            IJverDriverMsg.USE_TASK_IGNORE_OTHER.add(this.collector_, listFileName);
                        }
                        this.runTestTask(listFileName);
                        break block7;
                    }
                    if (targets != null && targets.length > 0) {
                        this.runTestList(targets);
                        break block7;
                    }
                    IJverDriverMsg.NO_TARGET.add(this.collector_);
                }
                catch (JverProcessException e) {
                    this.collector_.addWarning(e);
                    Object var6_7 = null;
                    this.exitDriver(firstEntry);
                }
            }
            Object var6_6 = null;
            this.exitDriver(firstEntry);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.exitDriver(firstEntry);
            throw throwable;
        }
        return this.getJverReturnCode();
    }

    public void runTestList(String[] targets) {
        boolean firstEntry = this.enterDriver();
        try {
            try {
                this.checkConfigured();
                JverTargetVector targetSets = new JverTargetVector();
                targetSets.readList(targets);
                this.runTestsTargetVector(targetSets);
            }
            catch (JverProcessException e) {
                this.collector_.addWarning(e);
                Object var5_6 = null;
                this.exitDriver(firstEntry);
            }
            Object var5_5 = null;
            this.exitDriver(firstEntry);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.exitDriver(firstEntry);
            throw throwable;
        }
    }

    public void runTestTask(String taskFileName) {
        block8: {
            boolean firstEntry = this.enterDriver();
            try {
                try {
                    this.checkConfigured();
                    JverTargetVector targetSets = new JverTargetVector();
                    try {
                        targetSets.readTaskFile(new File(taskFileName));
                    }
                    catch (FileNotFoundException e) {
                        String addPath = this.option.getAdditionalPath();
                        targetSets.readTaskFile(taskFileName, this.jverClassLoader_, addPath);
                    }
                    this.runTestsTargetVector(targetSets);
                }
                catch (FileNotFoundException e) {
                    IJverDriverMsg.JVERTASK_FAIL_OPEN.add(this.collector_, taskFileName);
                    Object var7_10 = null;
                    this.exitDriver(firstEntry);
                    break block8;
                }
                catch (IOException e) {
                    IJverDriverMsg.JVERTASK_FAIL_READ.add(this.collector_, e, taskFileName);
                    Object var7_11 = null;
                    this.exitDriver(firstEntry);
                    break block8;
                }
                catch (JverProcessException e) {
                    this.collector_.addWarning(e);
                    Object var7_12 = null;
                    this.exitDriver(firstEntry);
                }
                Object var7_9 = null;
                this.exitDriver(firstEntry);
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                this.exitDriver(firstEntry);
                throw throwable;
            }
        }
    }

    public boolean loadTestClass(String name) throws ClassNotFoundException, JverProcessException {
        Class clazz = null;
        this.checkConfigured();
        if (!JverCheckTestClass.isTestClassName(name)) {
            IJverDriverMsg.CLASS_NAMING_CONVENTION.add(this.collector_, name);
        } else {
            String loadPath = this.getOption().getAdditionalPath();
            clazz = this.jverClassLoader_.loadClassForName(name, loadPath);
        }
        return this.setCurrentTestClass(clazz, true);
    }

    public boolean setTestClassSelectionFromPackages(String[] packages) {
        try {
            this.currentSelection_ = null;
            JverTargetVector targetSets = new JverTargetVector();
            targetSets.readList(packages);
            this.currentSelection_ = this.getTestClasses(targetSets, false);
        }
        catch (JverProcessException e) {
            this.collector_.addWarning(e);
        }
        return this.currentSelection_ != null && this.currentSelection_.hasMoreElements();
    }

    public boolean setTestClassSelection(String[] targets) {
        JverTargetVector targetSets = new JverTargetVector();
        targetSets.readList(targets);
        this.currentSelection_ = null;
        try {
            this.currentSelection_ = this.getTestClasses(targetSets, true);
        }
        catch (JverProcessException e) {
            this.collector_.addWarning(e);
        }
        return this.currentSelection_ != null && this.currentSelection_.hasMoreElements();
    }

    public boolean setNextTestClassFromSelection() {
        Class clazz = null;
        this.setCurrentTestClass(null, false);
        while (this.currentSelection_.hasMoreElements()) {
            clazz = (Class)this.currentSelection_.nextElement();
            if (this.currentSelection_ instanceof IJverClassEnumeration) {
                this.setCurrentTestClassParameterFile(((IJverClassEnumeration)this.currentSelection_).getCurrentPropertyFile());
            }
            if (this.setCurrentTestClass(clazz, !this.getOption().isPreselection())) break;
        }
        return this.currentTestClass_ != null;
    }

    public Enumeration getTestClassSelection() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return JverDriver.this.currentSelection_.hasMoreElements();
            }

            public Object nextElement() {
                String name = ((Class)JverDriver.this.currentSelection_.nextElement()).getName();
                return name;
            }
        };
    }

    public void runCurrentTestClass() {
        try {
            try {
                Class testClass = this.getCurrentTestClassAssert();
                this.collector_.announceTestsetStart(testClass.getName());
                IJverTestAttributesInternal attributes = this.getAttributesCurrentTest();
                this.runSingleTestClass(testClass, attributes);
            }
            catch (JverProcessException e) {
                this.collector_.add(e);
                Object var4_5 = null;
                this.collector_.announceTestsetEnd();
            }
            Object var4_4 = null;
            this.collector_.announceTestsetEnd();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.collector_.announceTestsetEnd();
            throw throwable;
        }
    }

    public void runCurrentTestClass(IJverTestAttributesInternal attributes) throws JverProcessException {
        try {
            Class testClass = this.getCurrentTestClassAssert();
            this.collector_.announceTestsetStart(testClass.getName());
            this.runSingleTestClass(testClass, attributes);
            Object var4_3 = null;
            this.collector_.announceTestsetEnd();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.collector_.announceTestsetEnd();
            throw throwable;
        }
    }

    public IJverTestAttributesInternal getAttributesCurrentTest() throws JverProcessException {
        if (this.currentAttributes_ == null) {
            Class currentTestClass = this.getCurrentTestClassAssert();
            this.currentAttributes_ = this.getRunner().readTestAttributes(currentTestClass);
            if (this.currentAttributes_ != null && !this.setParametersFromFile(this.getCurrentTestClassParameterFile())) {
                this.setParametersFromFileArgument(this.currentAttributes_);
            }
        }
        return this.currentAttributes_;
    }

    public String getCurrentTestClassTitle(Locale locale) throws JverProcessException {
        this.checkConfigured();
        IJverTestAttributesInternal attributes = this.getAttributesCurrentTest();
        String loadPath = this.getOption().getAdditionalPath();
        ClassLoader loader = this.jverClassLoader_.getClassLoader(loadPath);
        String title = attributes.getTitle(locale, loader);
        return title;
    }

    public String getCurrentTestClassTitle() throws JverProcessException {
        return this.getCurrentTestClassTitle(Locale.getDefault());
    }

    public boolean setParametersFromFile(File file) throws JverProcessException {
        return this.setParametersFromFile(this.getAttributesCurrentTest(), file);
    }

    private boolean setParametersFromFile(IJverTestAttributesInternal attributes, File file) {
        boolean success = false;
        JverProcessException pe = null;
        if (file != null) {
            try {
                attributes.loadParametersFromFile(file);
                success = true;
            }
            catch (JverRuntimeException e) {
                pe = new JverProcessException(e);
            }
            catch (FileNotFoundException e) {
                String id = "ParameterFromFile-FileNotFound";
                pe = new JverProcessException(e.getLocalizedMessage(), id);
            }
            catch (IOException e) {
                String id = "ParameterFromFile-IOException";
                pe = new JverProcessException(e.getLocalizedMessage(), id);
            }
        }
        if (pe != null) {
            this.collector_.addWarning(pe);
        }
        return success;
    }

    private void setParametersFromFileArgument(IJverTestAttributesInternal attributes) {
        if (this.commonTestParameter_ != null) {
            attributes.syncWithDefinedParametersDontWarn(this.commonTestParameter_);
        }
    }

    protected synchronized void requestAbortion() {
        this.isAbortionRequested_ = true;
    }

    public synchronized boolean isAbortionRequested() {
        return this.isAbortionRequested_;
    }

    public void finish() {
        if (!this.isFinished) {
            DbgLog.finish();
            JverLogPerf.finish();
            this.isFinished = true;
        }
    }

    public void logThrowable(String goodBye, Throwable throwable) {
        String logFileName;
        if (this.isFinished && (logFileName = this.option.getDbgLogFile()) != null) {
            try {
                DbgLog.init(logFileName, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DbgLog.println("");
        DbgLog.println(goodBye);
        DbgLog.printStackTrace(throwable);
    }

    public int getJverReturnCode() {
        int rc = 0;
        if (this.collector_.getFlopCount() > 0) {
            rc |= 1;
        }
        if (this.collector_.getWarningCount() > 0) {
            rc |= 2;
        }
        return rc;
    }

    private void configureListener(IJverClassLoader loader) {
        Vector<IJverListener> listeners = new Vector<IJverListener>();
        IJverListener listener = null;
        String customListener = this.option.getCustomListenerName();
        if (customListener != null) {
            String fallback = "using standard listener";
            listener = this.loadListener(loader, customListener, fallback);
        }
        if (listener == null) {
            listener = this.getStandardListener();
        }
        listener.setAdditionalStackFilter(this.option.getAdditionalStackFilter());
        listeners.add(listener);
        Vector addListenerNames = this.option.getAdditionalListenerNames();
        if (addListenerNames != null) {
            int ii = 0;
            while (ii < addListenerNames.size()) {
                String fallback;
                customListener = (String)addListenerNames.get(ii);
                listener = this.loadListener(loader, customListener, fallback = "ignore listener.");
                if (listener != null) {
                    listeners.add(listener);
                }
                ++ii;
            }
        }
        IJverListener[] arrListeners = new IJverListener[listeners.size()];
        listeners.toArray(arrListeners);
        this.collector_.setListeners(arrListeners);
    }

    protected IJverListener getStandardListener() {
        AJverListener listener = null;
        listener = this.option.isXmlOutput() ? (this.option.isVerbose() ? new JverListenerXmlVerbose(this.stdOutputChannel) : new JverListenerXml(this.stdOutputChannel)) : (this.option.isVerbose() ? new JverListenerVerbose(this.stdOutputChannel) : (this.option.isSilent() ? new JverListenerSilent(this.stdOutputChannel) : new JverListenerConcise(this.stdOutputChannel)));
        boolean internal = this.config_.getBooleanValue("debug.internal.msg", false);
        ((AJverListener)listener).setInternalMode(internal);
        return listener;
    }

    private IJverListener loadListener(IJverClassLoader loader, String customListener, String sFallback) {
        Class listenerClass = null;
        IJverListener listener = null;
        try {
            listenerClass = loader.loadClassForName(customListener, this.option.getAdditionalPath());
            listener = (IJverListener)listenerClass.newInstance();
            DbgLog.println("Using custom listener: " + listenerClass.getName());
        }
        catch (ClassNotFoundException e) {
            DbgLog.println("Could not find " + customListener + " in VM classpath: " + sFallback);
        }
        catch (ClassCastException e) {
            DbgLog.println("Not a IJverListener implementation: " + customListener + "- " + sFallback);
        }
        catch (Exception e) {
            DbgLog.println("Could not create " + customListener + ": " + sFallback);
            DbgLog.printStackTrace(e);
        }
        return listener;
    }

    private void runSingleTestClass(Class clazz, IJverTestAttributesInternal attributes) {
        this.getRunner().runTestClass(clazz, attributes, this.config_);
    }

    private void runTestsTargetVector(JverTargetVector targetSets) throws JverProcessException {
        this.collector_.announceTestTaskStart(targetSets.size());
        this.currentSelection_ = this.getTestClasses(targetSets, this.option.isClassTargets());
        while (this.setNextTestClassFromSelection() && !this.isAbortionRequested()) {
            this.runCurrentTestClass();
        }
    }

    private Enumeration getTestClasses(JverTargetVector targetSets, boolean isClassTargets) throws JverProcessException {
        this.checkConfigured();
        this.setCurrentTestClass(null, false);
        JverClassManager classManager = new JverClassManager();
        classManager.init(this.jverClassLoader_, this.collector_);
        classManager.createScanner(isClassTargets, this.option.isAlternativeScanner(), this.option.getAlternativeScannerName());
        classManager.setTargets(this.config_, targetSets, this.getOption().getAdditionalPath());
        Enumeration classes = classManager.elements();
        return classes;
    }

    private boolean isDerivedFromTest(Class clazz, boolean doWarn) {
        boolean isDerived = (class$com$sap$tc$jtools$jver$framework$Test == null ? (class$com$sap$tc$jtools$jver$framework$Test = JverDriver.class$("com.sap.tc.jtools.jver.framework.Test")) : class$com$sap$tc$jtools$jver$framework$Test).isAssignableFrom(clazz);
        boolean isTestBaseClass = (class$com$sap$tc$jtools$jver$framework$Test == null ? (class$com$sap$tc$jtools$jver$framework$Test = JverDriver.class$("com.sap.tc.jtools.jver.framework.Test")) : class$com$sap$tc$jtools$jver$framework$Test).equals(clazz);
        if (!isDerived && doWarn) {
            IJverDriverMsg.NOT_A_JVER_TEST_CLASS.add(this.collector_, clazz.getName());
        }
        return isDerived && !isTestBaseClass;
    }

    private boolean setCurrentTestClass(Class clazz, boolean doWarn) {
        boolean valid = false;
        if (clazz != null) {
            valid = this.isDerivedFromTest(clazz, doWarn);
        }
        this.currentTestClass_ = valid ? clazz : null;
        this.currentAttributes_ = null;
        return valid;
    }

    private Class getCurrentTestClassAssert() throws JverProcessException {
        if (this.currentTestClass_ == null) {
            throw new JverProcessException("Assert: current test must be loaded (setNextTestClassFromSelection/loadTestClass) before being used!", "Usage");
        }
        return this.currentTestClass_;
    }

    public void setCurrentTestClassParameterFile(File value) {
        this.currentTestClassParameterFile_ = value;
    }

    private File getCurrentTestClassParameterFile() {
        return this.currentTestClassParameterFile_;
    }

    public String getCurrentTestClassName() {
        if (this.currentTestClass_ == null) {
            return "";
        }
        return this.currentTestClass_.getName();
    }

    private void setOption(JverOption option) {
        this.option = option;
    }

    private JverOption getOption() {
        if (this.option == null) {
            this.setOption(new JverOption());
        }
        return this.option;
    }

    private void checkConfigured() throws JverProcessException {
        if (!this.isConfigured_) {
            this.configure();
        }
    }

    private void setConfigured() {
        this.isConfigured_ = true;
    }

    private JverTestClassRunner getRunner() {
        return this.runner_;
    }

    public JverConfig getJverConfig() {
        return this.config_;
    }

    public String getDbgLogFileName() {
        return this.dbgLogFileName_;
    }

    public void setClassLoaderParent(ClassLoader value) {
        this.parentClassLoader_ = value;
    }

    private boolean enterDriver() {
        boolean isFirstEntry = this.NoTestRunYet_;
        this.NoTestRunYet_ = false;
        return isFirstEntry;
    }

    private void exitDriver(boolean firstEntry) {
        if (firstEntry) {
            this.collector_.announceTestTaskEnd(this.collector_);
            this.finish();
        }
    }

    public IJverPrinter getStdOutputChannel() {
        return this.stdOutputChannel;
    }

    public void setStdOutputChannel(IJverPrinter stdOutputChannel) {
        this.stdOutputChannel = stdOutputChannel;
    }

    protected void saveCmdLine(String driverName, String[] args) {
        String extDirs;
        StringBuffer buffer = new StringBuffer();
        buffer.append("cmd:  ");
        buffer.append("java ");
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            buffer.append(" -cp ");
            buffer.append(classPath);
            buffer.append(' ');
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            buffer.append(" -Djava.ext.dirs=");
            buffer.append(extDirs);
            buffer.append(' ');
        }
        buffer.append(driverName);
        int ii = 0;
        while (ii < args.length) {
            buffer.append(' ');
            buffer.append(args[ii]);
            ++ii;
        }
        this.saveCmdLine_ = buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

