/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.IJverRunnerSettings;
import com.sap.tc.jtools.jver.core.IJverTestAttributesInternal;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.driver.JverFixtureInstantiatePerTestMethod;
import com.sap.tc.jtools.jver.driver.JverFixturePerTestMethod;
import com.sap.tc.jtools.jver.driver.JverFixturePerTestSet;
import com.sap.tc.jtools.jver.driver.JverIllegalStateException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;

abstract class AJverMethodRunner
implements IJverRunnerSettings {
    private IJverTestAttributesInternal attributes_ = null;
    private Class testClass_ = null;
    private IJverFixture fixture_ = null;
    protected IMsgCollector msgCollector_ = null;
    protected static final Class[] noArg_ = new Class[0];
    private boolean errorFlag_ = false;

    protected AJverMethodRunner(IMsgCollector msgCollector) {
        this.msgCollector_ = msgCollector;
    }

    public void init(Class testClass, IJverTestAttributesInternal attributes) {
        this.setTestClass(testClass);
        this.setTestAttributes(attributes);
        this.clearErrorFlag();
        if (this.attributes_.isInstantiationPerTestMethod()) {
            this.setTestFixture(new JverFixtureInstantiatePerTestMethod(this.msgCollector_, attributes));
        } else if (this.attributes_.isFixturePerTestMethod()) {
            this.setTestFixture(new JverFixturePerTestMethod(this.msgCollector_, attributes));
        } else if (this.attributes_.isFixturePerTestSet()) {
            this.setTestFixture(new JverFixturePerTestSet(this.msgCollector_, attributes));
        } else {
            throw new JverIllegalStateException(this.getClass().getName(), "init");
        }
    }

    public IJverTestAttributesInternal getTestAttributes() {
        return this.attributes_;
    }

    public Class getTestClass() {
        return this.testClass_;
    }

    protected abstract void runTestMethods() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception;

    private void setTestAttributes(IJverTestAttributesInternal attributes) {
        this.attributes_ = attributes;
    }

    private void setTestClass(Class testClass) {
        this.testClass_ = testClass;
    }

    protected void setTestFixture(IJverFixture fixture) {
        this.fixture_ = fixture;
    }

    protected IJverFixture getTestFixture() {
        return this.fixture_;
    }

    public void clearErrorFlag() {
        this.errorFlag_ = false;
    }

    public boolean isSuccessfull() {
        return !this.errorFlag_;
    }

    protected void setErrorFlag() {
        this.errorFlag_ = true;
    }

    public abstract int getTestMethodCount();

    public abstract Enumeration getTestMethods();
}

